/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.FileStreamAccess;
import fm.icelink.IFileStream;
import java.io.File;
import java.io.RandomAccessFile;

public class FileStream
implements IFileStream {
    private String _path;
    private RandomAccessFile _file;

    @Override
    public String getPath() {
        return this._path;
    }

    public FileStream(String path) {
        this._path = path;
    }

    @Override
    public long getLength() {
        try {
            if (this._file == null) {
                return 0L;
            }
            return this._file.length();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public long getPosition() {
        try {
            if (this._file == null) {
                return 0L;
            }
            return this._file.getFilePointer();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void setPosition(long position) {
        try {
            if (this._file != null) {
                this._file.seek(position);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean exists() {
        return new File(this._path).exists();
    }

    @Override
    public void open(FileStreamAccess access) {
        try {
            if (access == FileStreamAccess.Read) {
                this._file = new RandomAccessFile(this._path, "r");
            } else if (access == FileStreamAccess.Write) {
                this._file = new RandomAccessFile(this._path, "rw");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() {
        try {
            if (this._file != null) {
                this._file.close();
                this._file = null;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean flush() {
        if (this._file == null) {
            return false;
        }
        try {
            this._file.getFD().sync();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return true;
    }

    @Override
    public boolean write(byte[] data, int index, int length) {
        if (this._file == null) {
            return false;
        }
        try {
            this._file.write(data, index, length);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean writeTo(int location, byte[] data, int index, int length) {
        if (this._file == null) {
            return false;
        }
        try {
            long position = this._file.getFilePointer();
            this._file.seek(location);
            this._file.write(data, index, length);
            this._file.seek(position);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public int read(byte[] data, int index, int length) {
        if (this._file == null) {
            return 0;
        }
        try {
            return this._file.read(data, index, length);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }
}

