/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.CompareResult;
import fm.icelink.DataBuffer;
import fm.icelink.FecMaskType;
import fm.icelink.FecPacket;
import fm.icelink.FecPacketMaskTable;
import fm.icelink.FecProtectedPacket;
import fm.icelink.FecProtectionMode;
import fm.icelink.FecReceivedPacket;
import fm.icelink.FecRecoveredPacket;
import fm.icelink.FecSortablePacket;
import fm.icelink.Global;
import fm.icelink.IFunction2;
import fm.icelink.IFunctionDelegate2;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.MathAssistant;
import fm.icelink.Sort;
import fm.icelink.StringExtensions;
import java.util.ArrayList;

class FecContext {
    private ArrayList<FecPacket> _fecPacketList = new ArrayList();
    private boolean _fecPacketReceived;
    private DataBuffer[] _generatedFecPackets;

    private static void assignRecoveredPackets(FecPacket fecPacket, ArrayList<FecRecoveredPacket> recoveredPackets) {
        ArrayList<FecProtectedPacket> protectedPacketList = fecPacket.getProtectedPacketList();
        ArrayList<FecRecoveredPacket> result = new ArrayList<FecRecoveredPacket>();
        FecContext.setIntersection(recoveredPackets, 0, ArrayListExtensions.getCount(recoveredPackets), protectedPacketList, 0, ArrayListExtensions.getCount(protectedPacketList), result, (IFunction2<FecSortablePacket, FecSortablePacket, CompareResult>)new IFunctionDelegate2<FecSortablePacket, FecSortablePacket, CompareResult>(){

            @Override
            public String getId() {
                return "fm.icelink.FecContext.sortablePacketLessThan";
            }

            @Override
            public CompareResult invoke(FecSortablePacket first, FecSortablePacket second) {
                return FecContext.sortablePacketLessThan(first, second);
            }
        });
        int num = 0;
        for (int i = 0; i != ArrayListExtensions.getCount(result); ++i) {
            while (ArrayListExtensions.getItem(protectedPacketList).get(num).getSequenceNumber() != ArrayListExtensions.getItem(result).get(i).getSequenceNumber()) {
                if (++num < ArrayListExtensions.getCount(protectedPacketList)) continue;
                Log.error("Could not find unrecovered packet in FEC context.");
                break;
            }
            if (num >= ArrayListExtensions.getCount(protectedPacketList)) continue;
            ArrayListExtensions.getItem(protectedPacketList).get(num).setRaw(ArrayListExtensions.getItem(result).get(i).getRaw());
        }
    }

    private void attemptRecover(ArrayList<FecRecoveredPacket> recoveredPacketList) {
        int index = 0;
        while (index != ArrayListExtensions.getCount(this._fecPacketList)) {
            int num2 = FecContext.numCoveredPacketsMissing(ArrayListExtensions.getItem(this._fecPacketList).get(index));
            if (num2 == 1) {
                FecRecoveredPacket recPacketToInsert = new FecRecoveredPacket();
                recPacketToInsert.setRaw(null);
                FecContext.recoverPacket(ArrayListExtensions.getItem(this._fecPacketList).get(index), recPacketToInsert);
                recoveredPacketList.add(recPacketToInsert);
                Sort.quickSort(recoveredPacketList, new IFunctionDelegate2<FecRecoveredPacket, FecRecoveredPacket, CompareResult>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.FecContext.recoveredPacketLessThan";
                    }

                    @Override
                    public CompareResult invoke(FecRecoveredPacket first, FecRecoveredPacket second) {
                        return FecContext.recoveredPacketLessThan(first, second);
                    }
                });
                this.updateCoveringFECPackets(recPacketToInsert);
                FecContext.discardOldPackets(recoveredPacketList);
                FecContext.discardFECPacket(ArrayListExtensions.getItem(this._fecPacketList).get(index));
                ArrayListExtensions.removeAt(this._fecPacketList, index);
                index = 0;
                continue;
            }
            if (num2 == 0) {
                FecContext.discardFECPacket(ArrayListExtensions.getItem(this._fecPacketList).get(index));
                ArrayListExtensions.removeAt(this._fecPacketList, index);
                continue;
            }
            ++index;
        }
    }

    private static void blockCopy(DataBuffer destination, DataBuffer source, int num) {
        FecContext.blockCopy(destination, 0, source, 0, num);
    }

    private static void blockCopy(DataBuffer destination, int destinationOffset, DataBuffer source, int sourceOffset, int num) {
        destination.write(source.subset(sourceOffset, num), destinationOffset);
    }

    private static int constrain16(int value) {
        while (value < 0) {
            value += 65536;
        }
        while (value > 65535) {
            value -= 65536;
        }
        return value;
    }

    private static void copyColumn(DataBuffer newMask, int newMaskBytes, DataBuffer oldMask, int oldMaskBytes, int numFecPackets, int newBitIndex, int oldBitIndex) {
        for (int i = 0; i < numFecPackets; ++i) {
            int offset = i * newMaskBytes + newBitIndex / 8;
            int num3 = i * oldMaskBytes + oldBitIndex / 8;
            newMask.write8(newMask.read8(offset) | (byte)((oldMask.read8(num3) & 0x80) >> 7), offset);
            if (newBitIndex % 8 != 7) {
                newMask.set(BitAssistant.leftShift((byte)newMask.read8(offset), 1), offset, 1);
            }
            oldMask.set(BitAssistant.leftShift((byte)oldMask.read8(num3), 1), num3, 1);
        }
    }

    public boolean decode(ArrayList<FecReceivedPacket> receivedPacketList, ArrayList<FecRecoveredPacket> recoveredPacketList) {
        if (ArrayListExtensions.getCount(recoveredPacketList) == 48 && !ArrayListExtensions.getItem(receivedPacketList).get(0).getIsFec() && MathAssistant.abs(ArrayListExtensions.getItem(receivedPacketList).get(0).getSequenceNumber() - ArrayListExtensions.getItem(recoveredPacketList).get(ArrayListExtensions.getCount(recoveredPacketList) - 1).getSequenceNumber()) > 48) {
            this.resetState(recoveredPacketList);
        }
        this.insertPackets(receivedPacketList, recoveredPacketList);
        this.attemptRecover(recoveredPacketList);
        return true;
    }

    private static void discardFECPacket(FecPacket fecPacket) {
        while (ArrayListExtensions.getCount(fecPacket.getProtectedPacketList()) != 0) {
            ArrayListExtensions.removeAt(fecPacket.getProtectedPacketList(), 0);
        }
        FecContext.verify(ArrayListExtensions.getCount(fecPacket.getProtectedPacketList()) == 0);
    }

    private static void discardOldPackets(ArrayList<FecRecoveredPacket> recoveredPacketList) {
        while (ArrayListExtensions.getCount(recoveredPacketList) > 48) {
            if (!ArrayListExtensions.getItem(recoveredPacketList).get(0).getReturned()) {
                Log.warn("Unrecovered packet being dropped.");
            }
            ArrayListExtensions.removeAt(recoveredPacketList, 0);
        }
        FecContext.verify(ArrayListExtensions.getCount(recoveredPacketList) <= 48);
    }

    public FecContext() {
        this.setFecPacketReceived(false);
    }

    private static void finishRecovery(FecRecoveredPacket recovered) {
        recovered.getRaw().write1(true, 0, 0);
        recovered.getRaw().write1(false, 0, 1);
        recovered.getRaw().write16(recovered.getSequenceNumber(), 2);
        recovered.shrinkPacket(recovered.getLengthRecovery().read16(0) + 12);
    }

    private void fitSubMask(int numMaskBytes, int numSubMaskBytes, int numRows, byte[] subMask, DataBuffer packetMask, int packetMaskOffset) {
        if (numMaskBytes == numSubMaskBytes) {
            packetMask.writeBytes(subMask, 0, numRows * numSubMaskBytes, packetMaskOffset);
        } else {
            for (int i = 0; i < numRows; ++i) {
                int num2 = i * numMaskBytes;
                int index = i * numSubMaskBytes;
                for (int j = 0; j < numSubMaskBytes; ++j) {
                    packetMask.write8(subMask[index], packetMaskOffset + num2);
                    ++num2;
                    ++index;
                }
            }
        }
    }

    private void fitSubMask(int numMaskBytes, int numSubMaskBytes, int numRows, byte[] subMask, DataBuffer packetMask) {
        this.fitSubMask(numMaskBytes, numSubMaskBytes, numRows, subMask, packetMask, 0);
    }

    public boolean generate(ArrayList<DataBuffer> mediaPackets, int protectionFactor, int numImportantPackets, boolean useUnequalProtection, FecMaskType maskType, ArrayList<DataBuffer> packetList) {
        int count = ArrayListExtensions.getCount(mediaPackets);
        protectionFactor = MathAssistant.max(0, MathAssistant.min(255, protectionFactor));
        FecContext.verify(count > 0);
        FecContext.verify(numImportantPackets >= 0 && numImportantPackets <= count);
        FecContext.verify(ArrayListExtensions.getCount(packetList) == 0);
        if (count > 48) {
            int num5 = 48;
            Log.warn(StringExtensions.format("Can't protect {0} media packets per frame. Max is {1}.", IntegerExtensions.toString(count), IntegerExtensions.toString(num5)));
            return false;
        }
        int numMaskBytes = count > 16 ? 6 : 2;
        for (DataBuffer buffer : mediaPackets) {
            FecContext.verify(buffer != null);
            if (buffer.getLength() < 12) {
                Log.warn(StringExtensions.format("Media packet {0} bytes is smaller than RTP header.", IntegerExtensions.toString(buffer.getLength())));
                return false;
            }
            if (buffer.getLength() + FecContext.getPacketOverhead() + 28 <= FecContext.getIPPacketSize()) continue;
            Log.warn(StringExtensions.format("Media packet {0} bytes with overhead is larger than {1}.", IntegerExtensions.toString(buffer.getLength()), IntegerExtensions.toString(FecContext.getIPPacketSize())));
        }
        int numberOfFecPackets = this.getNumberOfFecPackets(count, protectionFactor);
        if (numberOfFecPackets != 0) {
            boolean lBit;
            this._generatedFecPackets = new DataBuffer[numberOfFecPackets];
            FecPacketMaskTable maskTable = new FecPacketMaskTable(maskType, count);
            DataBuffer packetMask = DataBuffer.allocate(numberOfFecPackets * 6);
            this.generatePacketMasks(count, numberOfFecPackets, numImportantPackets, useUnequalProtection, maskTable, packetMask);
            int num4 = this.insertZerosInBitMasks(mediaPackets, packetMask, numMaskBytes, numberOfFecPackets);
            boolean bl = lBit = num4 > 16;
            if (num4 < 0) {
                return false;
            }
            if (lBit) {
                numMaskBytes = 6;
            }
            this.generateFecBitStrings(mediaPackets, packetMask, numberOfFecPackets, lBit);
            this.generateFecUlpHeaders(mediaPackets, packetMask, lBit, numberOfFecPackets);
            ArrayListExtensions.addRange(packetList, this._generatedFecPackets);
        }
        return true;
    }

    private void generateFecBitStrings(ArrayList<DataBuffer> mediaPacketList, DataBuffer packetMask, int numFecPackets, boolean lBit) {
        if (ArrayListExtensions.getCount(mediaPacketList) != 0) {
            int num5;
            DataBuffer source = DataBuffer.allocate(2);
            int num = lBit ? 6 : 2;
            int num2 = lBit ? 8 : 4;
            int num3 = 10 + num2 - 12;
            int num4 = 0;
            for (num5 = 0; num5 < ArrayListExtensions.getCount(mediaPacketList); ++num5) {
                num4 = MathAssistant.max(num4, ArrayListExtensions.getItem(mediaPacketList).get(num5).getLength());
            }
            for (num5 = 0; num5 < numFecPackets; ++num5) {
                int num6 = 0;
                int offset = num5 * num;
                int num8 = 0;
                int num9 = 0;
                int num10 = FecContext.parseSequenceNumber(ArrayListExtensions.getItem(mediaPacketList).get(num6));
                while (num6 != ArrayListExtensions.getCount(mediaPacketList)) {
                    if ((packetMask.read8(offset) & 1 << 7 - num8) > 0) {
                        DataBuffer buffer2 = ArrayListExtensions.getItem(mediaPacketList).get(num6);
                        source.write16(buffer2.getLength() - 12, 0);
                        num9 = buffer2.getLength() + num3;
                        if (this._generatedFecPackets[num5] == null) {
                            this._generatedFecPackets[num5] = DataBuffer.allocate(num4 + num3);
                            FecContext.blockCopy(this._generatedFecPackets[num5], buffer2, 2);
                            FecContext.blockCopy(this._generatedFecPackets[num5], 4, buffer2, 4, 4);
                            FecContext.blockCopy(this._generatedFecPackets[num5], 8, source, 0, 2);
                            FecContext.blockCopy(this._generatedFecPackets[num5], 10 + num2, buffer2, 12, buffer2.getLength() - 12);
                        } else {
                            int num11;
                            this._generatedFecPackets[num5].write8(this._generatedFecPackets[num5].read8(0) ^ buffer2.read8(0), 0);
                            this._generatedFecPackets[num5].write8(this._generatedFecPackets[num5].read8(1) ^ buffer2.read8(1), 1);
                            for (num11 = 4; num11 < 8; ++num11) {
                                this._generatedFecPackets[num5].write8(this._generatedFecPackets[num5].read8(num11) ^ buffer2.read8(num11), num11);
                            }
                            this._generatedFecPackets[num5].write8(this._generatedFecPackets[num5].read8(8) ^ source.read8(0), 8);
                            this._generatedFecPackets[num5].write8(this._generatedFecPackets[num5].read8(9) ^ source.read8(1), 9);
                            for (num11 = 10 + num2; num11 < num9; ++num11) {
                                this._generatedFecPackets[num5].write8(this._generatedFecPackets[num5].read8(num11) ^ buffer2.read8(num11 - num3), num11);
                            }
                        }
                    }
                    if (++num6 != ArrayListExtensions.getCount(mediaPacketList)) {
                        int num12 = FecContext.parseSequenceNumber(ArrayListExtensions.getItem(mediaPacketList).get(num6));
                        num8 += FecContext.constrain16(num12 - num10);
                        num10 = num12;
                    }
                    if (num8 != 8) continue;
                    num8 = 0;
                    ++offset;
                }
                FecContext.verify(this._generatedFecPackets[num5].getLength() != 0);
            }
        }
    }

    private void generateFecUlpHeaders(ArrayList<DataBuffer> mediaPacketList, DataBuffer packetMask, boolean lBit, int numFecPackets) {
        DataBuffer buffer = ArrayListExtensions.getItem(mediaPacketList).get(0);
        FecContext.verify(buffer != null);
        int length = lBit ? 6 : 2;
        int num2 = lBit ? 8 : 4;
        for (int i = 0; i < numFecPackets; ++i) {
            this._generatedFecPackets[i].and(127, 0);
            if (!lBit) {
                this._generatedFecPackets[i].and(191, 0);
            } else {
                this._generatedFecPackets[i].or(64, 0);
            }
            this._generatedFecPackets[i].write(buffer.subset(2, 2), 2);
            this._generatedFecPackets[i].write16(this._generatedFecPackets[i].getLength() - 10 - num2, 10);
            this._generatedFecPackets[i].write(packetMask.subset(i * length, length), 12);
        }
    }

    private void generatePacketMasks(int numMediaPackets, int numFecPackets, int numImpPackets, boolean useUnequalProtection, FecPacketMaskTable maskTable, DataBuffer packetMask) {
        int numMaskBytes;
        FecContext.verify(numMediaPackets > 0);
        FecContext.verify(numFecPackets <= numMediaPackets && numFecPackets > 0);
        FecContext.verify(numImpPackets <= numMediaPackets && numImpPackets >= 0);
        boolean num = numMediaPackets > 16;
        int n = numMaskBytes = num ? 6 : 2;
        if (!useUnequalProtection || numImpPackets == 0) {
            packetMask.writeBytes(maskTable.getTable()[numMediaPackets - 1][numFecPackets - 1], 0, numFecPackets * numMaskBytes, 0);
        } else {
            this.unequalProtectionMask(numMediaPackets, numFecPackets, numImpPackets, numMaskBytes, packetMask, maskTable);
        }
    }

    public boolean getFecPacketReceived() {
        return this._fecPacketReceived;
    }

    public static int getIPPacketSize() {
        return 1500;
    }

    public static int getMaxMediaPackets() {
        return 48;
    }

    public int getNumberOfFecPackets(int numMediaPackets, int protectionFactor) {
        int num = numMediaPackets * protectionFactor + 128 >> 8;
        if (protectionFactor > 0 && num == 0) {
            num = 1;
        }
        FecContext.verify(num <= numMediaPackets);
        return num;
    }

    public static int getPacketOverhead() {
        return 18;
    }

    private void importantPacketProtection(int numFecForImpPackets, int numImpPackets, int numMaskBytes, DataBuffer packetMask, FecPacketMaskTable maskTable) {
        boolean num = numImpPackets > 16;
        int numSubMaskBytes = num ? 6 : 2;
        byte[] subMask = maskTable.getTable()[numImpPackets - 1][numFecForImpPackets - 1];
        this.fitSubMask(numMaskBytes, numSubMaskBytes, numFecForImpPackets, subMask, packetMask);
    }

    private static void initRecovery(FecPacket fecPacket, FecRecoveredPacket recovered) {
        int num = (fecPacket.getRaw().read8(0) & 0x40) != 0 ? 8 : 4;
        recovered.setRaw(DataBuffer.allocate(FecContext.getIPPacketSize()));
        recovered.setReturned(false);
        recovered.setWasRecovered(true);
        DataBuffer destination = DataBuffer.allocate(2);
        FecContext.blockCopy(recovered.getLengthRecovery(), 0, fecPacket.getRaw(), 8, 2);
        FecContext.blockCopy(destination, 0, fecPacket.getRaw(), 10, 2);
        FecContext.blockCopy(recovered.getRaw(), 12, fecPacket.getRaw(), 10 + num, destination.read16(0));
        FecContext.blockCopy(recovered.getLengthRecovery(), 0, fecPacket.getRaw(), 8, 2);
        FecContext.blockCopy(recovered.getRaw(), fecPacket.getRaw(), 2);
        FecContext.blockCopy(recovered.getRaw(), 4, fecPacket.getRaw(), 4, 4);
        recovered.getRaw().write32(fecPacket.getSynchronizationSource(), 8);
    }

    private void insertFECPacket(FecReceivedPacket receivedPacket, ArrayList<FecRecoveredPacket> recoveredPacketList) {
        this.setFecPacketReceived(true);
        for (int i = 0; i != ArrayListExtensions.getCount(this._fecPacketList); ++i) {
            if (receivedPacket.getSequenceNumber() != ArrayListExtensions.getItem(this._fecPacketList).get(i).getSequenceNumber()) continue;
            receivedPacket.setRaw(null);
            return;
        }
        FecPacket fecPacket = new FecPacket();
        fecPacket.setRaw(receivedPacket.getRaw());
        fecPacket.setSequenceNumber(receivedPacket.getSequenceNumber());
        fecPacket.setSynchronizationSource(receivedPacket.getSynchronizationSource());
        int num2 = fecPacket.getRaw().read16(2);
        int num3 = (fecPacket.getRaw().read8(0) & 0x40) != 0 ? 6 : 2;
        for (int j = 0; j < num3; ++j) {
            byte num5 = (byte)fecPacket.getRaw().read8(12 + j);
            for (int k = 0; k < 8; ++k) {
                if ((BitAssistant.castInteger(num5) & 1 << 7 - k) <= 0) continue;
                FecProtectedPacket item = new FecProtectedPacket();
                fecPacket.getProtectedPacketList().add(item);
                item.setSequenceNumber(FecContext.constrain16(num2 + (j << 3) + k));
                item.setRaw(null);
            }
        }
        if (ArrayListExtensions.getCount(fecPacket.getProtectedPacketList()) == 0) {
            Log.warn("FEC packet has an all-zero packet mask.");
        } else {
            FecContext.assignRecoveredPackets(fecPacket, recoveredPacketList);
            this._fecPacketList.add(fecPacket);
            Sort.quickSort(this._fecPacketList, new IFunctionDelegate2<FecPacket, FecPacket, CompareResult>(){

                @Override
                public String getId() {
                    return "fm.icelink.FecContext.packetLessThan";
                }

                @Override
                public CompareResult invoke(FecPacket first, FecPacket second) {
                    return FecContext.packetLessThan(first, second);
                }
            });
            if (ArrayListExtensions.getCount(this._fecPacketList) > 48) {
                FecContext.discardFECPacket(ArrayListExtensions.getItem(this._fecPacketList).get(0));
                ArrayListExtensions.removeAt(this._fecPacketList, 0);
            }
            FecContext.verify(ArrayListExtensions.getCount(this._fecPacketList) <= 48);
        }
    }

    private void insertMediaPacket(FecReceivedPacket receivedPacket, ArrayList<FecRecoveredPacket> recoveredPacketList) {
        for (int i = 0; i != ArrayListExtensions.getCount(recoveredPacketList); ++i) {
            if (receivedPacket.getSequenceNumber() != ArrayListExtensions.getItem(recoveredPacketList).get(i).getSequenceNumber()) continue;
            receivedPacket.setRaw(null);
            return;
        }
        FecRecoveredPacket item = new FecRecoveredPacket();
        item.setWasRecovered(false);
        item.setReturned(true);
        item.setSequenceNumber(receivedPacket.getSequenceNumber());
        item.setRaw(receivedPacket.getRaw());
        recoveredPacketList.add(item);
        Sort.quickSort(recoveredPacketList, new IFunctionDelegate2<FecRecoveredPacket, FecRecoveredPacket, CompareResult>(){

            @Override
            public String getId() {
                return "fm.icelink.FecContext.recoveredPacketLessThan";
            }

            @Override
            public CompareResult invoke(FecRecoveredPacket first, FecRecoveredPacket second) {
                return FecContext.recoveredPacketLessThan(first, second);
            }
        });
        this.updateCoveringFECPackets(item);
    }

    private void insertPackets(ArrayList<FecReceivedPacket> receivedPacketList, ArrayList<FecRecoveredPacket> recoveredPacketList) {
        while (ArrayListExtensions.getCount(receivedPacketList) != 0) {
            FecReceivedPacket receivedPacket = ArrayListExtensions.getItem(receivedPacketList).get(0);
            if (ArrayListExtensions.getCount(this._fecPacketList) != 0 && MathAssistant.abs(receivedPacket.getSequenceNumber() - ArrayListExtensions.getItem(this._fecPacketList).get(0).getSequenceNumber()) > 16383) {
                FecContext.discardFECPacket(ArrayListExtensions.getItem(this._fecPacketList).get(0));
                ArrayListExtensions.removeAt(this._fecPacketList, 0);
            }
            if (receivedPacket.getIsFec()) {
                this.insertFECPacket(receivedPacket, recoveredPacketList);
            } else {
                this.insertMediaPacket(receivedPacket, recoveredPacketList);
            }
            ArrayListExtensions.removeAt(receivedPacketList, 0);
        }
        FecContext.verify(ArrayListExtensions.getCount(receivedPacketList) == 0);
        FecContext.discardOldPackets(recoveredPacketList);
    }

    private static void insertZeroColumns(int numZeros, DataBuffer newMask, int newMaskBytes, int numFecPackets, int newBitIndex) {
        for (int i = 0; i < numFecPackets; ++i) {
            int offset = i * newMaskBytes + newBitIndex / 8;
            int num3 = 7 - newBitIndex % 8;
            newMask.write8(BitAssistant.leftShift((byte)newMask.read8(offset), MathAssistant.min(numZeros, num3)), offset);
        }
    }

    private int insertZerosInBitMasks(ArrayList<DataBuffer> mediaPackets, DataBuffer packetMask, int numMaskBytes, int numFecPackets) {
        int num2;
        DataBuffer newMask = null;
        if (ArrayListExtensions.getCount(mediaPackets) <= 1) {
            return ArrayListExtensions.getCount(mediaPackets);
        }
        int num = FecContext.parseSequenceNumber(ArrayListExtensions.getItem(mediaPackets).get(ArrayListExtensions.getCount(mediaPackets) - 1));
        int num3 = FecContext.constrain16(num - (num2 = FecContext.parseSequenceNumber(ArrayListExtensions.getItem(mediaPackets).get(0)))) - ArrayListExtensions.getCount(mediaPackets) + 1;
        if (num3 == 0) {
            return ArrayListExtensions.getCount(mediaPackets);
        }
        int newMaskBytes = 2;
        if (ArrayListExtensions.getCount(mediaPackets) + num3 > 16) {
            newMaskBytes = 6;
        }
        newMask = DataBuffer.allocate(numFecPackets * 6);
        int num5 = 0;
        int num6 = num2;
        ++num5;
        FecContext.copyColumn(newMask, newMaskBytes, packetMask, numMaskBytes, numFecPackets, 0, 0);
        int newBitIndex = 1;
        int oldBitIndex = 1;
        while (num5 != ArrayListExtensions.getCount(mediaPackets) && newBitIndex != 48) {
            int num9 = FecContext.parseSequenceNumber(ArrayListExtensions.getItem(mediaPackets).get(num5));
            int numZeros = FecContext.constrain16(num9 - num6 - 1);
            if (numZeros > 0) {
                FecContext.insertZeroColumns(numZeros, newMask, newMaskBytes, numFecPackets, newBitIndex);
            }
            FecContext.copyColumn(newMask, newMaskBytes, packetMask, numMaskBytes, numFecPackets, newBitIndex += numZeros, oldBitIndex);
            ++newBitIndex;
            ++oldBitIndex;
            num6 = num9;
            ++num5;
        }
        if (newBitIndex % 8 != 0) {
            for (int i = 0; i < numFecPackets; ++i) {
                int offset = i * newMaskBytes + newBitIndex / 8;
                newMask.write8(BitAssistant.leftShift((byte)newMask.read8(offset), 7 - newBitIndex % 8), offset);
            }
        }
        FecContext.blockCopy(packetMask, newMask, 6 * numFecPackets);
        return newBitIndex;
    }

    private static boolean isNewerSequenceNumber(int sequenceNumber, int previousSequenceNumber) {
        return sequenceNumber != previousSequenceNumber && FecContext.constrain16(sequenceNumber - previousSequenceNumber) < 32768;
    }

    private static int lowerBound(ArrayList<FecProtectedPacket> array, int first, int last, FecRecoveredPacket val, IFunction2<FecSortablePacket, FecSortablePacket, CompareResult> comp) {
        int num = 0;
        int num2 = 0;
        int num3 = MathAssistant.abs(last - first);
        while (num3 > 0) {
            num = first;
            num2 = num3 / 2;
            if (Global.equals((Object)comp.invoke(ArrayListExtensions.getItem(array).get(num += num2), val), (Object)CompareResult.Negative)) {
                first = ++num;
                num3 -= num2 + 1;
                continue;
            }
            num3 = num2;
        }
        return first;
    }

    private static int numCoveredPacketsMissing(FecPacket fecPacket) {
        int num = 0;
        for (FecProtectedPacket packet : fecPacket.getProtectedPacketList()) {
            if (packet.getRaw() != null || ++num <= 1) continue;
            return num;
        }
        return num;
    }

    private static CompareResult packetLessThan(FecPacket first, FecPacket second) {
        return FecContext.sortablePacketLessThan(first, second);
    }

    private static int parseSequenceNumber(DataBuffer packet) {
        return packet.read16(2);
    }

    private static CompareResult recoveredPacketLessThan(FecRecoveredPacket first, FecRecoveredPacket second) {
        return FecContext.sortablePacketLessThan(first, second);
    }

    private static void recoverPacket(FecPacket fecPacket, FecRecoveredPacket recPacketToInsert) {
        FecContext.initRecovery(fecPacket, recPacketToInsert);
        for (FecProtectedPacket packet : fecPacket.getProtectedPacketList()) {
            if (packet.getRaw() == null) {
                recPacketToInsert.setSequenceNumber(packet.getSequenceNumber());
                continue;
            }
            FecContext.xorPackets(packet.getRaw(), recPacketToInsert);
        }
        FecContext.finishRecovery(recPacketToInsert);
    }

    private void remainingPacketProtection(int numMediaPackets, int numFecRemaining, int numFecForImpPackets, int numMaskBytes, FecProtectionMode mode, DataBuffer packetMask, FecPacketMaskTable maskTable) {
        if (Global.equals((Object)mode, (Object)FecProtectionMode.NoOverlap)) {
            boolean num = numMediaPackets - numFecForImpPackets > 16;
            int resMaskBytes = num ? 6 : 2;
            byte[] subMask = maskTable.getTable()[numMediaPackets - numFecForImpPackets - 1][numFecRemaining - 1];
            this.shiftFitSubMask(numMaskBytes, resMaskBytes, numFecForImpPackets, numFecForImpPackets + numFecRemaining, subMask, packetMask);
        } else if (Global.equals((Object)mode, (Object)FecProtectionMode.Overlap) || Global.equals((Object)mode, (Object)FecProtectionMode.BiasFirstPacket)) {
            byte[] buffer2 = maskTable.getTable()[numMediaPackets - 1][numFecRemaining - 1];
            this.fitSubMask(numMaskBytes, numMaskBytes, numFecRemaining, buffer2, packetMask, numFecForImpPackets * numMaskBytes);
            if (Global.equals((Object)mode, (Object)FecProtectionMode.BiasFirstPacket)) {
                for (int i = 0; i < numFecRemaining; ++i) {
                    int offset = i * numMaskBytes;
                    packetMask.set((byte)(packetMask.read8(offset) | 0x80), offset, 1);
                }
            }
        } else {
            FecContext.verify(false);
        }
    }

    public void resetState(ArrayList<FecRecoveredPacket> recoveredPacketList) {
        this.setFecPacketReceived(false);
        while (ArrayListExtensions.getCount(recoveredPacketList) != 0) {
            ArrayListExtensions.removeAt(recoveredPacketList, 0);
        }
        FecContext.verify(ArrayListExtensions.getCount(recoveredPacketList) == 0);
        while (ArrayListExtensions.getCount(this._fecPacketList) != 0) {
            FecPacket packet = ArrayListExtensions.getItem(this._fecPacketList).get(0);
            packet.getProtectedPacketList().clear();
            FecContext.verify(ArrayListExtensions.getCount(packet.getProtectedPacketList()) == 0);
            ArrayListExtensions.removeAt(this._fecPacketList, 0);
        }
        FecContext.verify(ArrayListExtensions.getCount(this._fecPacketList) == 0);
    }

    private void setFecPacketReceived(boolean value) {
        this._fecPacketReceived = value;
    }

    private static ArrayList<FecRecoveredPacket> setIntersection(ArrayList<FecRecoveredPacket> array1, int first1, int last1, ArrayList<FecProtectedPacket> array2, int first2, int last2, ArrayList<FecRecoveredPacket> result, IFunction2<FecSortablePacket, FecSortablePacket, CompareResult> comp) {
        while (first1 != last1 && first2 != last2) {
            if (Global.equals((Object)comp.invoke(ArrayListExtensions.getItem(array1).get(first1), ArrayListExtensions.getItem(array2).get(first2)), (Object)CompareResult.Negative)) {
                ++first1;
                continue;
            }
            if (Global.equals((Object)comp.invoke(ArrayListExtensions.getItem(array2).get(first2), ArrayListExtensions.getItem(array1).get(first1)), (Object)CompareResult.Negative)) {
                ++first2;
                continue;
            }
            result.add(ArrayListExtensions.getItem(array1).get(first1));
            ++first1;
            ++first2;
        }
        return result;
    }

    private int setProtectionAllocation(int numMediaPackets, int numFecPackets, int numImpPackets) {
        int num3;
        double num = 0.5;
        int num2 = (int)(num * (double)numFecPackets);
        int n = num3 = numImpPackets < num2 ? numImpPackets : num2;
        if (numFecPackets == 1 && numMediaPackets > 2 * numImpPackets) {
            num3 = 0;
        }
        return num3;
    }

    private void shiftFitSubMask(int numMaskBytes, int resMaskBytes, int numColumnShift, int endRow, byte[] subMask, DataBuffer packetMask) {
        int count = numColumnShift % 8;
        int num2 = numColumnShift >> 3;
        for (int i = numColumnShift; i < endRow; ++i) {
            int offset = i * numMaskBytes + resMaskBytes - 1 + num2;
            int index = (i - numColumnShift) * resMaskBytes + resMaskBytes - 1;
            byte num6 = 0;
            byte num7 = 0;
            int num8 = 0;
            if (numMaskBytes > resMaskBytes) {
                num7 = BitAssistant.leftShift(subMask[index], 8 - count);
                packetMask.set(num7, offset + 1, 1);
            }
            for (int j = resMaskBytes - 1; j > 0; --j) {
                num6 = BitAssistant.rightShift(subMask[index], count);
                num7 = BitAssistant.leftShift(subMask[index - 1], 8 - count);
                num8 = num6 | num7;
                packetMask.set((byte)num8, offset, 1);
                --offset;
                --index;
            }
            num6 = BitAssistant.rightShift(subMask[index], count);
            packetMask.set(num6, offset, 1);
        }
    }

    private static CompareResult sortablePacketLessThan(FecSortablePacket first, FecSortablePacket second) {
        if (FecContext.isNewerSequenceNumber(second.getSequenceNumber(), first.getSequenceNumber())) {
            return CompareResult.Negative;
        }
        return CompareResult.Positive;
    }

    private void unequalProtectionMask(int numMediaPackets, int numFecPackets, int numImpPackets, int numMaskBytes, DataBuffer packetMask, FecPacketMaskTable maskTable) {
        FecProtectionMode overlap = FecProtectionMode.Overlap;
        int numFecForImpPackets = 0;
        if (!Global.equals((Object)overlap, (Object)FecProtectionMode.BiasFirstPacket)) {
            numFecForImpPackets = this.setProtectionAllocation(numMediaPackets, numFecPackets, numImpPackets);
        }
        int numFecRemaining = numFecPackets - numFecForImpPackets;
        if (numFecForImpPackets > 0) {
            this.importantPacketProtection(numFecForImpPackets, numImpPackets, numMaskBytes, packetMask, maskTable);
        }
        if (numFecRemaining > 0) {
            this.remainingPacketProtection(numMediaPackets, numFecRemaining, numFecForImpPackets, numMaskBytes, overlap, packetMask, maskTable);
        }
    }

    private void updateCoveringFECPackets(FecRecoveredPacket packet) {
        for (int i = 0; i != ArrayListExtensions.getCount(this._fecPacketList); ++i) {
            ArrayList<FecProtectedPacket> protectedPacketList = ArrayListExtensions.getItem(this._fecPacketList).get(i).getProtectedPacketList();
            int num2 = FecContext.lowerBound(protectedPacketList, 0, ArrayListExtensions.getCount(protectedPacketList), packet, (IFunction2<FecSortablePacket, FecSortablePacket, CompareResult>)new IFunctionDelegate2<FecSortablePacket, FecSortablePacket, CompareResult>(){

                @Override
                public String getId() {
                    return "fm.icelink.FecContext.sortablePacketLessThan";
                }

                @Override
                public CompareResult invoke(FecSortablePacket first, FecSortablePacket second) {
                    return FecContext.sortablePacketLessThan(first, second);
                }
            });
            if (num2 >= ArrayListExtensions.getCount(protectedPacketList) || ArrayListExtensions.getItem(protectedPacketList).get(num2).getSequenceNumber() != packet.getSequenceNumber()) continue;
            ArrayListExtensions.getItem(protectedPacketList).get(num2).setRaw(packet.getRaw());
        }
    }

    private static void verify(boolean condition) {
        if (!condition) {
            throw new RuntimeException(new Exception("Assertion failed."));
        }
    }

    private static void xorPackets(DataBuffer srcPacket, FecRecoveredPacket dstPacket) {
        int num;
        for (num = 0; num < 2; ++num) {
            dstPacket.getRaw().write8(dstPacket.getRaw().read8(num) ^ srcPacket.read8(num), num);
        }
        for (num = 4; num < 8; ++num) {
            dstPacket.getRaw().write8(dstPacket.getRaw().read8(num) ^ srcPacket.read8(num), num);
        }
        DataBuffer buffer = DataBuffer.allocate(2);
        buffer.write16(srcPacket.getLength() - 12, 0);
        dstPacket.getLengthRecovery().write8(dstPacket.getLengthRecovery().read8(0) ^ buffer.read8(0), 0);
        dstPacket.getLengthRecovery().write8(dstPacket.getLengthRecovery().read8(1) ^ buffer.read8(1), 1);
        for (num = 12; num < srcPacket.getLength(); ++num) {
            dstPacket.getRaw().write8(dstPacket.getRaw().read8(num) ^ srcPacket.read8(num), num);
        }
    }
}

