/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BitAssistant;
import fm.icelink.DataBuffer;
import fm.icelink.IAction1;
import fm.icelink.ManagedCondition;
import fm.icelink.MathAssistant;
import java.util.Vector;
import org.bouncycastle.crypto.tls.DatagramTransport;

class DtlsUdpTransport
implements DatagramTransport {
    private static int MIN_IP_OVERHEAD = 20;
    private static int MAX_IP_OVERHEAD = MIN_IP_OVERHEAD + 64;
    private static int UDP_OVERHEAD = 8;
    private Vector<DataBuffer> receivedPackets = new Vector();
    private Object receivedPacketsLock = new Object();
    private int receiveLimit;
    private int sendLimit;
    private IAction1<byte[]> sendCallback;
    private ManagedCondition receiveLock;

    public DtlsUdpTransport(IAction1<byte[]> sendCallback) {
        int mtu = 1500;
        this.receiveLimit = mtu - MIN_IP_OVERHEAD - UDP_OVERHEAD;
        this.sendLimit = mtu - MAX_IP_OVERHEAD - UDP_OVERHEAD;
        this.sendCallback = sendCallback;
        this.receiveLock = new ManagedCondition();
    }

    @Override
    public int getReceiveLimit() {
        return this.receiveLimit;
    }

    @Override
    public int getSendLimit() {
        return this.sendLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(DataBuffer packet) {
        Object object = this.receivedPacketsLock;
        synchronized (object) {
            this.receivedPackets.add(packet);
        }
        object = this.receiveLock;
        synchronized (object) {
            this.receiveLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pull(byte[] buf, int off, int len) {
        Object object = this.receivedPacketsLock;
        synchronized (object) {
            if (this.receivedPackets.size() > 0) {
                DataBuffer receiveBuffer = this.receivedPackets.get(0);
                int length = MathAssistant.min(len, receiveBuffer.getLength());
                BitAssistant.copy(receiveBuffer.getData(), receiveBuffer.getIndex(), buf, off, length);
                if (length == receiveBuffer.getLength()) {
                    this.receivedPackets.remove(0);
                } else {
                    this.receivedPackets.set(0, receiveBuffer.subset(length, receiveBuffer.getLength() - length));
                }
                return length;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int receive(byte[] buf, int off, int len, int waitMillis) {
        ManagedCondition managedCondition = this.receiveLock;
        synchronized (managedCondition) {
            int length = this.pull(buf, off, len);
            if (length != -1) {
                return length;
            }
            this.receiveLock.halt(waitMillis);
            length = this.pull(buf, off, len);
            if (length != -1) {
                return length;
            }
        }
        return -1;
    }

    @Override
    public void send(byte[] buf, int off, int len) {
        if (len > this.sendLimit) {
            // empty if block
        }
        if (this.sendCallback != null) {
            this.sendCallback.invoke(BitAssistant.subArray(buf, off, len));
        }
    }

    @Override
    public void close() {
    }
}

