/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BitAssistant;
import fm.icelink.Crypto;
import fm.icelink.DataBuffer;
import fm.icelink.DtlsCertificate;
import fm.icelink.IAction1;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.DefaultTlsSignerCredentials;
import org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.crypto.tls.TlsAuthentication;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsCredentials;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

class DtlsClientAuthentication
implements TlsAuthentication {
    private TlsContext context;
    public String remoteFingerprintAlgorithm;
    public String remoteFingerprint;
    private IAction1<DtlsCertificate> onRemoteCertificate;
    private DtlsCertificate certificate;

    public String getRemoteFingerprintAlgorithm() {
        return this.remoteFingerprintAlgorithm;
    }

    public String getRemoteFingerprint() {
        return this.remoteFingerprint;
    }

    public IAction1<DtlsCertificate> getOnRemoteCertificate() {
        return this.onRemoteCertificate;
    }

    public DtlsCertificate getCertificate() {
        return this.certificate;
    }

    public DtlsClientAuthentication(TlsContext context, DtlsCertificate certificate, String remoteFingerprintAlgorithm, String remoteFingerprint, IAction1<DtlsCertificate> onRemoteCertificate) {
        this.context = context;
        this.certificate = certificate;
        this.remoteFingerprintAlgorithm = remoteFingerprintAlgorithm;
        this.remoteFingerprint = remoteFingerprint;
        this.onRemoteCertificate = onRemoteCertificate;
    }

    @Override
    public void notifyServerCertificate(org.bouncycastle.crypto.tls.Certificate serverCertificate) throws IOException {
        if (serverCertificate == null) {
            throw new TlsFatalAlert(42);
        }
        Certificate[] certificates = serverCertificate.getCertificateList();
        if (certificates == null || certificates.length == 0) {
            throw new TlsFatalAlert(42);
        }
        Certificate cert = certificates[0];
        String fingerprint = null;
        if (this.remoteFingerprintAlgorithm.toLowerCase().equals("sha2") || this.remoteFingerprintAlgorithm.toLowerCase().equals("sha256") || this.remoteFingerprintAlgorithm.toLowerCase().equals("sha-256")) {
            fingerprint = BitAssistant.getHexString(Crypto.getSha256Hash(DataBuffer.wrap(cert.getEncoded())));
        } else if (this.remoteFingerprintAlgorithm.toLowerCase().equals("sha") || this.remoteFingerprintAlgorithm.toLowerCase().equals("sha1") || this.remoteFingerprintAlgorithm.toLowerCase().equals("sha-1")) {
            fingerprint = BitAssistant.getHexString(Crypto.getSha1Hash(DataBuffer.wrap(cert.getEncoded())));
        } else {
            throw new TlsFatalAlert(49);
        }
        if (!fingerprint.toLowerCase().equals(this.remoteFingerprint.replace(":", "").toLowerCase())) {
            throw new TlsFatalAlert(49);
        }
    }

    @Override
    public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
        short[] certificateTypes = certificateRequest.getCertificateTypes();
        if (certificateTypes == null || !Arrays.contains(certificateTypes, (short)1)) {
            return null;
        }
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        Vector supportedSignatureAlgorithms = certificateRequest.getSupportedSignatureAlgorithms();
        if (supportedSignatureAlgorithms != null) {
            for (SignatureAndHashAlgorithm alg : supportedSignatureAlgorithms) {
                if (alg.getSignature() != 1) continue;
                signatureAndHashAlgorithm = alg;
                break;
            }
            if (signatureAndHashAlgorithm == null) {
                return null;
            }
        }
        RSAPrivateCrtKeyParameters privateKey = new RSAPrivateCrtKeyParameters(new BigInteger(1, this.certificate.getKey().getModulus()), new BigInteger(1, this.certificate.getKey().getPublicExponent()), new BigInteger(1, this.certificate.getKey().getPrivateExponent()), new BigInteger(1, this.certificate.getKey().getPrime1()), new BigInteger(1, this.certificate.getKey().getPrime2()), new BigInteger(1, this.certificate.getKey().getExponent1()), new BigInteger(1, this.certificate.getKey().getExponent2()), new BigInteger(1, this.certificate.getKey().getCoefficient()));
        try {
            byte[] certificateBytes = this.certificate.getBytes();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int length = certificateBytes.length;
            TlsUtils.writeUint24(length + 3, bos);
            TlsUtils.writeUint24(length, bos);
            bos.write(certificateBytes, 0, certificateBytes.length);
            org.bouncycastle.crypto.tls.Certificate certificate = org.bouncycastle.crypto.tls.Certificate.parse(new ByteArrayInputStream(bos.toByteArray()));
            return new DefaultTlsSignerCredentials(this.context, certificate, privateKey, signatureAndHashAlgorithm);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

