/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DtlsCertificate;
import fm.icelink.DtlsCipherSuite;
import fm.icelink.DtlsProtocolVersion;
import fm.icelink.DtlsTransport;
import fm.icelink.Global;
import fm.icelink.IceGatherer;
import fm.icelink.IceGatheringState;
import fm.icelink.IceTransport;
import fm.icelink.Scheduler;
import fm.icelink.StringExtensions;

class CoreTransport {
    private Object __lock;
    private Scheduler __scheduler;
    private DtlsTransport _dtlsTransport;
    private IceGatherer _gatherer;
    private IceTransport _iceTransport;

    public CoreTransport(Object lockObject, Scheduler scheduler, IceGatherer gatherer, IceTransport iceTransport, DtlsTransport dtlsTransport) {
        this.__lock = lockObject;
        this.__scheduler = scheduler;
        this.setGatherer(gatherer);
        this.setIceTransport(iceTransport);
        this.setDtlsTransport(dtlsTransport);
    }

    public CoreTransport createComplementaryCoreTransport(DtlsCertificate[] certificates, DtlsCipherSuite[] cipherSuites, DtlsProtocolVersion serverMinVersion, DtlsProtocolVersion serverMaxVersion, DtlsProtocolVersion clientVersion) {
        CoreTransport transport2;
        try {
            CoreTransport transport = this.createComplementaryCoreTransport();
            transport.setDtlsTransport(new DtlsTransport(this.__lock, transport.getIceTransport(), certificates, cipherSuites, serverMinVersion, serverMaxVersion, clientVersion));
            transport2 = transport;
        }
        catch (Exception exception) {
            throw new RuntimeException(new Exception(StringExtensions.format("Could not create Complementary (RTCP) Core Transport: {0}", exception.getMessage())));
        }
        return transport2;
    }

    public CoreTransport createComplementaryCoreTransport() {
        CoreTransport transport2;
        if (!Global.equals((Object)this.getGatherer().getState(), (Object)IceGatheringState.New)) {
            throw new RuntimeException(new Exception("IceLink: complementary core transport for non-multiplexing cases can only be created when reference core transport is in the new state."));
        }
        try {
            IceGatherer gatherer = this.getGatherer().createRtcpGatherer();
            IceTransport iceTransport = this.getIceTransport().createRtcpTransport();
            transport2 = new CoreTransport(this.__lock, this.__scheduler, gatherer, iceTransport, null);
        }
        catch (Exception exception) {
            throw new RuntimeException(new Exception(StringExtensions.format("Could not create Complementary (RTCP) Core Transport: {0}", exception.getMessage())));
        }
        return transport2;
    }

    public DtlsTransport getDtlsTransport() {
        return this._dtlsTransport;
    }

    public IceGatherer getGatherer() {
        return this._gatherer;
    }

    public IceTransport getIceTransport() {
        return this._iceTransport;
    }

    public void removeDtlsTransport() {
        this.setDtlsTransport(null);
    }

    private void setDtlsTransport(DtlsTransport value) {
        this._dtlsTransport = value;
    }

    private void setGatherer(IceGatherer value) {
        this._gatherer = value;
    }

    private void setIceTransport(IceTransport value) {
        this._iceTransport = value;
    }
}

