/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Candidate;
import fm.icelink.ConnectionState;
import fm.icelink.Dynamic;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Future;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.IAction1;
import fm.icelink.IAction2;
import fm.icelink.IActionDelegate1;
import fm.icelink.IActionDelegate2;
import fm.icelink.IceGatherPolicy;
import fm.icelink.IceServer;
import fm.icelink.IceServerCollection;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.LongExtensions;
import fm.icelink.Promise;
import fm.icelink.RemoteCandidatePromise;
import fm.icelink.SessionDescription;
import fm.icelink.SignallingState;
import fm.icelink.Stream;
import fm.icelink.StreamBase;
import fm.icelink.StreamType;
import fm.icelink.StringExtensions;
import fm.icelink.TrickleIceSupportPolicy;
import fm.icelink.sdp.MediaDescription;
import fm.icelink.sdp.MediaType;
import fm.icelink.sdp.Message;
import java.util.ArrayList;
import java.util.List;

public abstract class ConnectionBase<TConnection>
extends Dynamic {
    private IceServerCollection __iceServers;
    private List<IAction2<TConnection, Candidate>> __onLocalCandidate = new ArrayList<IAction2<TConnection, Candidate>>();
    private List<IAction2<TConnection, SessionDescription>> __onLocalDescription = new ArrayList<IAction2<TConnection, SessionDescription>>();
    private List<IAction2<TConnection, Candidate>> __onRemoteCandidate = new ArrayList<IAction2<TConnection, Candidate>>();
    private List<IAction2<TConnection, SessionDescription>> __onRemoteDescription = new ArrayList<IAction2<TConnection, SessionDescription>>();
    private List<IAction1<ConnectionBase<TConnection>>> __onSignallingStateChange = new ArrayList<IAction1<ConnectionBase<TConnection>>>();
    private List<IAction1<TConnection>> __onStateChange = new ArrayList<IAction1<TConnection>>();
    private SignallingState __signallingState;
    private ConnectionState __state;
    Object _connectionLock;
    private int _deadStreamTimeout;
    private ArrayList<RemoteCandidatePromise> _earlyRemoteCandidatePromises;
    private Error _error;
    private IceGatherPolicy _iceGatherPolicy;
    private String _id;
    private String _internalId;
    private IAction2<TConnection, Candidate> _onLocalCandidate = new IAction2<TConnection, Candidate>(){

        @Override
        public void invoke(TConnection p0, Candidate p1) {
            for (IAction2 action : new ArrayList(ConnectionBase.this.__onLocalCandidate)) {
                action.invoke(p0, p1);
            }
        }
    };
    private IAction2<TConnection, SessionDescription> _onLocalDescription = new IAction2<TConnection, SessionDescription>(){

        @Override
        public void invoke(TConnection p0, SessionDescription p1) {
            for (IAction2 action : new ArrayList(ConnectionBase.this.__onLocalDescription)) {
                action.invoke(p0, p1);
            }
        }
    };
    private IAction2<TConnection, Candidate> _onRemoteCandidate = new IAction2<TConnection, Candidate>(){

        @Override
        public void invoke(TConnection p0, Candidate p1) {
            for (IAction2 action : new ArrayList(ConnectionBase.this.__onRemoteCandidate)) {
                action.invoke(p0, p1);
            }
        }
    };
    private IAction2<TConnection, SessionDescription> _onRemoteDescription = new IAction2<TConnection, SessionDescription>(){

        @Override
        public void invoke(TConnection p0, SessionDescription p1) {
            for (IAction2 action : new ArrayList(ConnectionBase.this.__onRemoteDescription)) {
                action.invoke(p0, p1);
            }
        }
    };
    private IAction1<ConnectionBase<TConnection>> _onSignallingStateChange = new IAction1<ConnectionBase<TConnection>>(){

        @Override
        public void invoke(ConnectionBase<TConnection> p0) {
            for (IAction1 action : new ArrayList(ConnectionBase.this.__onSignallingStateChange)) {
                action.invoke(p0);
            }
        }
    };
    private IAction1<TConnection> _onStateChange = new IAction1<TConnection>(){

        @Override
        public void invoke(TConnection p0) {
            for (IAction1 action : new ArrayList(ConnectionBase.this.__onStateChange)) {
                action.invoke(p0);
            }
        }
    };
    private String _tieBreaker;
    private int _timeout;
    private TrickleIceSupportPolicy _trickleIceSupport;

    public void addIceServer(IceServer iceServer) {
        this.__iceServers.add(iceServer);
    }

    public void addOnLocalCandidate(IAction2<TConnection, Candidate> value) {
        this.__onLocalCandidate.add(value);
    }

    public void addOnLocalDescription(IAction2<TConnection, SessionDescription> value) {
        this.__onLocalDescription.add(value);
    }

    public void addOnRemoteCandidate(IAction2<TConnection, Candidate> value) {
        this.__onRemoteCandidate.add(value);
    }

    public void addOnRemoteDescription(IAction2<TConnection, SessionDescription> value) {
        this.__onRemoteDescription.add(value);
    }

    public void addOnSignallingStateChange(IAction1<ConnectionBase<TConnection>> value) {
        this.__onSignallingStateChange.add(value);
    }

    public void addOnStateChange(IAction1<TConnection> value) {
        this.__onStateChange.add(value);
    }

    public Future<Candidate> addRemoteCandidate(Candidate remoteCandidate) {
        RemoteCandidatePromise item = new RemoteCandidatePromise(remoteCandidate);
        if (Global.equals((Object)this.getState(), (Object)ConnectionState.New) || Global.equals((Object)this.getState(), (Object)ConnectionState.Initializing)) {
            this._earlyRemoteCandidatePromises.add(item);
            if (!Global.equals((Object)this.getState(), (Object)ConnectionState.New) && !Global.equals((Object)this.getState(), (Object)ConnectionState.Initializing)) {
                this._earlyRemoteCandidatePromises.clear();
                this.addRemoteCandidatePromise(item);
            }
            return item;
        }
        if (!Global.equals((Object)this.getState(), (Object)ConnectionState.Failing) && !Global.equals((Object)this.getState(), (Object)ConnectionState.Failed)) {
            this.addRemoteCandidatePromise(item);
        }
        return item;
    }

    private void addRemoteCandidatePromise(RemoteCandidatePromise remoteCandidatePromise) {
        try {
            this.raiseRemoteCandidate(remoteCandidatePromise.getRemoteCandidate());
            this.doAddRemoteCandidate(remoteCandidatePromise, remoteCandidatePromise.getRemoteCandidate());
        }
        catch (Exception exception) {
            remoteCandidatePromise.reject(exception);
        }
    }

    public void addServers(IceServer[] iceServers) {
        this.__iceServers.addMany(iceServers);
    }

    public abstract TConnection addStream(Stream var1);

    public abstract TConnection addStreams(Stream[] var1);

    public abstract void close();

    public ConnectionBase() {
        this._connectionLock = new Object();
        this.__iceServers = new IceServerCollection();
        this._earlyRemoteCandidatePromises = new ArrayList();
        this.setId(Guid.newGuid().toString().replace("-", ""));
        this.setInternalId(Guid.newGuid().toString().replace("-", ""));
        this.setTieBreaker(Guid.newGuid().toString().replace("-", ""));
        this.setState(ConnectionState.New);
        this.setTimeout(30000);
        this.setDeadStreamTimeout(15000);
        this.setIceGatherPolicy(IceGatherPolicy.All);
        this.setTrickleIceSupport(TrickleIceSupportPolicy.FullTrickle);
    }

    public Future<SessionDescription> createAnswer() {
        Promise<SessionDescription> promise = new Promise<SessionDescription>();
        try {
            this.doCreateAnswer(promise);
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    public Future<SessionDescription> createOffer() {
        Promise<SessionDescription> promise = new Promise<SessionDescription>();
        try {
            this.doCreateOffer(promise);
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    protected abstract void doAddRemoteCandidate(Promise<Candidate> var1, Candidate var2);

    protected abstract void doCreateAnswer(Promise<SessionDescription> var1);

    protected abstract boolean doCreateOffer(Promise<SessionDescription> var1);

    protected abstract void doSendCachedLocalCandidates();

    protected abstract void doSetLocalDescription(Promise<SessionDescription> var1, SessionDescription var2);

    protected abstract void doSetRemoteDescription(Promise<SessionDescription> var1, SessionDescription var2);

    public int getDeadStreamTimeout() {
        return this._deadStreamTimeout;
    }

    public Error getError() {
        return this._error;
    }

    public IceGatherPolicy getIceGatherPolicy() {
        return this._iceGatherPolicy;
    }

    public IceServer getIceServer() {
        return (IceServer)this.__iceServers.getValue();
    }

    public IceServer[] getIceServers() {
        return (IceServer[])this.__iceServers.getValues();
    }

    public String getId() {
        return this._id;
    }

    protected abstract TConnection getInstance();

    String getInternalId() {
        return this._internalId;
    }

    public abstract SessionDescription getLocalDescription();

    public abstract SessionDescription getRemoteDescription();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignallingState getSignallingState() {
        Object object = this._connectionLock;
        synchronized (object) {
            return this.__signallingState;
        }
    }

    public ConnectionState getState() {
        return this.__state;
    }

    public abstract Stream[] getStreams();

    public String getTieBreaker() {
        return this._tieBreaker;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public TrickleIceSupportPolicy getTrickleIceSupport() {
        return this._trickleIceSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Error processDescription(SessionDescription description, boolean isLocalDescription) {
        Object object = this._connectionLock;
        synchronized (object) {
            int num2;
            Message sdpMessage = description.getSdpMessage();
            if (sdpMessage == null) {
                return new Error(ErrorCode.LocalDescriptionError, new Exception(StringExtensions.format("{0} session description is empty.", isLocalDescription ? "Local" : "Remote")));
            }
            Object[] streams = this.getStreams();
            if (streams == null || ArrayExtensions.getLength(streams) == 0) {
                return new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception("At least one local stream is required for the connection to conduct signalling exchange."));
            }
            Object[] mediaDescriptions = sdpMessage.getMediaDescriptions();
            if (mediaDescriptions == null || ArrayExtensions.getLength(mediaDescriptions) == 0) {
                return new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception("At least one media description is required for the connection to conduct signalling exchange."));
            }
            int length = ArrayExtensions.getLength(streams);
            if (length != (num2 = ArrayExtensions.getLength(mediaDescriptions))) {
                return new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception(StringExtensions.format("There is a mismatch between the number of local streams ({0}) and the number of media descriptions ({1}).", IntegerExtensions.toString(length), IntegerExtensions.toString(num2))));
            }
            for (int i = 0; i < ArrayExtensions.getLength(streams); ++i) {
                Object stream = streams[i];
                Object sdpMediaDescription = mediaDescriptions[i];
                StreamType type = MediaType.toStreamType(((MediaDescription)sdpMediaDescription).getMedia().getMediaType());
                if (!Global.equals((Object)((StreamBase)stream).getType(), (Object)type)) {
                    return new Error(ErrorCode.ConnectionInvalidArchitecture, new Exception(StringExtensions.format("There is a media type mismatch between the local stream at index {0} ({1}) and the media description at index {0} ({2}).", IntegerExtensions.toString(i), ((StreamBase)stream).getType().toString(), type.toString())));
                }
                this.processSdpMediaDescription((Stream)stream, (MediaDescription)sdpMediaDescription, i, isLocalDescription, description.getRenegotiation());
                Error error = ((Stream)stream).processSdpMediaDescription(sdpMessage, (MediaDescription)sdpMediaDescription, isLocalDescription, description.getIsOffer(), description.getRenegotiation());
                if (error == null) continue;
                return error;
            }
            return null;
        }
    }

    protected abstract Error processSdpMediaDescription(Stream var1, MediaDescription var2, int var3, boolean var4, boolean var5);

    void processStateChange() {
        if (Global.equals((Object)this.getState(), (Object)ConnectionState.Connecting)) {
            for (RemoteCandidatePromise promise : this._earlyRemoteCandidatePromises) {
                this.addRemoteCandidatePromise(promise);
            }
            this._earlyRemoteCandidatePromises.clear();
            this.doSendCachedLocalCandidates();
        }
    }

    protected void raiseLocalCandidate(Candidate localCandidate) {
        IAction2<TConnection, Candidate> onLocalCandidate = this._onLocalCandidate;
        if (onLocalCandidate != null && !localCandidate.getDispatched()) {
            onLocalCandidate.invoke(this.getInstance(), localCandidate);
        }
        Log.debug(StringExtensions.format("Local candidate for stream {0}:\r\n{1}", IntegerExtensions.toString(localCandidate.getSdpMediaIndex()), localCandidate.getSdpCandidateAttribute().toString()));
    }

    private void raiseLocalDescription(SessionDescription localDescription) {
        IAction2<TConnection, SessionDescription> onLocalDescription = this._onLocalDescription;
        if (onLocalDescription != null) {
            onLocalDescription.invoke(this.getInstance(), localDescription);
        }
    }

    private void raiseRemoteCandidate(Candidate remoteCandidate) {
        IAction2<TConnection, Candidate> onRemoteCandidate = this._onRemoteCandidate;
        if (onRemoteCandidate != null) {
            onRemoteCandidate.invoke(this.getInstance(), remoteCandidate);
        }
        Log.debug(StringExtensions.format("Remote candidate for stream {0}:\r\n{1}", IntegerExtensions.toString(remoteCandidate.getSdpMediaIndex()), remoteCandidate.getSdpCandidateAttribute().toString()));
    }

    private void raiseRemoteDescription(SessionDescription remoteDescription) {
        IAction2<TConnection, SessionDescription> onRemoteDescription = this._onRemoteDescription;
        if (onRemoteDescription != null) {
            onRemoteDescription.invoke(this.getInstance(), remoteDescription);
        }
    }

    private void raiseStateChange() {
        IAction1<TConnection> onStateChange = this._onStateChange;
        if (onStateChange != null) {
            onStateChange.invoke(this.getInstance());
        }
    }

    public void removeIceServer(IceServer iceServer) {
        this.__iceServers.remove(iceServer);
    }

    public void removeOnLocalCandidate(IAction2<TConnection, Candidate> value) {
        IAction2 match;
        if (value instanceof IActionDelegate2 && (match = Global.findIActionDelegate2WithId(this.__onLocalCandidate, ((IActionDelegate2)value).getId())) != null) {
            value = match;
        }
        this.__onLocalCandidate.remove(value);
    }

    public void removeOnLocalDescription(IAction2<TConnection, SessionDescription> value) {
        IAction2 match;
        if (value instanceof IActionDelegate2 && (match = Global.findIActionDelegate2WithId(this.__onLocalDescription, ((IActionDelegate2)value).getId())) != null) {
            value = match;
        }
        this.__onLocalDescription.remove(value);
    }

    public void removeOnRemoteCandidate(IAction2<TConnection, Candidate> value) {
        IAction2 match;
        if (value instanceof IActionDelegate2 && (match = Global.findIActionDelegate2WithId(this.__onRemoteCandidate, ((IActionDelegate2)value).getId())) != null) {
            value = match;
        }
        this.__onRemoteCandidate.remove(value);
    }

    public void removeOnRemoteDescription(IAction2<TConnection, SessionDescription> value) {
        IAction2 match;
        if (value instanceof IActionDelegate2 && (match = Global.findIActionDelegate2WithId(this.__onRemoteDescription, ((IActionDelegate2)value).getId())) != null) {
            value = match;
        }
        this.__onRemoteDescription.remove(value);
    }

    public void removeOnSignallingStateChange(IAction1<ConnectionBase<TConnection>> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onSignallingStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onSignallingStateChange.remove(value);
    }

    public void removeOnStateChange(IAction1<TConnection> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onStateChange.remove(value);
    }

    public void removeServers(IceServer[] iceServers) {
        this.__iceServers.removeMany(iceServers);
    }

    public abstract TConnection removeStream(Stream var1);

    public abstract TConnection removeStreams(Stream[] var1);

    public void setDeadStreamTimeout(int value) {
        this._deadStreamTimeout = value;
    }

    protected void setError(Error value) {
        this._error = value;
    }

    public void setIceGatherPolicy(IceGatherPolicy value) {
        this._iceGatherPolicy = value;
    }

    public void setIceServer(IceServer value) {
        this.__iceServers.setValue(value);
    }

    public void setIceServers(IceServer[] value) {
        this.__iceServers.replace(value);
    }

    public void setId(String value) {
        this._id = value;
    }

    private void setInternalId(String value) {
        this._internalId = value;
    }

    public Future<SessionDescription> setLocalDescription(SessionDescription localDescription) {
        Promise<SessionDescription> promise = new Promise<SessionDescription>();
        try {
            this.raiseLocalDescription(localDescription);
            this.doSetLocalDescription(promise, localDescription);
            Log.debug(StringExtensions.format("Local session description ({0}):\r\n{1}", StringExtensions.toLower(localDescription.getType().toString()), localDescription.getSdpMessage().toString()));
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    public Future<SessionDescription> setRemoteDescription(SessionDescription remoteDescription) {
        Promise<SessionDescription> promise = new Promise<SessionDescription>();
        try {
            this.raiseRemoteDescription(remoteDescription);
            if (this.verifySessionIdAndVersion(promise, remoteDescription)) {
                this.doSetRemoteDescription(promise, remoteDescription);
                Log.debug(StringExtensions.format("Remote session description ({0}):\r\n{1}", StringExtensions.toLower(remoteDescription.getType().toString()), remoteDescription.getSdpMessage().toString()));
            }
        }
        catch (Exception exception) {
            promise.reject(exception);
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSignallingState(SignallingState value) {
        Object object = this._connectionLock;
        synchronized (object) {
            if (!Global.equals((Object)this.__signallingState, (Object)value)) {
                this.__signallingState = value;
                IAction1<ConnectionBase<TConnection>> onSignallingStateChange = this._onSignallingStateChange;
                if (onSignallingStateChange != null) {
                    onSignallingStateChange.invoke(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(ConnectionState value) {
        Object object = this._connectionLock;
        synchronized (object) {
            if (!Global.equals((Object)this.__state, (Object)value)) {
                if (Global.equals((Object)value, (Object)ConnectionState.Closed)) {
                    if (!Global.equals((Object)this.__state, (Object)ConnectionState.Closing)) {
                        Log.debug("Connection is about to transition to the Closed state, but it is not in the Closing state. Raising Closing state first.");
                        this.__state = ConnectionState.Closing;
                        this.raiseStateChange();
                    }
                } else if (Global.equals((Object)value, (Object)ConnectionState.Failed) && !Global.equals((Object)this.__state, (Object)ConnectionState.Closing) && !Global.equals((Object)this.__state, (Object)ConnectionState.Failing)) {
                    Log.debug("Connection is about to transition to the Failed state, but it is not in the Failing or Closing state. Raising Failing state first.");
                    if (this.getError() == null) {
                        this.setError(new Error(ErrorCode.ConnectionInternalError));
                    }
                    this.__state = ConnectionState.Failing;
                    this.raiseStateChange();
                }
                Log.debug(StringExtensions.format("Setting Connection state to {1} for Connection {0}.", this.getId(), value.toString()));
                this.__state = value;
                this.raiseStateChange();
                this.processStateChange();
            }
        }
    }

    private void setTieBreaker(String value) {
        this._tieBreaker = value;
    }

    public void setTimeout(int value) {
        this._timeout = value;
    }

    public void setTrickleIceSupport(TrickleIceSupportPolicy value) {
        this._trickleIceSupport = value;
    }

    private boolean verifySessionIdAndVersion(Promise<SessionDescription> promise, SessionDescription remoteDescription) {
        if (this.getRemoteDescription() != null) {
            long sessionId = this.getRemoteDescription().getSessionId();
            long num2 = remoteDescription.getSessionId();
            long sessionVersion = this.getRemoteDescription().getSessionVersion();
            long num4 = remoteDescription.getSessionVersion();
            if (sessionId != num2) {
                promise.reject(new Exception(StringExtensions.format("Received new remote description with session id {0} and session version {1}, but current remote description has id {2} and version {3}. Cannot set remote description.", new Object[]{LongExtensions.toString(num2), LongExtensions.toString(num4), LongExtensions.toString(sessionId), LongExtensions.toString(sessionVersion)})));
                return false;
            }
            if (sessionVersion >= num4) {
                promise.reject(new Exception(StringExtensions.format("Received new remote description with session id {0} and session version {1}, but current remote description has id {2} and version {3}. Cannot set remote description.", new Object[]{LongExtensions.toString(num2), LongExtensions.toString(num4), LongExtensions.toString(sessionId), LongExtensions.toString(sessionVersion)})));
                return false;
            }
        }
        return true;
    }
}

