/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.IAction2;
import fm.icelink.IFunction1;
import fm.icelink.IFunction2;
import fm.icelink.IntegerExtensions;
import fm.icelink.StringExtensions;
import java.util.ArrayList;

public abstract class Collection<T, TCollection extends Collection<T, TCollection>> {
    private ArrayList<T> __values = new ArrayList();
    private Object __valuesLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T value) {
        if (value != null) {
            Object object = this.__valuesLock;
            synchronized (object) {
                if (!this.contains(value)) {
                    this.__values.add(value);
                    this.addSuccess(value);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMany(T[] values) {
        if (values != null) {
            Object object = this.__valuesLock;
            synchronized (object) {
                ArrayListExtensions.addRange(this.__values, values);
                for (T local : values) {
                    this.addSuccess(local);
                }
                return true;
            }
        }
        return false;
    }

    protected void addSuccess(T value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean any(IFunction1<T, Boolean> predicate) {
        Object object = this.__valuesLock;
        synchronized (object) {
            for (T local : this.__values) {
                if (predicate != null && !predicate.invoke(local).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean any() {
        return this.any(null);
    }

    protected abstract T[] arrayFromList(ArrayList<T> var1);

    protected Collection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(T value) {
        if (value != null) {
            Object object = this.__valuesLock;
            synchronized (object) {
                return this.__values.contains(value);
            }
        }
        return false;
    }

    protected abstract TCollection createCollection();

    public T first() {
        T local = this.first();
        if (local == null) {
            throw new RuntimeException(new Exception("The collection does not contain any values."));
        }
        return local;
    }

    public T first(IFunction1<T, Boolean> predicate) {
        T local = this.firstOrDefault(predicate);
        if (local == null) {
            throw new RuntimeException(new Exception("The collection does not contain any matching values."));
        }
        return local;
    }

    public T firstOrDefault() {
        return this.firstOrDefault(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T firstOrDefault(IFunction1<T, Boolean> predicate) {
        Object object = this.__valuesLock;
        synchronized (object) {
            for (int i = 0; i < ArrayListExtensions.getCount(this.__values); ++i) {
                T p = ArrayListExtensions.getItem(this.__values).get(i);
                if (predicate != null && !predicate.invoke(p).booleanValue()) continue;
                return p;
            }
        }
        return null;
    }

    public void forEach(IAction2<T, Integer> callback) {
        int num = 0;
        for (T local : this.getValues()) {
            callback.invoke(local, num++);
        }
    }

    public int getCount() {
        return ArrayListExtensions.getCount(this.__values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getValue() {
        Object object = this.__valuesLock;
        synchronized (object) {
            if (ArrayListExtensions.getCount(this.__values) > 0) {
                return ArrayListExtensions.getItem(this.__values).get(0);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T[] getValues() {
        Object object = this.__valuesLock;
        synchronized (object) {
            return this.arrayFromList(this.__values);
        }
    }

    public T last(IFunction1<T, Boolean> predicate) {
        T local = this.lastOrDefault(predicate);
        if (local == null) {
            throw new RuntimeException(new Exception("The collection does not contain any matching values."));
        }
        return local;
    }

    public T last() {
        T local = this.last();
        if (local == null) {
            throw new RuntimeException(new Exception("The collection does not contain any values."));
        }
        return local;
    }

    public T lastOrDefault() {
        return this.lastOrDefault(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T lastOrDefault(IFunction1<T, Boolean> predicate) {
        Object object = this.__valuesLock;
        synchronized (object) {
            for (int i = ArrayListExtensions.getCount(this.__values) - 1; i > -1; --i) {
                T p = ArrayListExtensions.getItem(this.__values).get(i);
                if (predicate != null && !predicate.invoke(p).booleanValue()) continue;
                return p;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T value) {
        if (value != null) {
            Object object = this.__valuesLock;
            synchronized (object) {
                if (this.__values.remove(value)) {
                    this.removeSuccess(value);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object object = this.__valuesLock;
        synchronized (object) {
            ArrayList<T> list = this.__values;
            this.__values = new ArrayList();
            for (T local : list) {
                this.removeSuccess(local);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMany(T[] values) {
        if (values != null && ArrayExtensions.getLength(values) > 0) {
            Object object = this.__valuesLock;
            synchronized (object) {
                boolean flag = false;
                for (T local : values) {
                    if (!this.__values.remove(local)) continue;
                    flag = true;
                    this.removeSuccess(local);
                }
                return flag;
            }
        }
        return false;
    }

    protected void removeSuccess(T value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(T[] values) {
        Object object = this.__valuesLock;
        synchronized (object) {
            this.__values.clear();
            ArrayListExtensions.addRange(this.__values, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(T value) {
        Object object = this.__valuesLock;
        synchronized (object) {
            this.__values = new ArrayList();
            if (value != null) {
                this.__values.add(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(T[] value) {
        Object object = this.__valuesLock;
        synchronized (object) {
            this.__values.clear();
            if (value != null) {
                ArrayListExtensions.addRange(this.__values, value);
            }
        }
    }

    public T single(IFunction1<T, Boolean> predicate) {
        T local = this.single(predicate);
        if (local == null) {
            throw new RuntimeException(new Exception("The collection does not contain a single matching value."));
        }
        return local;
    }

    public T single() {
        T local = this.single();
        if (local == null) {
            throw new RuntimeException(new Exception("The collection does not contain a single value."));
        }
        return local;
    }

    public T singleOrDefault() {
        return this.singleOrDefault(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T singleOrDefault(IFunction1<T, Boolean> predicate) {
        Object object = this.__valuesLock;
        synchronized (object) {
            if (ArrayListExtensions.getCount(this.__values) == 1) {
                T p = ArrayListExtensions.getItem(this.__values).get(0);
                if (predicate == null || predicate.invoke(p).booleanValue()) {
                    return p;
                }
            }
        }
        return null;
    }

    public T valueAt(int index) {
        T local = this.valueAtOrDefault(index);
        if (local == null) {
            throw new RuntimeException(new Exception(StringExtensions.format("Value does not exist at index {0}.", IntegerExtensions.toString(index))));
        }
        return local;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T valueAtOrDefault(int index) {
        Object object = this.__valuesLock;
        synchronized (object) {
            if (index < ArrayListExtensions.getCount(this.__values)) {
                for (int i = 0; i < ArrayListExtensions.getCount(this.__values); ++i) {
                    if (i != index) continue;
                    return ArrayListExtensions.getItem(this.__values).get(i);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCollection where(IFunction2<T, Integer, Boolean> predicate) {
        TCollection local = this.createCollection();
        Object object = this.__valuesLock;
        synchronized (object) {
            for (int i = 0; i < ArrayListExtensions.getCount(this.__values); ++i) {
                T local2 = ArrayListExtensions.getItem(this.__values).get(i);
                if (predicate != null && !predicate.invoke(local2, i).booleanValue()) continue;
                ((Collection)local).add(local2);
            }
        }
        return local;
    }
}

