/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.IAction2;
import fm.icelink.IAction3;
import fm.icelink.IFunction0;
import fm.icelink.JsonSerializer;
import fm.icelink.NullableInteger;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.Attribute;
import fm.icelink.sdp.ice.CandidateAttribute;
import java.util.HashMap;

public class Candidate {
    private boolean _dispatched;
    private CandidateAttribute _sdpCandidateAttribute;
    private int _sdpMediaIndex;

    public static Candidate fromJson(String candidateJson) {
        return JsonSerializer.deserializeObject(candidateJson, new IFunction0<Candidate>(){

            @Override
            public Candidate invoke() {
                return new Candidate();
            }
        }, new IAction3<Candidate, String, String>(){

            @Override
            public void invoke(Candidate candidate, String name, String valueJson) {
                String str2 = name;
                if (str2 != null) {
                    if (!Global.equals(str2, "sdpCandidateAttribute")) {
                        if (Global.equals(str2, "sdpMediaIndex")) {
                            candidate.setSdpMediaIndex(JsonSerializer.deserializeInteger(valueJson).getValue());
                        }
                    } else {
                        String s = JsonSerializer.deserializeString(valueJson);
                        if (s != null) {
                            if (!s.startsWith("a=")) {
                                s = StringExtensions.concat("a=", s);
                            }
                            candidate.setSdpCandidateAttribute(Global.tryCast(Attribute.parse(s), CandidateAttribute.class));
                        }
                    }
                }
            }
        });
    }

    public boolean getDispatched() {
        return this._dispatched;
    }

    public CandidateAttribute getSdpCandidateAttribute() {
        return this._sdpCandidateAttribute;
    }

    public int getSdpMediaIndex() {
        return this._sdpMediaIndex;
    }

    public void setDispatched(boolean value) {
        this._dispatched = value;
    }

    public void setSdpCandidateAttribute(CandidateAttribute value) {
        this._sdpCandidateAttribute = value;
    }

    public void setSdpMediaIndex(int value) {
        this._sdpMediaIndex = value;
    }

    public String toJson() {
        return Candidate.toJson(this);
    }

    public static String toJson(final Candidate candidate) {
        return JsonSerializer.serializeObject(candidate, new IAction2<Candidate, HashMap<String, String>>(){

            @Override
            public void invoke(Candidate c, HashMap<String, String> jsonObject) {
                CandidateAttribute sdpCandidateAttribute = candidate.getSdpCandidateAttribute();
                if (sdpCandidateAttribute != null) {
                    String str = sdpCandidateAttribute.toString();
                    if (!str.startsWith("a=")) {
                        str = StringExtensions.concat("a=", str);
                    }
                    HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "sdpCandidateAttribute", JsonSerializer.serializeString(str));
                }
                HashMapExtensions.set(HashMapExtensions.getItem(jsonObject), "sdpMediaIndex", JsonSerializer.serializeInteger(new NullableInteger(candidate.getSdpMediaIndex())));
            }
        });
    }
}

