/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.IVideoSource;
import fm.icelink.LongHolder;
import fm.icelink.RtpPacket;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoDepacketizer;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;

public class BasicVideoDepacketizer
extends VideoDepacketizer {
    public BasicVideoDepacketizer(IVideoSource source) {
        super(source);
    }

    public BasicVideoDepacketizer(VideoFormat format) {
        super(format);
    }

    @Override
    protected DataBuffer depacketize(VideoBuffer inputBuffer, LongHolder newSequenceNumber) {
        throw new RuntimeException(new Exception());
    }

    @Override
    protected void doDestroy() {
    }

    @Override
    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        Object[] dataBuffers = inputBuffer.getDataBuffers();
        DataBuffer[] bufferArray2 = new DataBuffer[ArrayExtensions.getLength(dataBuffers)];
        for (int i = 0; i < ArrayExtensions.getLength(dataBuffers); ++i) {
            RtpPacket packet = RtpPacket.wrap(inputBuffer.getDataBuffers()[i]);
            if (packet == null) {
                throw new RuntimeException(new Exception("Cannot depacketize video. Frame contains malformed RTP packets."));
            }
            bufferArray2[i] = packet.getPayload();
        }
        VideoBuffer buffer = inputBuffer.clone();
        buffer.setDataBuffers(bufferArray2);
        buffer.setFormat(super.getOutputFormat());
        frame.addBuffer(buffer);
        this.raiseFrame(frame);
    }

    @Override
    public String getLabel() {
        return "Basic Video Depacketizer";
    }

    @Override
    protected boolean isKeyFrame(DataBuffer inputBuffer) {
        return true;
    }
}

