/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioBufferCollection;
import fm.icelink.AudioConfig;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFormatCollection;
import fm.icelink.AudioFrame;
import fm.icelink.FecConfig;
import fm.icelink.IAudioElement;
import fm.icelink.IAudioPipe;
import fm.icelink.IAudioSink;
import fm.icelink.IAudioSinkCollection;
import fm.icelink.IAudioSource;
import fm.icelink.IAudioSourceCollection;
import fm.icelink.IElement;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaSink;
import fm.icelink.IMediaSource;
import fm.icelink.ISink;
import fm.icelink.ISource;
import fm.icelink.IntegerHolder;
import fm.icelink.JitterConfig;
import fm.icelink.MediaStream;
import fm.icelink.NackConfig;
import fm.icelink.ParseAssistant;
import fm.icelink.StreamType;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.rtp.MapAttribute;

public class AudioStream
extends MediaStream<IAudioSource, IAudioSourceCollection, IAudioSink, IAudioSinkCollection, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat, AudioFormatCollection>
implements IAudioPipe,
IAudioSource,
IMediaSource<IAudioSource, IAudioSink, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
ISource<IAudioSource, IAudioSink, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IAudioSink,
IMediaSink<IAudioSource, IAudioSink, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
ISink<IAudioSource, IAudioSink, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IAudioElement,
IMediaElement,
IElement {
    public AudioStream(IAudioSink sink) {
        IAudioSink[] iAudioSinkArray;
        if (sink == null) {
            iAudioSinkArray = null;
        } else {
            IAudioSink[] iAudioSinkArray2 = new IAudioSink[1];
            iAudioSinkArray = iAudioSinkArray2;
            iAudioSinkArray2[0] = sink;
        }
        this(iAudioSinkArray);
    }

    public AudioStream(IAudioSink[] sinks) {
        this(null, sinks);
    }

    public AudioStream(IAudioSource[] sources, IAudioSink[] sinks) {
        super(StreamType.Audio, new NackConfig(0, 0, true), new JitterConfig(), new FecConfig(true));
        super.addSources((IMediaSource[])sources);
        super.addSinks((IMediaSink[])sinks);
    }

    public AudioStream(IAudioSource[] sources) {
        this(sources, null);
    }

    public AudioStream(IAudioSource source, IAudioSink sink) {
        IAudioSink[] iAudioSinkArray;
        IAudioSource[] iAudioSourceArray;
        if (source == null) {
            iAudioSourceArray = null;
        } else {
            IAudioSource[] iAudioSourceArray2 = new IAudioSource[1];
            iAudioSourceArray = iAudioSourceArray2;
            iAudioSourceArray2[0] = source;
        }
        if (sink == null) {
            iAudioSinkArray = null;
        } else {
            IAudioSink[] iAudioSinkArray2 = new IAudioSink[1];
            iAudioSinkArray = iAudioSinkArray2;
            iAudioSinkArray2[0] = sink;
        }
        this(iAudioSourceArray, iAudioSinkArray);
    }

    public AudioStream() {
        this(new IAudioSource[0]);
    }

    public AudioStream(IAudioSource source) {
        IAudioSource[] iAudioSourceArray;
        if (source == null) {
            iAudioSourceArray = null;
        } else {
            IAudioSource[] iAudioSourceArray2 = new IAudioSource[1];
            iAudioSourceArray = iAudioSourceArray2;
            iAudioSourceArray2[0] = source;
        }
        this(iAudioSourceArray);
    }

    @Override
    protected AudioFormat createFormat(MapAttribute attribute) {
        return this.createFormat(attribute.getFormatName(), attribute.getClockRate(), attribute.getFormatParameters(), attribute.getPayloadType());
    }

    @Override
    protected AudioFormat createFormat(String name, int clockRate, String parameters, int payloadType) {
        int intResult = 1;
        IntegerHolder _var0 = new IntegerHolder(intResult);
        boolean _var1 = ParseAssistant.tryParseIntegerValue(parameters, _var0);
        intResult = _var0.getValue();
        if (!StringExtensions.isNullOrEmpty(parameters) && !_var1) {
            return null;
        }
        AudioFormat format = new AudioFormat(name, clockRate, intResult);
        format.setRegisteredPayloadType(payloadType);
        format.setIsPacketized(true);
        return format;
    }

    @Override
    protected AudioFormatCollection createMediaFormatCollection() {
        return new AudioFormatCollection();
    }

    @Override
    protected IAudioSinkCollection createSinkCollection(IAudioSource source) {
        return new IAudioSinkCollection(source);
    }

    @Override
    protected IAudioSourceCollection createSourceCollection(IAudioSink sink) {
        return new IAudioSourceCollection(sink);
    }

    @Override
    public AudioConfig getConfig() {
        AudioFormat outputFormat = (AudioFormat)super.getOutputFormat();
        if (outputFormat == null) {
            return null;
        }
        return outputFormat.getConfig();
    }
}

