/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.AudioBuffer;
import fm.icelink.AudioConfig;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.AudioPipe;
import fm.icelink.Binary;
import fm.icelink.CircularBuffer;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IAudioReframer;
import fm.icelink.IAudioSource;
import fm.icelink.IMediaSource;
import fm.icelink.LockedRandomizer;
import fm.icelink.ManagedStopwatch;
import fm.icelink.ManagedThread;
import fm.icelink.SoundTimestampContext;
import fm.icelink.pcm.Format;
import java.util.ArrayList;
import java.util.HashMap;

public class AudioMixer
extends AudioPipe
implements IAudioReframer {
    private HashMap<Long, CircularBuffer> __buffers = new HashMap();
    private Object __buffersLock = new Object();
    private ManagedThread __thread;
    private volatile boolean __threadActive = false;
    private SoundTimestampContext __timestampContext;
    private int _latency;
    private long _synchronizationSource;

    public AudioMixer(IAudioSource source, int latency) {
        this(source, latency, 0.0);
    }

    public AudioMixer(AudioConfig config) {
        this(config, 0);
    }

    public AudioMixer(AudioConfig config, int latency, double frameDuration) {
        this(new Format(config), latency, frameDuration);
    }

    public AudioMixer(IAudioSource[] sources, int latency) {
        this(sources, latency, 0.0);
    }

    public AudioMixer(IAudioSource[] sources) {
        this(sources, 0);
    }

    public AudioMixer(AudioConfig config, int latency) {
        this(config, latency, 0.0);
    }

    public AudioMixer(AudioFormat format, int latency) {
        this(format, latency, 0.0);
    }

    public AudioMixer(IAudioSource source) {
        this(source, 0);
    }

    public AudioMixer(AudioFormat format, int latency, double frameDuration) {
        super(format.clone(), format.clone());
        byte[] buffer = new byte[4];
        LockedRandomizer.nextBytes(buffer);
        this.setSynchronizationSource(Binary.fromBytes32(buffer, 0, false));
        if (!Global.equals(format.getName(), AudioFormat.getPcmName())) {
            throw new RuntimeException(new Exception("Cannot mix non-PCM audio."));
        }
        if (latency <= 0) {
            latency = 200;
        }
        if (frameDuration <= 0.0) {
            frameDuration = 20.0;
        }
        if (latency <= 0) {
            latency = 200;
        }
        this.setLatency(latency);
        this.__timestampContext = new SoundTimestampContext(frameDuration);
        this.__threadActive = true;
        this.__thread = new ManagedThread((IAction1<ManagedThread>)new IActionDelegate1<ManagedThread>(){

            @Override
            public String getId() {
                return "fm.icelink.AudioMixer.loop";
            }

            @Override
            public void invoke(ManagedThread thread) {
                AudioMixer.this.loop(thread);
            }
        });
        this.__thread.start();
    }

    public AudioMixer(IAudioSource[] sources, int latency, double frameDuration) {
        this((AudioFormat)sources[0].getOutputFormat(), latency, frameDuration);
        super.addSources((IMediaSource[])sources);
    }

    public AudioMixer(IAudioSource source, int latency, double frameDuration) {
        this((AudioFormat)source.getOutputFormat(), latency, frameDuration);
        super.addSource(source);
    }

    public AudioMixer(AudioFormat format) {
        this(format, 0);
    }

    @Override
    protected void doDestroy() {
        this.__threadActive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doProcessFrame(AudioFrame frame, AudioBuffer inputBuffer) {
        CircularBuffer buffer = null;
        Object object = this.__buffersLock;
        synchronized (object) {
            Holder<Object> _var0 = new Holder<Object>(buffer);
            boolean _var1 = HashMapExtensions.tryGetValue(this.__buffers, frame.getSynchronizationSource(), _var0);
            buffer = _var0.getValue();
            if (!_var1) {
                buffer = new CircularBuffer(this.getCircularBufferLength(), this.getLatency() * super.getConfig().getClockRate() * super.getConfig().getChannelCount() * 2 / 1000, ((AudioFormat)super.getOutputFormat()).getLittleEndian());
                HashMapExtensions.set(HashMapExtensions.getItem(this.__buffers), frame.getSynchronizationSource(), buffer);
            }
        }
        buffer.write(inputBuffer.getDataBuffer());
    }

    private int getCircularBufferLength() {
        return super.getConfig().getClockRate() * super.getConfig().getChannelCount() * 2 * (this.getLatency() * 2) / 1000;
    }

    @Override
    public boolean getDisableTimestampReset() {
        return this.__timestampContext.getDisableTimestampReset();
    }

    @Override
    public boolean getForceTimestampReset() {
        return this.__timestampContext.getForceTimestampReset();
    }

    @Override
    public double getFrameDuration() {
        return this.__timestampContext.getFrameDuration();
    }

    @Override
    public String getLabel() {
        return "Audio Mixer";
    }

    public int getLatency() {
        return this._latency;
    }

    public long getSynchronizationSource() {
        return this._synchronizationSource;
    }

    @Override
    public int getTimestampResetInterval() {
        return this.__timestampContext.getTimestampResetInterval();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void loop(ManagedThread thread) {
        int size = (int)((double)(super.getConfig().getClockRate() * super.getConfig().getChannelCount() * 2) * this.getFrameDuration() / 1000.0);
        ArrayList<CircularBuffer> list = new ArrayList<CircularBuffer>();
        ManagedStopwatch stopwatch = new ManagedStopwatch();
        stopwatch.start();
        double num2 = 0.0;
        double num3 = 1000.0 / (double)ManagedStopwatch.getFrequency();
        while (this.__threadActive) {
            thread.loopBegin();
            double num4 = (double)stopwatch.getElapsedTicks() * num3;
            while (num2 < num4) {
                list.clear();
                Object object = this.__buffersLock;
                synchronized (object) {
                    for (CircularBuffer circularBuffer : HashMapExtensions.getValues(this.__buffers)) {
                        list.add(circularBuffer);
                    }
                }
                DataBuffer dataBuffer = DataBufferPool.getInstance().takeBuffer(size, ((AudioFormat)super.getOutputFormat()).getLittleEndian());
                ArrayList<DataBuffer> list2 = new ArrayList<DataBuffer>();
                for (CircularBuffer buffer3 : list) {
                    DataBuffer item = buffer3.read(dataBuffer.getLength());
                    if (item == null) continue;
                    list2.add(item);
                }
                dataBuffer.set((byte)0);
                if (ArrayListExtensions.getCount(list2) > 0) {
                    void var13_16;
                    boolean bl = false;
                    while (var13_16 < size) {
                        int num6 = 0;
                        for (DataBuffer buffer4 : list2) {
                            num6 += buffer4.read16((int)var13_16);
                        }
                        dataBuffer.write16(num6, (int)var13_16);
                        var13_16 += 2;
                    }
                }
                AudioFrame audioFrame = new AudioFrame(this.getFrameDuration(), new AudioBuffer(dataBuffer, (AudioFormat)super.getOutputFormat()));
                audioFrame.setSynchronizationSource(this.getSynchronizationSource());
                this.raiseFrame(audioFrame);
                dataBuffer.free();
                num2 += this.getFrameDuration();
            }
            int num7 = (int)num4 % (int)this.getFrameDuration();
            ManagedThread.sleep(num7 == 0 ? (int)this.getFrameDuration() : num7);
            thread.loopEnd();
        }
        stopwatch.stop();
    }

    @Override
    public void setDisableTimestampReset(boolean value) {
        this.__timestampContext.setDisableTimestampReset(value);
    }

    @Override
    public void setForceTimestampReset(boolean value) {
        this.__timestampContext.setForceTimestampReset(value);
    }

    @Override
    public void setFrameDuration(double value) {
        this.__timestampContext.setFrameDuration(value);
    }

    private void setLatency(int value) {
        this._latency = value;
    }

    public void setSynchronizationSource(long value) {
        this._synchronizationSource = value;
    }

    @Override
    public void setTimestampResetInterval(int value) {
        this.__timestampContext.setTimestampResetInterval(value);
    }
}

