/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Asn1Any;
import fm.icelink.Binary;
import fm.icelink.BooleanHolder;
import fm.icelink.IntegerHolder;

class Asn1Integer
extends Asn1Any {
    private byte[] __value;
    private static byte[] _defaultValue = new byte[1];

    public Asn1Integer() {
    }

    public Asn1Integer(byte[] value) {
        this.setValue(value);
    }

    public Asn1Integer(long longValue) {
        this.setLongValue(longValue);
    }

    private static long bytesToLong(byte[] bytes) {
        int num = 0;
        if ((bytes[0] & 0x80) == 128) {
            num = 255;
        }
        return Binary.fromBytes64(Asn1Any.pad(bytes, 8, num), 0, false);
    }

    @Override
    public byte[] getContents() {
        return this.getValue();
    }

    public long getLongValue() {
        return Asn1Integer.bytesToLong(this.getValue());
    }

    @Override
    public void getProperties(IntegerHolder tag, IntegerHolder klass, BooleanHolder isConstructed, BooleanHolder isIndefinite) {
        tag.setValue(2);
        klass.setValue(0);
        isConstructed.setValue(false);
        isIndefinite.setValue(false);
    }

    public byte[] getValue() {
        return this.__value != null ? this.__value : _defaultValue;
    }

    private static byte[] longToBytes(long longValue) {
        int minLength = 0;
        minLength = longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE ? 8 : (longValue > 32767L || longValue < -32768L ? 4 : (longValue > 127L || longValue < -128L ? 2 : 1));
        return Asn1Any.trim(Binary.toBytes64(longValue, false), minLength, minLength);
    }

    public static Asn1Integer parseContents(byte[] contents) {
        return new Asn1Integer(contents);
    }

    public void setLongValue(long value) {
        this.setValue(Asn1Integer.longToBytes(value));
    }

    public void setValue(byte[] value) {
        this.__value = value != null ? value : _defaultValue;
    }
}

