/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AesCounterContext;
import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.DataBuffer;

class AesCounter {
    private AesCounterContext _context;
    private byte[] _counterData;
    private DataBuffer _key;
    private byte[] _offset;
    private DataBuffer _output;
    private byte[] _packetIndexBytes;
    private DataBuffer _salt;
    private byte[] _ssrcBytes;

    public AesCounter(DataBuffer key, DataBuffer salt) {
        int num;
        if (key.getLength() != 16) {
            throw new RuntimeException(new Exception("Invalid key length."));
        }
        if (salt.getLength() != 14) {
            throw new RuntimeException(new Exception("Invalid salt length."));
        }
        this._key = key;
        this._salt = salt;
        this._context = new AesCounterContext(key);
        this._offset = new byte[16];
        this._counterData = new byte[16];
        this._ssrcBytes = new byte[4];
        this._packetIndexBytes = new byte[6];
        this._output = DataBuffer.allocate(65536);
        for (num = 0; num < ArrayExtensions.getLength(this._offset); ++num) {
            this._offset[num] = 0;
        }
        for (num = 0; num < this._salt.getLength(); ++num) {
            this._offset[num] = (byte)this._salt.read8(num);
        }
    }

    public void clear() {
        if (this._context != null) {
            this._context.clear();
            this._context = null;
        }
    }

    public DataBuffer decrypt(DataBuffer buffer, long ssrc, long packetIndex) {
        return this.encrypt(buffer, ssrc, packetIndex);
    }

    public DataBuffer encrypt(DataBuffer buffer, long ssrc, long packetIndex) {
        int num;
        for (num = 0; num < ArrayExtensions.getLength(this._counterData); ++num) {
            this._counterData[num] = this._offset[num];
        }
        Binary.toBytes32(ssrc, false, this._ssrcBytes, 0);
        for (num = 0; num < ArrayExtensions.getLength(this._ssrcBytes); ++num) {
            this._counterData[num + 4] = (byte)(this._counterData[num + 4] ^ this._ssrcBytes[num]);
        }
        Binary.toBytes48(packetIndex, false, this._packetIndexBytes, 0);
        for (num = 0; num < ArrayExtensions.getLength(this._packetIndexBytes); ++num) {
            this._counterData[num + 8] = (byte)(this._counterData[num + 8] ^ this._packetIndexBytes[num]);
        }
        int length = buffer.getLength() / 16 * 16;
        if (length < buffer.getLength()) {
            length += 16;
        }
        if (this._context.generateKeystream(this._output, length, this._counterData)) {
            DataBuffer buffer2 = DataBuffer.wrap(this._output.getData(), this._output.getIndex(), buffer.getLength());
            for (num = 0; num < buffer2.getLength(); ++num) {
                buffer2.write8((byte)(buffer2.read8(num) ^ buffer.read8(num)), num);
            }
            return buffer2;
        }
        return DataBuffer.getEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBuffer generate(byte label, int length) {
        int num;
        byte[] buffer = new byte[16];
        for (num = 0; num < ArrayExtensions.getLength(buffer); ++num) {
            buffer[num] = 0;
        }
        buffer[7] = label;
        byte[] counter = new byte[16];
        for (num = 0; num < ArrayExtensions.getLength(counter); ++num) {
            counter[num] = (byte)(this._offset[num] ^ buffer[num]);
        }
        int count = length / 16 * 16;
        if (count < length) {
            count += 16;
        }
        DataBuffer output = DataBuffer.allocate(count);
        AesCounterContext context = null;
        try {
            context = new AesCounterContext(this._key);
        }
        catch (Exception exception1) {
            return DataBuffer.getEmpty();
        }
        try {
            if (!context.generateKeystream(output, count, counter)) {
                DataBuffer dataBuffer = DataBuffer.getEmpty();
                return dataBuffer;
            }
        }
        finally {
            if (context != null) {
                context.clear();
            }
        }
        return output.subset(0, length);
    }
}

