/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.opus;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioConfig;
import fm.icelink.AudioEncoder;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.Error;
import fm.icelink.Holder;
import fm.icelink.IAudioSource;
import fm.icelink.IMediaSource;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaControlFrame;
import fm.icelink.ParseAssistant;
import fm.icelink.RRControlFrame;
import fm.icelink.ReportBlock;
import fm.icelink.StringExtensions;
import fm.icelink.Utility;
import fm.icelink.opus.Format;
import fm.icelink.opus.Native;
import fm.icelink.sdp.FormatParametersAttribute;
import fm.icelink.sdp.MediaDescription;
import fm.icelink.sdp.rtp.MapAttribute;

public class Encoder
extends AudioEncoder {
    private int __currentChannelCount = -1;
    private int __currentClockRate = -1;
    private double __currentPacketTime = -1.0;
    private Native __encoder;
    private int __minimumReportsBeforeFEC = 1;
    private boolean __remoteSupportsFec = false;
    private long __reportsReceived = 0L;
    private int _bitrate = 32;
    private boolean _disableFec;
    private double _quality = 0.5;

    protected void doDestroy() {
        if (this.__encoder != null) {
            this.__encoder.destroy();
            this.__encoder = null;
        }
    }

    protected void doProcessControlFrames(MediaControlFrame[] controlFrames) {
        super.doProcessControlFrames(controlFrames);
        if (this.__encoder != null) {
            for (MediaControlFrame frame : controlFrames) {
                if (!(frame instanceof RRControlFrame)) continue;
                ++this.__reportsReceived;
                RRControlFrame frame2 = (RRControlFrame)frame;
                for (ReportBlock block : frame2.getReportBlocks()) {
                    Log.debug((String)StringExtensions.concat((Object[])new String[]{"Opus report: ", Utility.formatDoubleAsPercent((double)block.getPercentLost(), (int)2), " packet loss (", IntegerExtensions.toString((Integer)block.getCumulativeNumberOfPacketsLost()), " cumulative packets lost)"}));
                    if (this.getDisableFec() || this.getFecActive() || !this.__remoteSupportsFec || this.__reportsReceived <= (long)this.__minimumReportsBeforeFEC || !(block.getPercentLost() * 100.0 >= (double)this.getPercentLossToTriggerFEC())) continue;
                    Log.info((String)"Activating FEC for Opus audio stream.");
                    this.__encoder.setFecEnabled(true);
                    this.setFecActive(true);
                }
            }
        }
    }

    protected void doProcessFrame(AudioFrame frame, AudioBuffer inputBuffer) {
        AudioBuffer buffer = this.encode(inputBuffer, (AudioFormat)super.getOutputFormat(), frame.getDuration(), this.__remoteSupportsFec);
        if (buffer != null) {
            frame.addBuffer((MediaBuffer)buffer);
            this.raiseFrame(frame);
            buffer.releaseBuffers();
        }
    }

    protected Error doProcessSdpMediaDescription(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        MapAttribute rtpMapAttribute = mediaDescription.getRtpMapAttribute(super.getOutputFormat());
        if (rtpMapAttribute != null) {
            FormatParametersAttribute relatedFormatParametersAttribute = rtpMapAttribute.getRelatedFormatParametersAttribute();
            if (!isLocalDescription && relatedFormatParametersAttribute != null) {
                String str = null;
                Holder _var0 = new Holder(str);
                boolean _var1 = relatedFormatParametersAttribute.tryGetFormatSpecificParameter("useinbandfec", _var0);
                str = (String)_var0.getValue();
                if (_var1) {
                    int intResult = 0;
                    IntegerHolder _var2 = new IntegerHolder(intResult);
                    boolean _var3 = ParseAssistant.tryParseIntegerValue((String)str, (IntegerHolder)_var2);
                    intResult = _var2.getValue();
                    if (_var3) {
                        this.__remoteSupportsFec = intResult > 0;
                    }
                }
            }
        }
        return null;
    }

    private AudioBuffer encode(AudioBuffer buffer, AudioFormat outputFormat, double bufferDuration, boolean enableFec) {
        AudioBuffer buffer2;
        if (this.__encoder == null || bufferDuration != this.__currentPacketTime) {
            if (this.__encoder != null) {
                this.__encoder.destroy();
            }
            this.__currentClockRate = ((AudioFormat)buffer.getFormat()).getClockRate();
            this.__currentChannelCount = ((AudioFormat)buffer.getFormat()).getChannelCount();
            this.__currentPacketTime = bufferDuration;
            this.__encoder = new Native(true, this.__currentClockRate, this.__currentChannelCount, this.__currentPacketTime);
            this.__encoder.setQuality(this._quality);
            this.__encoder.setBitrate(this._bitrate);
            this.__encoder.setFecEnabled(enableFec);
        }
        if ((buffer2 = this.__encoder.encode(buffer, outputFormat)) != null) {
            buffer2.getDataBuffer().setLittleEndian(outputFormat.getLittleEndian());
            return buffer2;
        }
        return null;
    }

    public Encoder(AudioConfig config) {
        super((AudioFormat)new fm.icelink.pcm.Format(config), (AudioFormat)new Format());
    }

    public Encoder() {
        this(new Format().getConfig());
    }

    public Encoder(IAudioSource source) {
        this(source.getConfig());
        super.addSource((IMediaSource)source);
    }

    public int getBitrate() {
        return this._bitrate;
    }

    public boolean getDisableFec() {
        return this._disableFec;
    }

    boolean getFecActive() {
        return this.__encoder.getFecEnabled();
    }

    public String getLabel() {
        return "Opus Encoder";
    }

    public int getPercentLossToTriggerFEC() {
        return this.__encoder.getFecPacketLossPercentage();
    }

    public double getQuality() {
        return this._quality;
    }

    public void setBitrate(int value) {
        this._bitrate = value;
        if (this.__encoder != null) {
            this.__encoder.setBitrate(value);
        }
    }

    public void setDisableFec(boolean value) {
        this._disableFec = value;
    }

    void setFecActive(boolean value) {
        this.__encoder.setFecEnabled(value);
    }

    public void setPercentLossToTriggerFEC(int value) {
        this.__encoder.setFecPacketLossPercentage(value);
    }

    public void setQuality(double value) {
        this._quality = value;
        if (this.__encoder != null) {
            this.__encoder.setQuality(value);
        }
    }
}

