/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.openh264;

import fm.icelink.Architecture;
import fm.icelink.Global;
import fm.icelink.OperatingSystem;
import fm.icelink.Platform;

public class Utility {
    public static String getDownloadUrl() {
        OperatingSystem operatingSystem = Platform.getInstance().getOperatingSystem();
        Architecture architecture = Platform.getInstance().getArchitecture();
        OperatingSystem _var0 = operatingSystem;
        if (_var0 == OperatingSystem.Windows) {
            Architecture _var1 = architecture;
            if (_var1 == Architecture.X86) {
                return "http://ciscobinary.openh264.org/openh264-1.6.0-win32msvc.dll.bz2";
            }
            if (_var1 == Architecture.X64) {
                return "http://ciscobinary.openh264.org/openh264-1.6.0-win64msvc.dll.bz2";
            }
            throw new RuntimeException(new Exception("Cisco only distributes x86 and x64 OpenH264 binaries for Windows."));
        }
        if (_var0 == OperatingSystem.Android) {
            if (!Global.equals((Object)architecture, (Object)Architecture.Armv7) && !Global.equals((Object)architecture, (Object)Architecture.Armv8)) {
                throw new RuntimeException(new Exception("Cisco only distributes 32-bit ARM binaries for Android."));
            }
            return "http://ciscobinary.openh264.org/libopenh264-1.6.0-android19.so.bz2";
        }
        if (_var0 == OperatingSystem.MacOS) {
            return Global.equals((Object)architecture, (Object)Architecture.X86) ? "http://ciscobinary.openh264.org/libopenh264-1.6.0-osx32.3.dylib.bz2" : "http://ciscobinary.openh264.org/libopenh264-1.6.0-osx64.3.dylib.bz2";
        }
        throw new RuntimeException(new Exception("Unknown operating system."));
    }

    public static boolean isSupported() {
        try {
            Utility.getDownloadUrl();
            return true;
        }
        catch (Exception obj1) {
            return false;
        }
    }
}

