/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.openh264;

import fm.icelink.ArrayExtensions;
import fm.icelink.DataBuffer;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Holder;
import fm.icelink.IMediaSource;
import fm.icelink.IVideoSource;
import fm.icelink.Log;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaControlFrame;
import fm.icelink.MediaFrame;
import fm.icelink.PliControlFrame;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoEncoder;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.h264.Format;
import fm.icelink.h264.ProfileIdc;
import fm.icelink.h264.ProfileLevelId;
import fm.icelink.h264.Utility;
import fm.icelink.openh264.Native;
import fm.icelink.sdp.FormatParametersAttribute;
import fm.icelink.sdp.MediaDescription;

public class Encoder
extends VideoEncoder {
    private Native __encoder = new Native(true);
    private ProfileLevelId _profileLevelId;
    private int[] _supportedProfileIdcs;

    protected void doDestroy() {
        this.__encoder.destroy();
        this.__encoder = null;
    }

    protected void doProcessControlFrames(MediaControlFrame[] controlFrames) {
        for (MediaControlFrame frame : controlFrames) {
            if (!(frame instanceof PliControlFrame)) continue;
            this.setForceKeyFrame(true);
        }
    }

    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        VideoBuffer buffer = this.__encoder.encode(inputBuffer, (VideoFormat)super.getOutputFormat());
        if (buffer != null) {
            if (Utility.isKeyFrame((DataBuffer)buffer.getDataBuffer())) {
                Log.debug((String)"Encoder generated h.264 keyframe.");
            }
            frame.addBuffer((MediaBuffer)buffer);
            this.raiseFrame((MediaFrame)frame);
            buffer.releaseBuffers();
        }
    }

    protected Error doProcessSdpMediaDescription(MediaDescription mediaDescription, boolean isOffer, boolean isLocalDescription) {
        super.doProcessSdpMediaDescription(mediaDescription, isOffer, isLocalDescription);
        Object[] rtpMapAttributes = mediaDescription.getRtpMapAttributes(super.getOutputFormat());
        if (rtpMapAttributes != null) {
            for (int i = 0; i < ArrayExtensions.getLength((Object[])rtpMapAttributes); ++i) {
                Object attribute = rtpMapAttributes[i];
                FormatParametersAttribute relatedFormatParametersAttribute = attribute.getRelatedFormatParametersAttribute();
                if (relatedFormatParametersAttribute == null) {
                    relatedFormatParametersAttribute = new FormatParametersAttribute(attribute.getPayloadType());
                    attribute.setRelatedFormatParametersAttribute(relatedFormatParametersAttribute);
                }
                String str = null;
                Holder _var0 = new Holder(str);
                boolean _var1 = relatedFormatParametersAttribute.tryGetFormatSpecificParameter("profile-level-id", _var0);
                str = (String)_var0.getValue();
                if (str != null) {
                    Error error = this.updateProfileLevelId(new ProfileLevelId(str));
                    if (error == null) continue;
                    return error;
                }
                relatedFormatParametersAttribute.setFormatSpecificParameter("profile-level-id", this.getProfileLevelId().toString());
            }
        }
        return null;
    }

    public Encoder(IVideoSource source) {
        this();
        super.addSource((IMediaSource)source);
    }

    public Encoder() {
        super(VideoFormat.getI420(), (VideoFormat)new Format());
        this.__encoder.setMaxPayload(1100);
        this.setProfileLevelId(new ProfileLevelId(66, 224, 31));
        this.setSupportedProfileIdcs(new int[]{ProfileIdc.getBaseline()});
    }

    public int getBitrate() {
        return this.__encoder.getBitrate();
    }

    public boolean getForceKeyFrame() {
        return this.__encoder.getForceKeyFrame();
    }

    public String getLabel() {
        return "OpenH264 Encoder";
    }

    public ProfileLevelId getProfileLevelId() {
        return this._profileLevelId;
    }

    public double getQuality() {
        return this.__encoder.getQuality();
    }

    public int[] getSupportedProfileIdcs() {
        return this._supportedProfileIdcs;
    }

    public void setBitrate(int value) {
        this.__encoder.setBitrate(value);
    }

    public void setForceKeyFrame(boolean value) {
        this.__encoder.setForceKeyFrame(value);
    }

    private void setProfileLevelId(ProfileLevelId value) {
        this._profileLevelId = value;
    }

    public void setQuality(double value) {
        this.__encoder.setQuality(value);
    }

    private void setSupportedProfileIdcs(int[] value) {
        this._supportedProfileIdcs = value;
    }

    private Error updateProfileLevelId(ProfileLevelId profileLevelId) {
        for (int num : this.getSupportedProfileIdcs()) {
            if (num != profileLevelId.getProfileIdc()) continue;
            this.setProfileLevelId(profileLevelId);
            return null;
        }
        return new Error(ErrorCode.LocalDescriptionError);
    }
}

