/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.openh264;

import fm.icelink.DataBuffer;
import fm.icelink.IMediaSource;
import fm.icelink.IVideoSource;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaFrame;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoDecoder;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.h264.Format;
import fm.icelink.h264.Utility;
import fm.icelink.openh264.Native;

public class Decoder
extends VideoDecoder {
    private Native __decoder = new Native(false);

    public Decoder(IVideoSource source) {
        this();
        super.addSource((IMediaSource)source);
    }

    public Decoder() {
        super((VideoFormat)new Format(), VideoFormat.getI420());
    }

    protected void doDestroy() {
        this.__decoder.destroy();
        this.__decoder = null;
    }

    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        super.doProcessFrame(frame, inputBuffer);
        if (!super.getDelayDecode()) {
            VideoBuffer buffer = this.__decoder.decode(inputBuffer, (VideoFormat)super.getOutputFormat());
            if (buffer != null) {
                frame.addBuffer((MediaBuffer)buffer);
                this.raiseFrame((MediaFrame)frame);
                buffer.releaseBuffers();
            }
            if (this.getNeedsKeyFrame()) {
                super.sendPli("H.264 decoder needs a keyframe.");
            }
        }
    }

    public String getLabel() {
        return "OpenH264 Decoder";
    }

    public boolean getNeedsKeyFrame() {
        return this.__decoder.getNeedsKeyFrame();
    }

    protected boolean isKeyFrame(DataBuffer dataBuffer) {
        return Utility.isKeyFrame((DataBuffer)dataBuffer);
    }

    private void setNeedsKeyFrame(boolean value) {
        this.__decoder.setNeedsKeyFrame(value);
    }
}

