/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.yuv;

import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.Log;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;

class Native
extends fm.icelink.Native {
    long _state = Native.YuvFMCreate(0L, 0L, 0L, 0L);

    public void destroy() {
        Native.YuvFMDestroy(this._state);
        this._state = 0L;
    }

    public VideoBuffer convertToI420(final VideoBuffer fromBuffer) {
        int planeCount = fromBuffer.getDataBuffers().length;
        try {
            byte[][] planeDatas = new byte[planeCount][];
            int[] planeStrides = new int[planeCount];
            int[] planeIndexes = new int[planeCount];
            int[] planeLengths = new int[planeCount];
            for (int i = 0; i < fromBuffer.getDataBuffers().length; ++i) {
                DataBuffer plane = fromBuffer.getDataBuffers()[i];
                planeDatas[i] = plane.getData();
                planeStrides[i] = fromBuffer.getStrides()[i];
                planeIndexes[i] = plane.getIndex();
                planeLengths[i] = plane.getLength();
            }
            int[] lengthArray = new int[3];
            byte[] outputData = Native.YuvFMConvertToi420(this._state, fromBuffer.getWidth(), fromBuffer.getHeight(), fromBuffer.getOrientation(), planeDatas, planeStrides, planeIndexes, planeLengths, planeCount, lengthArray, ((VideoFormat)fromBuffer.getFormat()).getFourCC());
            if (outputData != null) {
                DataBuffer buffer = DataBuffer.wrap((byte[])outputData);
                DataBuffer[] planes = new DataBuffer[]{buffer.subset(0, lengthArray[0]), buffer.subset(lengthArray[0], lengthArray[1]), buffer.subset(lengthArray[0] + lengthArray[1], lengthArray[2])};
                VideoFormat format = ((VideoFormat)fromBuffer.getFormat()).clone();
                format.setName(VideoFormat.getI420Name());
                if (fromBuffer.getOrientation() == 90 || fromBuffer.getOrientation() == 270) {
                    return new VideoBuffer(fromBuffer.getHeight(), fromBuffer.getWidth(), planes, format){
                        {
                            super(x0, x1, x2, x3);
                            this.setStrides(new int[]{fromBuffer.getHeight(), fromBuffer.getHeight() / 2, fromBuffer.getHeight() / 2});
                        }
                    };
                }
                return new VideoBuffer(fromBuffer.getWidth(), fromBuffer.getHeight(), planes, format){
                    {
                        super(x0, x1, x2, x3);
                        this.setStrides(new int[]{fromBuffer.getWidth(), fromBuffer.getWidth() / 2, fromBuffer.getWidth() / 2});
                    }
                };
            }
        }
        catch (Exception e) {
            Log.error((String)("LibYuvFM: " + e.getMessage() + e.getStackTrace()));
        }
        return null;
    }

    public VideoBuffer convertFromI420(VideoBuffer fromBuffer, VideoFormat toFormat) {
        int planeCount = fromBuffer.getDataBuffers().length;
        try {
            byte[][] planeDatas = new byte[planeCount][];
            int[] planeStrides = new int[planeCount];
            int[] planeIndexes = new int[planeCount];
            int[] planeLengths = new int[planeCount];
            for (int i = 0; i < fromBuffer.getDataBuffers().length; ++i) {
                DataBuffer plane = fromBuffer.getDataBuffers()[i];
                planeDatas[i] = plane.getData();
                planeStrides[i] = fromBuffer.getStrides()[i];
                planeIndexes[i] = plane.getIndex();
                planeLengths[i] = plane.getLength();
            }
            int[] lengthArray = new int[3];
            byte[] outputData = Native.YuvFMConvertFromI420(this._state, fromBuffer.getWidth(), fromBuffer.getHeight(), planeDatas, planeStrides, planeIndexes, planeLengths, planeCount, lengthArray, toFormat.getFourCC());
            if (outputData != null) {
                DataBuffer buffer = DataBuffer.wrap((byte[])outputData);
                return new VideoBuffer(fromBuffer.getWidth(), fromBuffer.getHeight(), buffer, toFormat);
            }
        }
        catch (Exception e) {
            Log.error((String)("LibYuvFM: " + e.getMessage() + e.getStackTrace()));
        }
        return null;
    }

    public VideoBuffer scale(VideoBuffer fromBuffer, final int toWidth, int toHeight, int filterMode) {
        int planeCount = fromBuffer.getDataBuffers().length;
        try {
            byte[][] planeDatas = new byte[planeCount][];
            int[] planeStrides = new int[planeCount];
            int[] planeIndexes = new int[planeCount];
            int[] planeLengths = new int[planeCount];
            for (int i = 0; i < fromBuffer.getDataBuffers().length; ++i) {
                DataBuffer plane = fromBuffer.getDataBuffers()[i];
                planeDatas[i] = plane.getData();
                planeStrides[i] = fromBuffer.getStrides()[i];
                planeIndexes[i] = plane.getIndex();
                planeLengths[i] = plane.getLength();
            }
            int[] lengthArray = new int[3];
            byte[] outputData = Native.YuvFMScalei420(this._state, fromBuffer.getWidth(), fromBuffer.getHeight(), toWidth, toHeight, filterMode, planeDatas, planeStrides, planeIndexes, planeLengths, planeCount, lengthArray);
            if (outputData != null) {
                DataBuffer buffer = DataBuffer.wrap((byte[])outputData);
                DataBuffer[] planes = new DataBuffer[]{buffer.subset(0, lengthArray[0]), buffer.subset(lengthArray[0], lengthArray[1]), buffer.subset(lengthArray[0] + lengthArray[1], lengthArray[2])};
                VideoFormat format = ((VideoFormat)fromBuffer.getFormat()).clone();
                format.setName(VideoFormat.getI420Name());
                return new VideoBuffer(toWidth, toHeight, planes, format){
                    {
                        super(x0, x1, x2, x3);
                        this.setStrides(new int[]{toWidth, toWidth / 2, toWidth / 2});
                    }
                };
            }
        }
        catch (Exception e) {
            Log.error((String)("LibYuvFM: " + e.getMessage() + e.getStackTrace()));
        }
        return null;
    }

    public VideoBuffer rotate(final VideoBuffer inputBuffer) {
        int planeCount = inputBuffer.getDataBuffers().length;
        try {
            byte[][] planeDatas = new byte[planeCount][];
            int[] planeStrides = new int[planeCount];
            int[] planeIndexes = new int[planeCount];
            int[] planeLengths = new int[planeCount];
            for (int i = 0; i < inputBuffer.getDataBuffers().length; ++i) {
                DataBuffer plane = inputBuffer.getDataBuffers()[i];
                planeDatas[i] = plane.getData();
                planeStrides[i] = inputBuffer.getStrides()[i];
                planeIndexes[i] = plane.getIndex();
                planeLengths[i] = plane.getLength();
            }
            int[] lengthArray = new int[3];
            byte[] outputData = Native.YuvFMI420Rotate(this._state, inputBuffer.getWidth(), inputBuffer.getHeight(), inputBuffer.getOrientation(), planeDatas, planeStrides, planeIndexes, planeLengths, planeCount, lengthArray);
            if (outputData != null) {
                DataBuffer buffer = DataBuffer.wrap((byte[])outputData);
                DataBuffer[] planes = new DataBuffer[]{buffer.subset(0, lengthArray[0]), buffer.subset(lengthArray[0], lengthArray[1]), buffer.subset(lengthArray[0] + lengthArray[1], lengthArray[2])};
                VideoFormat format = ((VideoFormat)inputBuffer.getFormat()).clone();
                if (inputBuffer.getOrientation() == 90 || inputBuffer.getOrientation() == 270) {
                    return new VideoBuffer(inputBuffer.getHeight(), inputBuffer.getWidth(), planes, format){
                        {
                            super(x0, x1, x2, x3);
                            this.setStrides(new int[]{inputBuffer.getHeight(), inputBuffer.getHeight() / 2, inputBuffer.getHeight() / 2});
                        }
                    };
                }
                return new VideoBuffer(inputBuffer.getWidth(), inputBuffer.getHeight(), planes, format){
                    {
                        super(x0, x1, x2, x3);
                        this.setStrides(new int[]{inputBuffer.getWidth(), inputBuffer.getWidth() / 2, inputBuffer.getWidth() / 2});
                    }
                };
            }
        }
        catch (Exception e) {
            Log.error((String)("LibYuvFM: " + e.getMessage() + e.getStackTrace()));
        }
        return null;
    }

    private static void DebugCallback(String msg) {
        Log.info((String)("LibYuvFM: " + msg));
    }

    private static void ErrorCallback(String msg) {
        Log.error((String)("LibYuvFM: " + msg));
    }

    private static native long YuvFMCreate(long var0, long var2, long var4, long var6);

    private static native long YuvFMDestroy(long var0);

    private static native byte[] YuvFMConvertToi420(long var0, int var2, int var3, int var4, byte[][] var5, int[] var6, int[] var7, int[] var8, int var9, int[] var10, long var11);

    private static native byte[] YuvFMI420Rotate(long var0, int var2, int var3, int var4, byte[][] var5, int[] var6, int[] var7, int[] var8, int var9, int[] var10);

    private static native byte[] YuvFMConverti420ToRgb24(long var0, int var2, int var3, int var4, byte[][] var5, int[] var6, int[] var7, int[] var8, int var9, int[] var10, long var11);

    private static native byte[] YuvFMConvertFromI420(long var0, int var2, int var3, byte[][] var4, int[] var5, int[] var6, int[] var7, int var8, int[] var9, long var10);

    private static native byte[] YuvFMScalei420(long var0, int var2, int var3, int var4, int var5, int var6, byte[][] var7, int[] var8, int[] var9, int[] var10, int var11, int[] var12);

    static {
        Global.loadLibrary((String)"yuv");
        Global.loadLibrary((String)"yuvfmJNI");
    }
}

