/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.yuv;

import fm.icelink.ArrayExtensions;
import fm.icelink.Global;
import fm.icelink.IMediaSource;
import fm.icelink.IVideoSource;
import fm.icelink.MediaBuffer;
import fm.icelink.MediaFrame;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.VideoPipe;
import fm.icelink.yuv.Native;

public class ImageConverter
extends VideoPipe {
    private Native __yuvFM;

    protected void doDestroy() {
        if (this.__yuvFM != null) {
            this.__yuvFM.destroy();
            this.__yuvFM = null;
        }
    }

    protected void doProcessFrame(VideoFrame frame, VideoBuffer inputBuffer) {
        if (this.__yuvFM == null) {
            this.__yuvFM = new Native();
        }
        if (Global.equals((Object)((VideoFormat)inputBuffer.getFormat()).getName(), (Object)VideoFormat.getI420Name()) && Global.equals((Object)((VideoFormat)super.getOutputFormat()).getName(), (Object)VideoFormat.getI420Name()) && ArrayExtensions.getLength((Object[])inputBuffer.getDataBuffers()) == 3) {
            this.raiseFrame((MediaFrame)frame);
        } else if (((VideoFormat)inputBuffer.getFormat()).isEquivalent(super.getOutputFormat())) {
            this.raiseFrame((MediaFrame)frame);
        } else {
            VideoBuffer buffer = null;
            if (Global.equals((Object)((VideoFormat)super.getOutputFormat()).getName(), (Object)VideoFormat.getI420Name())) {
                buffer = this.__yuvFM.convertToI420(inputBuffer);
            } else if (Global.equals((Object)((VideoFormat)inputBuffer.getFormat()).getName(), (Object)VideoFormat.getI420Name())) {
                if (inputBuffer.getOrientation() > 0) {
                    inputBuffer = this.__yuvFM.rotate(inputBuffer);
                }
                buffer = this.__yuvFM.convertFromI420(inputBuffer, (VideoFormat)super.getOutputFormat());
            } else {
                VideoBuffer fromBuffer = this.__yuvFM.convertToI420(inputBuffer);
                buffer = this.__yuvFM.convertFromI420(fromBuffer, (VideoFormat)super.getOutputFormat());
            }
            if (buffer != null) {
                frame.addBuffer((MediaBuffer)buffer);
                this.raiseFrame((MediaFrame)frame);
                buffer.releaseBuffers();
            }
        }
    }

    public String getLabel() {
        return "Image Converter";
    }

    public ImageConverter(VideoFormat outputFormat) {
        super(outputFormat);
    }

    public ImageConverter(IVideoSource source, VideoFormat outputFormat) {
        this((VideoFormat)source.getOutputFormat(), outputFormat);
        super.addSource((IMediaSource)source);
    }

    public ImageConverter(VideoFormat inputFormat, VideoFormat outputFormat) {
        super(inputFormat, outputFormat);
    }

    public ImageConverter(IVideoSource[] sources, VideoFormat outputFormat) {
        this((VideoFormat)sources[0].getOutputFormat(), outputFormat);
        super.addSources((IMediaSource[])sources);
    }
}

