/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.HttpRequestArgs;
import fm.HttpResponseArgs;
import fm.Log;
import fm.SingleAction;
import fm.WebSocket;
import fm.WebSocketOpenArgs;
import fm.WebSocketOpenFailureArgs;
import fm.WebSocketOpenSuccessArgs;
import fm.WebSocketReceiveArgs;
import fm.WebSocketRequest;
import fm.WebSocketSendArgs;
import fm.WebSocketStreamFailureArgs;
import fm.WebSocketTransfer;
import java.util.HashMap;

public class WebSocketWebRequestTransfer
extends WebSocketTransfer {
    private WebSocketRequest _activeRequest;
    private WebSocket _webSocket;

    private void connectFailure(WebSocketOpenFailureArgs e) {
        if (super.getOnOpenFailure() != null) {
            super.getOnOpenFailure().invoke(e);
        }
    }

    private void connectSuccess(WebSocketOpenSuccessArgs e) {
        if (super.getOnOpenSuccess() != null) {
            super.getOnOpenSuccess().invoke(e);
        }
    }

    private WebSocket getWebSocket() {
        return this._webSocket;
    }

    @Override
    public void open(HashMap<String, String> headers) {
        this.setWebSocket(new WebSocket(super.getUrl()));
        try {
            WebSocketOpenArgs openArgs = new WebSocketOpenArgs();
            openArgs.setHandshakeTimeout(super.getHandshakeTimeout());
            openArgs.setHeaders(headers);
            final WebSocketWebRequestTransfer _var0 = this;
            openArgs.setOnSuccess(new SingleAction<WebSocketOpenSuccessArgs>(){

                @Override
                public void invoke(WebSocketOpenSuccessArgs e) {
                    try {
                        _var0.connectSuccess(e);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            final WebSocketWebRequestTransfer _var2 = this;
            openArgs.setOnFailure(new SingleAction<WebSocketOpenFailureArgs>(){

                @Override
                public void invoke(WebSocketOpenFailureArgs e) {
                    try {
                        _var2.connectFailure(e);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            final WebSocketWebRequestTransfer _var4 = this;
            openArgs.setOnStreamFailure(new SingleAction<WebSocketStreamFailureArgs>(){

                @Override
                public void invoke(WebSocketStreamFailureArgs e) {
                    try {
                        _var4.streamFailure(e);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            openArgs.setOnRequestCreated(super.getOnRequestCreated());
            openArgs.setOnResponseReceived(super.getOnResponseReceived());
            final WebSocketWebRequestTransfer _var6 = this;
            openArgs.setOnReceive(new SingleAction<WebSocketReceiveArgs>(){

                @Override
                public void invoke(WebSocketReceiveArgs e) {
                    try {
                        _var6.receive(e);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            openArgs.setSender(super.getSender());
            this.getWebSocket().open(openArgs);
        }
        catch (Exception exception) {
            Log.error("Could not open WebSocket.", exception);
        }
    }

    private void receive(WebSocketReceiveArgs e) {
        HttpResponseArgs p = new HttpResponseArgs(this._activeRequest.getArgs());
        p.setTextContent(e.getTextMessage());
        p.setBinaryContent(e.getBinaryMessage());
        this._activeRequest.getCallback().invoke(p);
    }

    @Override
    public HttpResponseArgs send(HttpRequestArgs requestArgs) throws Exception {
        throw new Exception("Synchronous WebSockets are not supported.");
    }

    @Override
    public void sendAsync(HttpRequestArgs requestArgs, SingleAction<HttpResponseArgs> callback) {
        try {
            WebSocketRequest request2 = new WebSocketRequest();
            request2.setArgs(requestArgs);
            request2.setCallback(callback);
            WebSocketRequest request = request2;
            WebSocketSendArgs args2 = new WebSocketSendArgs();
            args2.setTimeout(request.getArgs().getTimeout());
            WebSocketSendArgs sendArgs = args2;
            sendArgs.setTextMessage(request.getArgs().getTextContent());
            sendArgs.setBinaryMessage(request.getArgs().getBinaryContent());
            this._activeRequest = request;
            this.getWebSocket().send(sendArgs);
        }
        catch (Exception exception) {
            HttpResponseArgs p = new HttpResponseArgs(requestArgs);
            p.setException(exception);
            p.setStatusCode(0);
            callback.invoke(p);
        }
    }

    private void setWebSocket(WebSocket value) {
        this._webSocket = value;
    }

    @Override
    public void shutdown() {
        this.getWebSocket().close();
    }

    private void streamFailure(WebSocketStreamFailureArgs e) {
        if (super.getOnStreamFailure() != null) {
            super.getOnStreamFailure().invoke(e);
        }
    }

    public WebSocketWebRequestTransfer(String url) {
        super(url);
    }
}

