/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.BooleanHolder;
import fm.Holder;
import fm.Log;
import fm.UdpReceiveArgs;
import fm.UdpReceiveCompleteArgs;
import fm.UdpReceiveFailureArgs;
import fm.UdpReceiveSuccessArgs;
import fm.UdpSendArgs;
import fm.UdpSendCompleteArgs;
import fm.UdpSendFailureArgs;
import fm.UdpSendSuccessArgs;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class UdpSocket {
    private ExecutorService execIn = Executors.newFixedThreadPool(1);
    private ExecutorService execOut = Executors.newFixedThreadPool(1);
    private boolean isClosed;
    private Object isClosedLock = new Object();
    private DatagramSocket socket;
    private byte[] receiveBuffer;
    private int maxQueuedPackets;
    private boolean _ipv6;

    public UdpSocket(boolean ipv6) {
        this._ipv6 = ipv6;
        try {
            this.socket = new DatagramSocket(null);
            if (!(this.setReceiveBufferSize(65536) || this.setReceiveBufferSize(32768) || this.setReceiveBufferSize(16384) || this.setReceiveBufferSize(8192))) {
                Log.debug("Could not set socket receive buffer size.");
            }
            Log.debug(String.format(Locale.getDefault(), "Socket receive buffer size is %d.", this.socket.getReceiveBufferSize()));
            if (!(this.setSendBufferSize(65536) || this.setSendBufferSize(32768) || this.setSendBufferSize(16384) || this.setSendBufferSize(8192))) {
                Log.debug("Could not set socket send buffer size.");
            }
            Log.debug(String.format(Locale.getDefault(), "Socket send buffer size is %d.", this.socket.getSendBufferSize()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.receiveBuffer = new byte[65535];
    }

    private boolean setReceiveBufferSize(int size) {
        try {
            this.socket.setReceiveBufferSize(size);
            return true;
        }
        catch (Exception ex) {
            Log.debug(String.format(Locale.getDefault(), "Could not set socket receive buffer size to %d.", size));
            return false;
        }
    }

    private boolean setSendBufferSize(int size) {
        try {
            this.socket.setSendBufferSize(size);
            return true;
        }
        catch (Exception ex) {
            Log.debug(String.format(Locale.getDefault(), "Could not set socket send buffer size to %d.", size));
            return false;
        }
    }

    public boolean getIPv6() {
        return this._ipv6;
    }

    public boolean getIsClosed() {
        return this.isClosed;
    }

    public String getLocalIPAddress() {
        return this.socket.getLocalAddress().getHostAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public void setMaxQueuedPackets(int maxQueuedPackets) {
        this.maxQueuedPackets = maxQueuedPackets;
    }

    public int getMaxQueuedPackets() {
        return this.maxQueuedPackets;
    }

    public void bind(String ipAddress, int port, BooleanHolder addressInUse) throws Exception {
        addressInUse.setValue(false);
        try {
            InetAddress localAddress = this.getIPv6() ? Inet6Address.getByName(ipAddress) : Inet4Address.getByName(ipAddress);
            this.socket.bind(new InetSocketAddress(localAddress, port));
        }
        catch (BindException e) {
            if (e.getMessage().contains("in use")) {
                addressInUse.setValue(true);
            }
            throw e;
        }
    }

    public boolean receiveAsync(final UdpReceiveArgs receiveArgs, Holder<UdpReceiveSuccessArgs> receiveSuccessArgs, Holder<UdpReceiveFailureArgs> receiveFailureArgs, Holder<UdpReceiveCompleteArgs> receiveCompleteArgs) {
        try {
            this.execIn.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        DatagramPacket packet = new DatagramPacket(UdpSocket.this.receiveBuffer, UdpSocket.this.receiveBuffer.length);
                        UdpSocket.this.socket.receive(packet);
                        byte[] data = packet.getData();
                        int offset = packet.getOffset();
                        int length = packet.getLength();
                        byte[] buffer = new byte[length];
                        for (int i = 0; i < length; ++i) {
                            buffer[i] = data[offset + i];
                        }
                        UdpSocket.this.raiseReceiveSuccess(receiveArgs, buffer, packet.getAddress().getHostAddress(), packet.getPort());
                        UdpSocket.this.raiseReceiveComplete(receiveArgs);
                    }
                    catch (Exception e) {
                        UdpSocket.this.raiseReceiveFailure(receiveArgs, new Exception(String.format("Socket (%s:%d) receive failed.", UdpSocket.this.getLocalIPAddress(), UdpSocket.this.getLocalPort()), e));
                        UdpSocket.this.raiseReceiveComplete(receiveArgs);
                    }
                }
            });
        }
        catch (Exception e) {
            this.raiseReceiveFailure(receiveArgs, new Exception(String.format("Socket (%s:%d) receive failed.", this.getLocalIPAddress(), this.getLocalPort()), e));
            this.raiseReceiveComplete(receiveArgs);
        }
        return false;
    }

    public void sendAsync(final UdpSendArgs sendArgs) {
        try {
            this.execOut.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        UdpSocket.this.send(sendArgs.getBuffer(), sendArgs.getIPAddress(), sendArgs.getPort());
                        UdpSocket.this.raiseSendSuccess(sendArgs);
                        UdpSocket.this.raiseSendComplete(sendArgs);
                    }
                    catch (Exception e) {
                        UdpSocket.this.raiseSendFailure(sendArgs, new Exception(String.format("Socket (%s:%d) send failed.", UdpSocket.this.getLocalIPAddress(), UdpSocket.this.getLocalPort()), e));
                        UdpSocket.this.raiseSendComplete(sendArgs);
                    }
                }
            });
        }
        catch (Exception e) {
            this.raiseSendFailure(sendArgs, new Exception(String.format("Socket (%s:%d) send failed.", this.getLocalIPAddress(), this.getLocalPort()), e));
            this.raiseSendComplete(sendArgs);
        }
    }

    public int send(byte[] buffer, String ipAddress, int port) throws Exception {
        InetAddress remoteAddress = this.getIPv6() ? Inet6Address.getByName(ipAddress) : Inet4Address.getByName(ipAddress);
        this.socket.send(new DatagramPacket(buffer, buffer.length, new InetSocketAddress(remoteAddress, port)));
        return buffer.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.isClosedLock;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        this.execIn.shutdownNow();
        this.execOut.shutdownNow();
        this.socket.close();
    }

    private void raiseSendSuccess(final UdpSendArgs sendArgs) {
        final UdpSocket self = this;
        if (sendArgs.getOnSuccess() != null) {
            sendArgs.getOnSuccess().invoke(new UdpSendSuccessArgs(){
                {
                    this.setDynamicProperties(sendArgs.getDynamicProperties());
                    this.setSocket(self);
                    this.setState(sendArgs.getState());
                    this.setBuffer(sendArgs.getBuffer());
                    this.setIPAddress(sendArgs.getIPAddress());
                    this.setPort(sendArgs.getPort());
                }
            });
        }
    }

    private void raiseSendFailure(final UdpSendArgs sendArgs, final Exception exception) {
        final UdpSocket self = this;
        if (sendArgs.getOnFailure() != null) {
            sendArgs.getOnFailure().invoke(new UdpSendFailureArgs(){
                {
                    this.setDynamicProperties(sendArgs.getDynamicProperties());
                    this.setSocket(self);
                    this.setState(sendArgs.getState());
                    this.setBuffer(sendArgs.getBuffer());
                    this.setIPAddress(sendArgs.getIPAddress());
                    this.setPort(sendArgs.getPort());
                    this.setException(exception);
                }
            });
        }
    }

    private void raiseSendComplete(final UdpSendArgs sendArgs) {
        final UdpSocket self = this;
        if (sendArgs.getOnComplete() != null) {
            sendArgs.getOnComplete().invoke(new UdpSendCompleteArgs(){
                {
                    this.setDynamicProperties(sendArgs.getDynamicProperties());
                    this.setSocket(self);
                    this.setState(sendArgs.getState());
                    this.setBuffer(sendArgs.getBuffer());
                    this.setIPAddress(sendArgs.getIPAddress());
                    this.setPort(sendArgs.getPort());
                }
            });
        }
    }

    private void raiseReceiveSuccess(final UdpReceiveArgs receiveArgs, final byte[] buffer, final String remoteIPAddress, final int remotePort) {
        final UdpSocket self = this;
        if (receiveArgs.getOnSuccess() != null) {
            receiveArgs.getOnSuccess().invoke(new UdpReceiveSuccessArgs(){
                {
                    this.setDynamicProperties(receiveArgs.getDynamicProperties());
                    this.setSocket(self);
                    this.setState(receiveArgs.getState());
                    this.setBuffer(buffer);
                    this.setRemoteIPAddress(remoteIPAddress);
                    this.setRemotePort(remotePort);
                }
            });
        }
    }

    private void raiseReceiveFailure(final UdpReceiveArgs receiveArgs, final Exception exception) {
        final UdpSocket self = this;
        if (receiveArgs.getOnFailure() != null) {
            receiveArgs.getOnFailure().invoke(new UdpReceiveFailureArgs(){
                {
                    this.setDynamicProperties(receiveArgs.getDynamicProperties());
                    this.setSocket(self);
                    this.setState(receiveArgs.getState());
                    this.setException(exception);
                }
            });
        }
    }

    private void raiseReceiveComplete(final UdpReceiveArgs receiveArgs) {
        final UdpSocket self = this;
        if (receiveArgs.getOnComplete() != null) {
            receiveArgs.getOnComplete().invoke(new UdpReceiveCompleteArgs(){
                {
                    this.setDynamicProperties(receiveArgs.getDynamicProperties());
                    this.setSocket(self);
                    this.setState(receiveArgs.getState());
                }
            });
        }
    }
}

