/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.ArrayExtensions;
import fm.ArrayListExtensions;
import fm.BigDecimalExtensions;
import fm.BooleanHolder;
import fm.CharacterExtensions;
import fm.Convert;
import fm.DeserializeCallback;
import fm.DoubleExtensions;
import fm.DoubleHolder;
import fm.EmptyFunction;
import fm.FloatExtensions;
import fm.FloatHolder;
import fm.Global;
import fm.Guid;
import fm.HashMapExtensions;
import fm.Holder;
import fm.IntegerExtensions;
import fm.IntegerHolder;
import fm.JsonChecker;
import fm.LongExtensions;
import fm.LongHolder;
import fm.NullableBigDecimal;
import fm.NullableBoolean;
import fm.NullableDouble;
import fm.NullableFloat;
import fm.NullableGuid;
import fm.NullableInteger;
import fm.NullableLong;
import fm.ParseAssistant;
import fm.Serializable;
import fm.SerializeCallback;
import fm.StringBuilderExtensions;
import fm.StringExtensions;
import fm.StringType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;

public class Serializer {
    private static String charToUnicodeString(int value) {
        char ch = Serializer.intToHex(value >> 12 & 0xF);
        char ch2 = Serializer.intToHex(value >> 8 & 0xF);
        char ch3 = Serializer.intToHex(value >> 4 & 0xF);
        char ch4 = Serializer.intToHex(value & 0xF);
        return StringExtensions.concat(new String[]{"\\u", CharacterExtensions.toString(Character.valueOf(ch)), CharacterExtensions.toString(Character.valueOf(ch2)), CharacterExtensions.toString(Character.valueOf(ch3)), CharacterExtensions.toString(Character.valueOf(ch4))});
    }

    public static NullableBoolean deserializeBoolean(String valueJson) {
        if (!StringExtensions.isNullOrEmpty(valueJson)) {
            if (Global.equals(valueJson = valueJson.trim(), "null")) {
                return new NullableBoolean(null);
            }
            boolean boolResult = false;
            BooleanHolder _var0 = new BooleanHolder(boolResult);
            boolean _var1 = ParseAssistant.tryParseBooleanValue(valueJson, _var0);
            boolResult = _var0.getValue();
            if (_var1) {
                return new NullableBoolean(boolResult);
            }
        }
        return new NullableBoolean(null);
    }

    public static boolean[] deserializeBooleanArray(String arrayJson) {
        if (StringExtensions.isNullOrEmpty(arrayJson)) {
            return null;
        }
        if (Global.equals(arrayJson = arrayJson.trim(), "null")) {
            return null;
        }
        boolean[] flagArray = null;
        if (arrayJson.charAt(0) == '[') {
            if (StringExtensions.isNullOrEmpty(arrayJson = StringExtensions.substring(arrayJson, 1, StringExtensions.getLength(arrayJson) - 2))) {
                flagArray = new boolean[]{};
            } else {
                Object[] strArray = StringExtensions.split(arrayJson, new char[]{','});
                flagArray = new boolean[ArrayExtensions.getLength(strArray)];
                for (int i = 0; i < ArrayExtensions.getLength(strArray); ++i) {
                    flagArray[i] = Serializer.deserializeBoolean(((String)strArray[i]).trim()).getValue();
                }
            }
        }
        return flagArray;
    }

    public static NullableBigDecimal deserializeDecimal(String valueJson) {
        if (!StringExtensions.isNullOrEmpty(valueJson)) {
            if (Global.equals(valueJson = valueJson.trim(), "null")) {
                return new NullableBigDecimal(null);
            }
            BigDecimal decimalResult = new BigDecimal("0");
            Holder<BigDecimal> _var0 = new Holder<BigDecimal>(decimalResult);
            boolean _var1 = ParseAssistant.tryParseDecimalValue(valueJson, _var0);
            decimalResult = _var0.getValue();
            if (_var1) {
                return new NullableBigDecimal(decimalResult);
            }
        }
        return new NullableBigDecimal(null);
    }

    public static BigDecimal[] deserializeDecimalArray(String arrayJson) {
        if (StringExtensions.isNullOrEmpty(arrayJson)) {
            return null;
        }
        if (Global.equals(arrayJson = arrayJson.trim(), "null")) {
            return null;
        }
        BigDecimal[] numArray = null;
        if (arrayJson.charAt(0) == '[') {
            if (StringExtensions.isNullOrEmpty(arrayJson = StringExtensions.substring(arrayJson, 1, StringExtensions.getLength(arrayJson) - 2))) {
                numArray = new BigDecimal[]{};
            } else {
                Object[] strArray = StringExtensions.split(arrayJson, new char[]{','});
                numArray = new BigDecimal[ArrayExtensions.getLength(strArray)];
                for (int i = 0; i < ArrayExtensions.getLength(strArray); ++i) {
                    numArray[i] = Serializer.deserializeDecimal(((String)strArray[i]).trim()).getValue();
                }
            }
        }
        return numArray;
    }

    public static NullableDouble deserializeDouble(String valueJson) {
        if (!StringExtensions.isNullOrEmpty(valueJson)) {
            if (Global.equals(valueJson = valueJson.trim(), "null")) {
                return new NullableDouble(null);
            }
            double doubleResult = 0.0;
            DoubleHolder _var0 = new DoubleHolder(doubleResult);
            boolean _var1 = ParseAssistant.tryParseDoubleValue(valueJson, _var0);
            doubleResult = _var0.getValue();
            if (_var1) {
                return new NullableDouble(doubleResult);
            }
        }
        return new NullableDouble(null);
    }

    public static double[] deserializeDoubleArray(String arrayJson) {
        if (StringExtensions.isNullOrEmpty(arrayJson)) {
            return null;
        }
        if (Global.equals(arrayJson = arrayJson.trim(), "null")) {
            return null;
        }
        double[] numArray = null;
        if (arrayJson.charAt(0) == '[') {
            if (StringExtensions.isNullOrEmpty(arrayJson = StringExtensions.substring(arrayJson, 1, StringExtensions.getLength(arrayJson) - 2))) {
                numArray = new double[]{};
            } else {
                Object[] strArray = StringExtensions.split(arrayJson, new char[]{','});
                numArray = new double[ArrayExtensions.getLength(strArray)];
                for (int i = 0; i < ArrayExtensions.getLength(strArray); ++i) {
                    numArray[i] = Serializer.deserializeDouble(((String)strArray[i]).trim()).getValue();
                }
            }
        }
        return numArray;
    }

    public static NullableFloat deserializeFloat(String valueJson) {
        if (!StringExtensions.isNullOrEmpty(valueJson)) {
            if (Global.equals(valueJson = valueJson.trim(), "null")) {
                return new NullableFloat(null);
            }
            float floatResult = 0.0f;
            FloatHolder _var0 = new FloatHolder(floatResult);
            boolean _var1 = ParseAssistant.tryParseFloatValue(valueJson, _var0);
            floatResult = _var0.getValue();
            if (_var1) {
                return new NullableFloat(floatResult);
            }
        }
        return new NullableFloat(null);
    }

    public static float[] deserializeFloatArray(String arrayJson) {
        if (StringExtensions.isNullOrEmpty(arrayJson)) {
            return null;
        }
        if (Global.equals(arrayJson = arrayJson.trim(), "null")) {
            return null;
        }
        float[] numArray = null;
        if (arrayJson.charAt(0) == '[') {
            if (StringExtensions.isNullOrEmpty(arrayJson = StringExtensions.substring(arrayJson, 1, StringExtensions.getLength(arrayJson) - 2))) {
                numArray = new float[]{};
            } else {
                Object[] strArray = StringExtensions.split(arrayJson, new char[]{','});
                numArray = new float[ArrayExtensions.getLength(strArray)];
                for (int i = 0; i < ArrayExtensions.getLength(strArray); ++i) {
                    numArray[i] = Serializer.deserializeFloat(((String)strArray[i]).trim()).getValue();
                }
            }
        }
        return numArray;
    }

    public static NullableGuid deserializeGuid(String valueJson) throws Exception {
        if (!StringExtensions.isNullOrEmpty(valueJson)) {
            if (Global.equals(valueJson = valueJson.trim(), "null")) {
                return new NullableGuid(null);
            }
            Guid empty = Guid.empty;
            Holder<Guid> _var0 = new Holder<Guid>(empty);
            boolean _var1 = ParseAssistant.tryParseGuidValue(Serializer.deserializeString(valueJson), _var0);
            empty = _var0.getValue();
            if (_var1) {
                return new NullableGuid(empty);
            }
        }
        return new NullableGuid(null);
    }

    public static Guid[] deserializeGuidArray(String arrayJson) throws Exception {
        if (StringExtensions.isNullOrEmpty(arrayJson)) {
            return null;
        }
        if (Global.equals(arrayJson = arrayJson.trim(), "null")) {
            return null;
        }
        Guid[] guidArray = null;
        if (arrayJson.charAt(0) == '[') {
            if (StringExtensions.isNullOrEmpty(arrayJson = StringExtensions.substring(arrayJson, 1, StringExtensions.getLength(arrayJson) - 2))) {
                guidArray = new Guid[]{};
            } else {
                Object[] strArray = StringExtensions.split(arrayJson, new char[]{','});
                guidArray = new Guid[ArrayExtensions.getLength(strArray)];
                for (int i = 0; i < ArrayExtensions.getLength(strArray); ++i) {
                    guidArray[i] = Serializer.deserializeGuid(((String)strArray[i]).trim()).getValue();
                }
            }
        }
        return guidArray;
    }

    public static NullableInteger deserializeInteger(String valueJson) {
        if (!StringExtensions.isNullOrEmpty(valueJson)) {
            if (Global.equals(valueJson = valueJson.trim(), "null")) {
                return new NullableInteger(null);
            }
            int intResult = 0;
            IntegerHolder _var0 = new IntegerHolder(intResult);
            boolean _var1 = ParseAssistant.tryParseIntegerValue(valueJson, _var0);
            intResult = _var0.getValue();
            if (_var1) {
                return new NullableInteger(intResult);
            }
        }
        return new NullableInteger(null);
    }

    public static int[] deserializeIntegerArray(String arrayJson) {
        if (StringExtensions.isNullOrEmpty(arrayJson)) {
            return null;
        }
        if (Global.equals(arrayJson = arrayJson.trim(), "null")) {
            return null;
        }
        int[] numArray = null;
        if (arrayJson.charAt(0) == '[') {
            if (StringExtensions.isNullOrEmpty(arrayJson = StringExtensions.substring(arrayJson, 1, StringExtensions.getLength(arrayJson) - 2))) {
                numArray = new int[]{};
            } else {
                Object[] strArray = StringExtensions.split(arrayJson, new char[]{','});
                numArray = new int[ArrayExtensions.getLength(strArray)];
                for (int i = 0; i < ArrayExtensions.getLength(strArray); ++i) {
                    numArray[i] = Serializer.deserializeInteger(((String)strArray[i]).trim()).getValue();
                }
            }
        }
        return numArray;
    }

    public static NullableLong deserializeLong(String valueJson) {
        if (!StringExtensions.isNullOrEmpty(valueJson)) {
            if (Global.equals(valueJson = valueJson.trim(), "null")) {
                return new NullableLong(null);
            }
            long longResult = 0L;
            LongHolder _var0 = new LongHolder(longResult);
            boolean _var1 = ParseAssistant.tryParseLongValue(valueJson, _var0);
            longResult = _var0.getValue();
            if (_var1) {
                return new NullableLong(longResult);
            }
        }
        return new NullableLong(null);
    }

    public static long[] deserializeLongArray(String arrayJson) {
        if (StringExtensions.isNullOrEmpty(arrayJson)) {
            return null;
        }
        if (Global.equals(arrayJson = arrayJson.trim(), "null")) {
            return null;
        }
        long[] numArray = null;
        if (arrayJson.charAt(0) == '[') {
            if (StringExtensions.isNullOrEmpty(arrayJson = StringExtensions.substring(arrayJson, 1, StringExtensions.getLength(arrayJson) - 2))) {
                numArray = new long[]{};
            } else {
                Object[] strArray = StringExtensions.split(arrayJson, new char[]{','});
                numArray = new long[ArrayExtensions.getLength(strArray)];
                for (int i = 0; i < ArrayExtensions.getLength(strArray); ++i) {
                    numArray[i] = Serializer.deserializeLong(((String)strArray[i]).trim()).getValue();
                }
            }
        }
        return numArray;
    }

    public static <T> T deserializeObject(String json, EmptyFunction<T> creator, DeserializeCallback<T> callback) throws Exception {
        if (json == null) {
            return null;
        }
        if (Global.equals(json = json.trim(), "null") || StringExtensions.getLength(json) < 2) {
            return null;
        }
        T target = creator.invoke();
        if (json.charAt(0) == '{' && json.charAt(StringExtensions.getLength(json) - 1) == '}' && StringExtensions.getLength(json) > 2) {
            json = StringExtensions.concat(StringExtensions.substring(json, 1, StringExtensions.getLength(json) - 2), ",");
            int num = 0;
            int num2 = 0;
            boolean flag = false;
            int num3 = -2;
            StringType none = StringType.None;
            int startIndex = 0;
            int num5 = 0;
            String valueJson = StringExtensions.empty;
            String str2 = StringExtensions.empty;
            for (int i = 0; i < StringExtensions.getLength(json); ++i) {
                StringType type2;
                char ch = json.charAt(i);
                boolean flag2 = num3 == i - 1;
                boolean flag3 = false;
                if (!flag) {
                    char _var0 = ch;
                    if (_var0 == '[') {
                        ++num2;
                        flag3 = true;
                    } else if (_var0 == ']') {
                        --num2;
                        flag3 = true;
                    } else if (_var0 == '{') {
                        ++num;
                        flag3 = true;
                    } else if (_var0 == '}') {
                        --num;
                        flag3 = true;
                    }
                }
                if (flag3) continue;
                if (flag && ch == '\\' && !flag2) {
                    num3 = i;
                    flag3 = true;
                }
                if (flag3) continue;
                if (num == 0 && num2 == 0) {
                    char _var1 = ch;
                    if (_var1 == ',') {
                        if (!flag) {
                            str2 = StringExtensions.substring(json, num5, i - num5).trim();
                            callback.invoke(target, Serializer.deserializeString(valueJson), str2);
                            startIndex = i + 1;
                        }
                        flag3 = true;
                    } else if (_var1 == ':') {
                        if (!flag) {
                            valueJson = StringExtensions.substring(json, startIndex, i - startIndex).trim();
                            num5 = i + 1;
                        }
                        flag3 = true;
                    }
                }
                if (flag3 || ch != '\'' && ch != '\"' || flag2) continue;
                StringType stringType = type2 = ch == '\"' ? StringType.Double : StringType.Single;
                if (!flag) {
                    flag = true;
                    none = type2;
                } else if (Global.equals((Object)none, (Object)type2)) {
                    flag = false;
                    none = StringType.None;
                }
                flag3 = true;
            }
        }
        return target;
    }

    public static <T> ArrayList<T> deserializeObjectArray(String json, EmptyFunction<T> creator, DeserializeCallback<T> callback) throws Exception {
        ArrayList<String> list = Serializer.deserializeRawArray(json);
        if (list == null) {
            return null;
        }
        ArrayList<T> list2 = new ArrayList<T>(ArrayListExtensions.getCount(list));
        for (String str : list) {
            T item = Serializer.deserializeObject(str, creator, callback);
            list2.add(item);
        }
        return list2;
    }

    public static <T extends Serializable> ArrayList<T> deserializeObjectArrayFast(String json, EmptyFunction<T> creator, DeserializeCallback<T> callback) throws Exception {
        ArrayList<String> list = Serializer.deserializeRawArray(json);
        if (list == null) {
            return null;
        }
        ArrayList<Serializable> list2 = new ArrayList<Serializable>(ArrayListExtensions.getCount(list));
        for (String str : list) {
            Serializable item = (Serializable)Serializer.deserializeObject(str, creator, callback);
            item.setSerialized(str);
            list2.add(item);
        }
        return list2;
    }

    public static <T extends Serializable> T deserializeObjectFast(String json, EmptyFunction<T> creator, DeserializeCallback<T> callback) throws Exception {
        Serializable local = (Serializable)Serializer.deserializeObject(json, creator, callback);
        if (local != null) {
            local.setSerialized(json);
        }
        return (T)local;
    }

    public static String deserializeRaw(String dataJson) {
        if (StringExtensions.isNullOrEmpty(dataJson)) {
            return null;
        }
        return dataJson.trim();
    }

    public static ArrayList<String> deserializeRawArray(String json) {
        if (json == null) {
            return null;
        }
        if (Global.equals(json = json.trim(), "null") || StringExtensions.getLength(json) < 2) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (json.charAt(0) == '[' && json.charAt(StringExtensions.getLength(json) - 1) == ']' && StringExtensions.getLength(json) > 2) {
            int num = 0;
            int startIndex = 0;
            boolean flag = false;
            int num3 = -2;
            StringType none = StringType.None;
            for (int i = 1; i < StringExtensions.getLength(json) - 1; ++i) {
                StringType type2;
                boolean flag2;
                char ch = json.charAt(i);
                boolean bl = flag2 = num3 == i - 1;
                if (!flag) {
                    char _var0 = ch;
                    if (_var0 == '{') {
                        if (num == 0) {
                            startIndex = i;
                        }
                        ++num;
                    } else if (_var0 == '}' && --num == 0) {
                        list.add(StringExtensions.substring(json, startIndex, i - startIndex + 1));
                    }
                }
                if (flag && ch == '\\' && !flag2) {
                    num3 = i;
                    continue;
                }
                if (ch != '\'' && ch != '\"' || flag2) continue;
                StringType stringType = type2 = ch == '\"' ? StringType.Double : StringType.Single;
                if (!flag) {
                    flag = true;
                    none = type2;
                    continue;
                }
                if (!Global.equals((Object)none, (Object)type2)) continue;
                flag = false;
                none = StringType.None;
            }
        }
        return list;
    }

    public static String deserializeString(String valueJson) throws Exception {
        boolean flag2;
        if (StringExtensions.isNullOrEmpty(valueJson)) {
            return null;
        }
        if (Global.equals(valueJson = valueJson.trim(), "null")) {
            return null;
        }
        boolean flag = valueJson.startsWith("\"") || valueJson.startsWith("'");
        boolean bl = flag2 = valueJson.endsWith("\"") || valueJson.endsWith("'");
        if (!flag || !flag2) {
            return null;
        }
        return Serializer.unescapeString(Serializer.trimQuotes(valueJson));
    }

    public static String[] deserializeStringArray(String arrayJson) throws Exception {
        if (StringExtensions.isNullOrEmpty(arrayJson)) {
            return null;
        }
        if (Global.equals(arrayJson = arrayJson.trim(), "null")) {
            return null;
        }
        if (arrayJson.charAt(0) == '[') {
            Object[] strArray;
            if (StringExtensions.isNullOrEmpty(arrayJson = StringExtensions.substring(arrayJson, 1, StringExtensions.getLength(arrayJson) - 2))) {
                strArray = new String[]{};
            } else {
                strArray = StringExtensions.split(arrayJson, new char[]{','});
                for (int i = 0; i < ArrayExtensions.getLength(strArray); ++i) {
                    strArray[i] = Serializer.unescapeString(Serializer.trimQuotes(((String)strArray[i]).trim()));
                }
            }
            return strArray;
        }
        return new String[]{arrayJson};
    }

    public static String escapeString(String text) {
        StringBuilder builder = new StringBuilder();
        int startIndex = -1;
        for (int i = 0; i < StringExtensions.getLength(text); ++i) {
            char ch = text.charAt(i);
            if (ch > '~') {
                if (startIndex != -1) {
                    StringBuilderExtensions.append(builder, text, startIndex, i - startIndex);
                    startIndex = -1;
                }
                StringBuilderExtensions.append(builder, Serializer.charToUnicodeString(ch));
                continue;
            }
            char _var0 = ch;
            if (_var0 == '\b') {
                if (startIndex != -1) {
                    StringBuilderExtensions.append(builder, text, startIndex, i - startIndex);
                    startIndex = -1;
                }
                StringBuilderExtensions.append(builder, "\\b");
                continue;
            }
            if (_var0 == '\f') {
                if (startIndex != -1) {
                    StringBuilderExtensions.append(builder, text, startIndex, i - startIndex);
                    startIndex = -1;
                }
                StringBuilderExtensions.append(builder, "\\f");
                continue;
            }
            if (_var0 == '\n') {
                if (startIndex != -1) {
                    StringBuilderExtensions.append(builder, text, startIndex, i - startIndex);
                    startIndex = -1;
                }
                StringBuilderExtensions.append(builder, "\\n");
                continue;
            }
            if (_var0 == '\r') {
                if (startIndex != -1) {
                    StringBuilderExtensions.append(builder, text, startIndex, i - startIndex);
                    startIndex = -1;
                }
                StringBuilderExtensions.append(builder, "\\r");
                continue;
            }
            if (_var0 == '\t') {
                if (startIndex != -1) {
                    StringBuilderExtensions.append(builder, text, startIndex, i - startIndex);
                    startIndex = -1;
                }
                StringBuilderExtensions.append(builder, "\\t");
                continue;
            }
            if (_var0 == '\"') {
                if (startIndex != -1) {
                    StringBuilderExtensions.append(builder, text, startIndex, i - startIndex);
                    startIndex = -1;
                }
                StringBuilderExtensions.append(builder, "\\\"");
                continue;
            }
            if (_var0 == '/') {
                if (startIndex != -1) {
                    StringBuilderExtensions.append(builder, text, startIndex, i - startIndex);
                    startIndex = -1;
                }
                StringBuilderExtensions.append(builder, "\\/");
                continue;
            }
            if (_var0 == '\\') {
                if (startIndex != -1) {
                    StringBuilderExtensions.append(builder, text, startIndex, i - startIndex);
                    startIndex = -1;
                }
                StringBuilderExtensions.append(builder, "\\\\");
                continue;
            }
            if (startIndex != -1) continue;
            startIndex = i;
        }
        if (startIndex != -1) {
            StringBuilderExtensions.append(builder, text, startIndex, StringExtensions.getLength(text) - startIndex);
        }
        return builder.toString();
    }

    private static char intToHex(int value) {
        if (value <= 9) {
            return (char)(value + 48);
        }
        return (char)(value - 10 + 97);
    }

    public static boolean isValidJson(String json) throws Exception {
        return new JsonChecker().checkString(json);
    }

    public static String serializeBoolean(NullableBoolean value) {
        if (!value.getHasValue()) {
            return "null";
        }
        if (value.getValue()) {
            return "true";
        }
        return "false";
    }

    public static String serializeBooleanArray(boolean[] array) {
        if (array == null) {
            return "null";
        }
        String[] strArray = new String[ArrayExtensions.getLength(array)];
        for (int i = 0; i < ArrayExtensions.getLength(array); ++i) {
            strArray[i] = Serializer.serializeBoolean(new NullableBoolean(array[i]));
        }
        return StringExtensions.concat("[", StringExtensions.join(",", strArray), "]");
    }

    public static String serializeDecimal(NullableBigDecimal value) {
        if (!value.getHasValue()) {
            return "null";
        }
        return BigDecimalExtensions.toString(value.getValue());
    }

    public static String serializeDecimalArray(BigDecimal[] array) {
        if (array == null) {
            return "null";
        }
        String[] strArray = new String[ArrayExtensions.getLength(array)];
        for (int i = 0; i < ArrayExtensions.getLength(array); ++i) {
            strArray[i] = Serializer.serializeDecimal(new NullableBigDecimal(array[i]));
        }
        return StringExtensions.concat("[", StringExtensions.join(",", strArray), "]");
    }

    public static String serializeDouble(NullableDouble value) {
        if (!value.getHasValue()) {
            return "null";
        }
        return DoubleExtensions.toString(value.getValue());
    }

    public static String serializeDoubleArray(double[] array) {
        if (array == null) {
            return "null";
        }
        String[] strArray = new String[ArrayExtensions.getLength(array)];
        for (int i = 0; i < ArrayExtensions.getLength(array); ++i) {
            strArray[i] = Serializer.serializeDouble(new NullableDouble(array[i]));
        }
        return StringExtensions.concat("[", StringExtensions.join(",", strArray), "]");
    }

    public static String serializeFloat(NullableFloat value) {
        if (!value.getHasValue()) {
            return "null";
        }
        return FloatExtensions.toString(Float.valueOf(value.getValue()));
    }

    public static String serializeFloatArray(float[] array) {
        if (array == null) {
            return "null";
        }
        String[] strArray = new String[ArrayExtensions.getLength(array)];
        for (int i = 0; i < ArrayExtensions.getLength(array); ++i) {
            strArray[i] = Serializer.serializeFloat(new NullableFloat(array[i]));
        }
        return StringExtensions.concat("[", StringExtensions.join(",", strArray), "]");
    }

    public static String serializeGuid(NullableGuid value) {
        if (!value.getHasValue()) {
            return "null";
        }
        return StringExtensions.concat("\"", value.getValue().toString(), "\"");
    }

    public static String serializeGuidArray(Guid[] array) {
        if (array == null) {
            return "null";
        }
        String[] strArray = new String[ArrayExtensions.getLength(array)];
        for (int i = 0; i < ArrayExtensions.getLength(array); ++i) {
            strArray[i] = Serializer.serializeGuid(new NullableGuid(array[i]));
        }
        return StringExtensions.concat("[", StringExtensions.join(",", strArray), "]");
    }

    public static String serializeInteger(NullableInteger value) {
        if (!value.getHasValue()) {
            return "null";
        }
        return IntegerExtensions.toString(value.getValue());
    }

    public static String serializeIntegerArray(int[] array) {
        if (array == null) {
            return "null";
        }
        String[] strArray = new String[ArrayExtensions.getLength(array)];
        for (int i = 0; i < ArrayExtensions.getLength(array); ++i) {
            strArray[i] = Serializer.serializeInteger(new NullableInteger(array[i]));
        }
        return StringExtensions.concat("[", StringExtensions.join(",", strArray), "]");
    }

    public static String serializeLong(NullableLong value) {
        if (!value.getHasValue()) {
            return "null";
        }
        return LongExtensions.toString(value.getValue());
    }

    public static String serializeLongArray(long[] array) {
        if (array == null) {
            return "null";
        }
        String[] strArray = new String[ArrayExtensions.getLength(array)];
        for (int i = 0; i < ArrayExtensions.getLength(array); ++i) {
            strArray[i] = Serializer.serializeLong(new NullableLong(array[i]));
        }
        return StringExtensions.concat("[", StringExtensions.join(",", strArray), "]");
    }

    public static <T> String serializeObject(T source, SerializeCallback<T> callback) {
        if (source == null) {
            return "null";
        }
        HashMap<String, String> jsonObject = new HashMap<String, String>();
        callback.invoke(source, jsonObject);
        ArrayList<String> list = new ArrayList<String>(HashMapExtensions.getCount(jsonObject));
        for (String str : HashMapExtensions.getKeys(jsonObject)) {
            list.add(StringExtensions.concat(Serializer.serializeString(str), ":", HashMapExtensions.getItem(jsonObject).get(str)));
        }
        return StringExtensions.concat("{", StringExtensions.join(",", list.toArray(new String[0])), "}");
    }

    public static <T> String serializeObjectArray(T[] objects, SerializeCallback<T> callback) {
        if (objects == null) {
            return "null";
        }
        if (ArrayExtensions.getLength(objects) == 0) {
            return "[]";
        }
        String[] strArray = new String[ArrayExtensions.getLength(objects)];
        for (int i = 0; i < ArrayExtensions.getLength(objects); ++i) {
            strArray[i] = Serializer.serializeObject(objects[i], callback);
        }
        return StringExtensions.concat("[", StringExtensions.join(",", strArray), "]");
    }

    public static <T extends Serializable> String serializeObjectArrayFast(T[] objects, SerializeCallback<T> callback) {
        if (objects == null) {
            return "null";
        }
        if (ArrayExtensions.getLength(objects) == 0) {
            return "[]";
        }
        String[] strArray = new String[ArrayExtensions.getLength(objects)];
        for (int i = 0; i < ArrayExtensions.getLength(objects); ++i) {
            strArray[i] = Serializer.serializeObjectFast(objects[i], callback);
        }
        return StringExtensions.concat("[", StringExtensions.join(",", strArray), "]");
    }

    public static <T extends Serializable> String serializeObjectFast(T source, SerializeCallback<T> callback) {
        if (source == null) {
            return "null";
        }
        if (!source.getIsSerialized() || source.getIsDirty()) {
            source.setSerialized(Serializer.serializeObject(source, callback));
        }
        return source.getSerialized();
    }

    public static String serializeRaw(String dataJson) {
        return dataJson;
    }

    public static String serializeRawArray(String[] jsons) {
        if (jsons == null) {
            return "null";
        }
        return StringExtensions.concat("[", StringExtensions.join(",", jsons), "]");
    }

    public static String serializeString(String value) {
        if (value == null) {
            return "null";
        }
        return StringExtensions.concat("\"", Serializer.escapeString(value), "\"");
    }

    public static String serializeStringArray(String[] array) {
        if (array == null) {
            return "null";
        }
        String[] strArray = new String[ArrayExtensions.getLength(array)];
        for (int i = 0; i < ArrayExtensions.getLength(array); ++i) {
            strArray[i] = Serializer.serializeString(array[i]);
        }
        return StringExtensions.concat("[", StringExtensions.join(",", strArray), "]");
    }

    public static String trimQuotes(String value) {
        char ch2;
        char ch;
        if (StringExtensions.getLength(value) > 1 && (ch = value.charAt(0)) == (ch2 = value.charAt(StringExtensions.getLength(value) - 1)) && (ch == '\'' || ch == '\"')) {
            value = StringExtensions.substring(value, 1, StringExtensions.getLength(value) - 2);
        }
        return value;
    }

    public static String unescapeString(String text) throws Exception {
        StringBuilder builder = new StringBuilder();
        int startIndex = -1;
        for (int i = 0; i < StringExtensions.getLength(text); ++i) {
            char ch = text.charAt(i);
            if (ch == '\\') {
                if (startIndex != -1) {
                    StringBuilderExtensions.append(builder, text, startIndex, i - startIndex);
                    startIndex = -1;
                }
                if (i == StringExtensions.getLength(text) - 1) continue;
                char ch2 = text.charAt(i + 1);
                char _var0 = ch2;
                if (_var0 == 'b') {
                    StringBuilderExtensions.append(builder, "\b");
                } else if (_var0 == 'f') {
                    StringBuilderExtensions.append(builder, "\f");
                } else if (_var0 == 'n') {
                    StringBuilderExtensions.append(builder, "\n");
                } else if (_var0 == 'r') {
                    StringBuilderExtensions.append(builder, "\r");
                } else if (_var0 == 't') {
                    StringBuilderExtensions.append(builder, "\t");
                } else if (_var0 == '/') {
                    StringBuilderExtensions.append(builder, "/");
                } else if (_var0 == 'u') {
                    if (i < StringExtensions.getLength(text) - 5) {
                        StringBuilderExtensions.append(builder, CharacterExtensions.toString(Character.valueOf(Serializer.unicodeStringToChar(StringExtensions.substring(text, i, 6)))));
                        i += 4;
                    } else {
                        StringBuilderExtensions.append(builder, "u");
                    }
                } else if (_var0 == 'x') {
                    if (i < StringExtensions.getLength(text) - 3) {
                        StringBuilderExtensions.append(builder, CharacterExtensions.toString(Character.valueOf(Serializer.unicodeStringToChar(StringExtensions.substring(text, i, 4)))));
                        i += 2;
                    } else {
                        StringBuilderExtensions.append(builder, "x");
                    }
                } else {
                    StringBuilderExtensions.append(builder, CharacterExtensions.toString(Character.valueOf(ch2)));
                }
                ++i;
                continue;
            }
            if (startIndex != -1) continue;
            startIndex = i;
        }
        if (startIndex != -1) {
            StringBuilderExtensions.append(builder, text, startIndex, StringExtensions.getLength(text) - startIndex);
        }
        return builder.toString();
    }

    private static char unicodeStringToChar(String value) throws Exception {
        if (StringExtensions.getLength(value) < 2) {
            throw new Exception("Unicode string has invalid length.");
        }
        return (char)Convert.toInt32(value.substring(2), 16);
    }
}

