/*
 * Decompiled with CFR 0.152.
 */
package fm;

import java.nio.ByteBuffer;
import java.util.UUID;

public class Guid {
    public UUID uuid;
    public static final Guid empty = new Guid("00000000-0000-0000-0000-000000000000");

    public Guid(byte[] b) {
        ByteBuffer bb = ByteBuffer.wrap(b);
        this.uuid = new UUID(bb.getLong(), bb.getLong());
    }

    public Guid(String s) {
        this.uuid = UUID.fromString(s);
    }

    public String toString() {
        return this.uuid.toString();
    }

    public byte[] toByteArray() {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(this.uuid.getMostSignificantBits());
        bb.putLong(this.uuid.getLeastSignificantBits());
        return bb.array();
    }

    public static String toString(Guid guid) {
        return guid.toString();
    }

    public static Guid newGuid() {
        return new Guid(UUID.randomUUID().toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(this instanceof Guid)) {
            return false;
        }
        Guid other = (Guid)obj;
        return other.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public int compareTo(Guid guid) {
        return guid.uuid.compareTo(this.uuid);
    }
}

