/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.FileAccess;
import java.io.RandomAccessFile;

public class File {
    private String _path;
    private RandomAccessFile _file;

    public String getPath() {
        return this._path;
    }

    public File(String path) {
        this._path = path;
    }

    public boolean exists() {
        return new java.io.File(this._path).exists();
    }

    public void open(FileAccess access) throws Exception {
        if (access == FileAccess.Read) {
            this._file = new RandomAccessFile(this._path, "r");
        } else if (access == FileAccess.Write) {
            this._file = new RandomAccessFile(this._path, "rw");
        }
    }

    public void close() throws Exception {
        if (this._file != null) {
            this._file.close();
            this._file = null;
        }
    }

    public boolean flush() throws Exception {
        if (this._file == null) {
            return false;
        }
        this._file.getFD().sync();
        return true;
    }

    public boolean write(byte[] data, int index, int length) {
        if (this._file == null) {
            return false;
        }
        try {
            this._file.write(data, index, length);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean writeTo(int location, byte[] data, int index, int length) {
        if (this._file == null) {
            return false;
        }
        try {
            long position = this._file.getFilePointer();
            this._file.seek(location);
            this._file.write(data, index, length);
            this._file.seek(position);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public int read(byte[] data, int index, int length) {
        if (this._file == null) {
            return 0;
        }
        try {
            return this._file.read(data, index, length);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }
}

