/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.DoubleAction;
import fm.Log;
import fm.ManagedThread;
import fm.SingleAction;
import fm.StringExtensions;
import java.net.InetAddress;
import java.util.ArrayList;

public class DnsRequest {
    private String _name;
    private DoubleAction<String[], Object> _callback;
    private Object _state;

    public DnsRequest(String name, DoubleAction<String[], Object> callback, Object state) {
        this._name = name;
        this._callback = callback;
        this._state = state;
    }

    public String getName() {
        return this._name;
    }

    public DoubleAction<String[], Object> getCallback() {
        return this._callback;
    }

    public Object getState() {
        return this._state;
    }

    public void resolve() {
        new ManagedThread(new SingleAction<ManagedThread>(){

            @Override
            public void invoke(ManagedThread p) {
                ArrayList<String> addresses = new ArrayList<String>();
                try {
                    InetAddress[] inetAddresses;
                    for (InetAddress inetAddress : inetAddresses = InetAddress.getAllByName(DnsRequest.this._name)) {
                        addresses.add(inetAddress.getHostAddress());
                    }
                }
                catch (Exception ex) {
                    Log.error(StringExtensions.format("Could not resolve DNS name '{0}'.", DnsRequest.this._name), ex);
                }
                DnsRequest.this._callback.invoke(addresses.toArray(new String[addresses.size()]), DnsRequest.this._state);
            }
        }).start();
    }
}

