/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.Binary;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class BitAssistant {
    public static boolean isLittleEndian() {
        return false;
    }

    public static byte castByte(int value) {
        return (byte)value;
    }

    public static int castInteger(byte value) {
        int temp = value;
        if (temp < 0) {
            temp += 256;
        }
        return temp;
    }

    public static long castLong(byte value) {
        long temp = value;
        if (temp < 0L) {
            temp += 256L;
        }
        return temp;
    }

    public static byte leftShift(byte value, int count) {
        return (byte)(value << count);
    }

    public static short leftShiftShort(short value, int count) {
        return (short)(value << count);
    }

    public static int leftShiftInteger(int value, int count) {
        return value << count;
    }

    public static long leftShiftLong(long value, int count) {
        return value << count;
    }

    public static byte rightShift(byte value, int count) {
        return (byte)(value >>> count);
    }

    public static short rightShiftShort(short value, int count) {
        return (short)(value >>> count);
    }

    public static int rightShiftInteger(int value, int count) {
        return value >>> count;
    }

    public static long rightShiftLong(long value, int count) {
        return value >>> count;
    }

    public static boolean sequencesAreEqual(byte[] array1, byte[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean sequencesAreEqual(byte[] array1, int offset1, byte[] array2, int offset2, int length) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length < offset1 + length || array2.length < offset2 + length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array1[offset1 + i] == array2[offset2 + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean sequencesAreEqualConstantTime(byte[] array1, byte[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        boolean areEqual = true;
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            areEqual = false;
        }
        return areEqual;
    }

    public static boolean sequencesAreEqualConstantTime(byte[] array1, int offset1, byte[] array2, int offset2, int length) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length < offset1 + length || array2.length < offset2 + length) {
            return false;
        }
        boolean areEqual = true;
        for (int i = 0; i < length; ++i) {
            if (array1[offset1 + i] == array2[offset2 + i]) continue;
            areEqual = false;
        }
        return areEqual;
    }

    public static byte[] subArray(byte[] array, int offset) {
        return BitAssistant.subArray(array, offset, array.length - offset);
    }

    public static byte[] subArray(byte[] array, int offset, int count) {
        byte[] subarray = new byte[count];
        for (int i = 0; i < count; ++i) {
            subarray[i] = array[offset + i];
        }
        return subarray;
    }

    public static void reverse(byte[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            byte t = array[array.length - i - 1];
            array[array.length - i - 1] = array[i];
            array[i] = t;
        }
    }

    public static void copy(byte[] source, int sourceIndex, byte[] destination, int destinationIndex, int length) {
        System.arraycopy(source, sourceIndex, destination, destinationIndex, length);
    }

    public static void copyFloats(float[] source, int sourceIndex, float[] destination, int destinationIndex, int length) {
        System.arraycopy(source, sourceIndex, destination, destinationIndex, length);
    }

    public static void set(byte[] array, int index, int length, int value) {
        Arrays.fill(array, index, index + length, (byte)value);
    }

    public static String getHexString(byte[] array) {
        return BitAssistant.getHexString(array, 0, array.length);
    }

    public static String getHexString(byte[] array, int offset, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = offset; i < offset + length; ++i) {
            String hex = Integer.toHexString(0xFF & array[i]);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static byte[] getHexBytes(String s) {
        int len = s.length();
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            bytes[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return bytes;
    }

    public static String getBinaryString(byte[] array) {
        return BitAssistant.getBinaryString(array, 0, array.length);
    }

    public static String getBinaryString(byte[] array, int offset, int length) {
        StringBuilder sb = new StringBuilder(length * 8);
        for (int i = offset; i < offset + length; ++i) {
            sb.append(String.format("%8s", Integer.toBinaryString(array[i] & 0xFF)).replace(' ', '0'));
        }
        return sb.toString();
    }

    public static byte[] getBinaryBytes(String s) {
        if (s.length() % 8 == 0) {
            byte[] bytes = new byte[s.length() / 8];
            int i = 0;
            int j = 0;
            while (i < bytes.length) {
                bytes[i] = (byte)Integer.parseInt(s.substring(j, j + 8), 2);
                ++i;
                j += 8;
            }
            return bytes;
        }
        return new byte[0];
    }

    public static byte[] getFloatBytesNetwork(float value) {
        return ByteBuffer.allocate(4).putFloat(value).array();
    }

    public static byte[] getDoubleBytesNetwork(double value) {
        return ByteBuffer.allocate(4).putDouble(value).array();
    }

    public static byte[] getShortBytesNetwork(short value) {
        return Binary.toBytes16(value, false);
    }

    public static byte[] getShortBytesFromIntegerNetwork(int value) {
        return Binary.toBytes16(value, false);
    }

    public static byte[] getIntegerBytesNetwork(int value) {
        return Binary.toBytes32(value, false);
    }

    public static byte[] getIntegerBytesFromLongNetwork(long value) {
        return Binary.toBytes32(value, false);
    }

    public static byte[] getLongBytesNetwork(long value) {
        return Binary.toBytes64(value, false);
    }

    public static float toFloatNetwork(byte[] value, int startIndex) {
        return ByteBuffer.wrap(value, startIndex, 4).order(ByteOrder.BIG_ENDIAN).getFloat();
    }

    public static double toDoubleNetwork(byte[] value, int startIndex) {
        return ByteBuffer.wrap(value, startIndex, 8).order(ByteOrder.BIG_ENDIAN).getDouble();
    }

    public static short toShortNetwork(byte[] value, int startIndex) {
        return (short)Binary.fromBytes16(value, startIndex, false);
    }

    public static int toIntegerFromShortNetwork(byte[] value, int startIndex) {
        return Binary.fromBytes16(value, startIndex, false);
    }

    public static int toIntegerNetwork(byte[] value, int startIndex) {
        return (int)Binary.fromBytes32(value, startIndex, false);
    }

    public static long toLongFromIntegerNetwork(byte[] value, int startIndex) {
        return Binary.fromBytes32(value, startIndex, false);
    }

    public static long toLongNetwork(byte[] value, int startIndex) {
        return Binary.fromBytes64(value, startIndex, false);
    }
}

