/*
 * Decompiled with CFR 0.152.
 */
package fm;

import android.util.Log;
import fm.LogLevel;
import fm.LogProvider;
import java.util.Locale;

public class AndroidLogProvider
extends LogProvider {
    private String tag = "fm";

    public AndroidLogProvider() {
        this(LogLevel.Warn);
    }

    public AndroidLogProvider(LogLevel level) {
        this.setLevel(level);
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    @Override
    public void writeLine(String text) {
        System.out.println(text);
    }

    @Override
    protected void log(LogLevel level, String message) {
        if (level == LogLevel.Debug) {
            Log.d((String)this.tag, (String)message);
        } else if (level == LogLevel.Info) {
            Log.i((String)this.tag, (String)message);
        } else if (level == LogLevel.Warn) {
            Log.w((String)this.tag, (String)message);
        } else if (level == LogLevel.Error) {
            Log.e((String)this.tag, (String)message);
        } else if (level == LogLevel.Fatal) {
            Log.e((String)this.tag, (String)message);
        } else {
            Log.v((String)this.tag, (String)message);
        }
    }

    @Override
    protected void log(LogLevel level, String message, Exception ex) {
        if (level == LogLevel.Debug) {
            Log.d((String)this.tag, (String)String.format(Locale.getDefault(), "%s %s", message, ex.getMessage()));
        } else if (level == LogLevel.Info) {
            Log.i((String)this.tag, (String)String.format(Locale.getDefault(), "%s %s", message, ex.getMessage()));
        } else if (level == LogLevel.Warn) {
            Log.w((String)this.tag, (String)String.format(Locale.getDefault(), "%s %s", message, ex.getMessage()));
        } else if (level == LogLevel.Error) {
            Log.e((String)this.tag, (String)String.format(Locale.getDefault(), "%s %s", message, ex.getMessage()));
        } else if (level == LogLevel.Fatal) {
            Log.e((String)this.tag, (String)String.format(Locale.getDefault(), "%s %s", message, ex.getMessage()));
        } else {
            Log.v((String)this.tag, (String)String.format(Locale.getDefault(), "%s %s", message, ex.getMessage()));
        }
    }
}

