/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import android.os.Process;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.ResponseDelivery;
import com.android.volley.VolleyLog;
import java.util.concurrent.BlockingQueue;

public class CacheDispatcher
extends Thread {
    private static final boolean DEBUG = VolleyLog.DEBUG;
    private final BlockingQueue<Request<?>> mCacheQueue;
    private final BlockingQueue<Request<?>> mNetworkQueue;
    private final Cache mCache;
    private final ResponseDelivery mDelivery;
    private volatile boolean mQuit = false;

    public CacheDispatcher(BlockingQueue<Request<?>> cacheQueue, BlockingQueue<Request<?>> networkQueue, Cache cache, ResponseDelivery delivery) {
        this.mCacheQueue = cacheQueue;
        this.mNetworkQueue = networkQueue;
        this.mCache = cache;
        this.mDelivery = delivery;
    }

    public void quit() {
        this.mQuit = true;
        this.interrupt();
    }

    @Override
    public void run() {
        if (DEBUG) {
            VolleyLog.v("start new dispatcher", new Object[0]);
        }
        Process.setThreadPriority((int)10);
        this.mCache.initialize();
        while (true) {
            Request<?> request = null;
            try {
                request = this.mCacheQueue.take();
            }
            catch (InterruptedException e) {
                if (!this.mQuit) continue;
                return;
            }
            try {
                request.addMarker("cache-queue-take");
                if (request.isCanceled()) {
                    request.finish("cache-discard-canceled");
                    continue;
                }
                Cache.Entry entry = this.mCache.get(request.getCacheKey());
                if (entry == null) {
                    request.addMarker("cache-miss");
                    this.mNetworkQueue.put(request);
                    continue;
                }
                if (entry.isExpired()) {
                    request.addMarker("cache-hit-expired");
                    request.setCacheEntry(entry);
                    this.mNetworkQueue.put(request);
                    continue;
                }
                request.addMarker("cache-hit");
                Response<?> response = request.parseNetworkResponse(new NetworkResponse(entry.data, entry.responseHeaders));
                request.addMarker("cache-hit-parsed");
                if (!entry.refreshNeeded()) {
                    this.mDelivery.postResponse(request, response);
                    continue;
                }
                request.addMarker("cache-hit-refresh-needed");
                request.setCacheEntry(entry);
                response.intermediate = true;
                final Request<?> finalRequest = request;
                this.mDelivery.postResponse(request, response, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CacheDispatcher.this.mNetworkQueue.put(finalRequest);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
                continue;
            }
            catch (Exception e) {
                VolleyLog.e(e, "Unhandled exception %s", e.toString());
                continue;
            }
            break;
        }
    }
}

