/*
 * Decompiled with CFR 0.152.
 */
package com.mcxiaoke.packer.support.walle;

import com.mcxiaoke.packer.support.walle.ApkSigningBlock;
import com.mcxiaoke.packer.support.walle.ApkSigningPayload;
import com.mcxiaoke.packer.support.walle.ApkUtil;
import com.mcxiaoke.packer.support.walle.Pair;
import com.mcxiaoke.packer.support.walle.V2Utils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

final class PayloadWriter {
    private PayloadWriter() {
    }

    public static void writeBlock(File apkFile, int id, byte[] bytes) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(bytes.length);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(bytes, 0, bytes.length);
        byteBuffer.flip();
        PayloadWriter.writeBlock(apkFile, id, byteBuffer);
    }

    public static void writeBlock(File apkFile, int id, ByteBuffer buffer) throws IOException {
        HashMap<Integer, ByteBuffer> idValues = new HashMap<Integer, ByteBuffer>();
        idValues.put(id, buffer);
        PayloadWriter.writeValues(apkFile, idValues);
    }

    private static void writeValues(File apkFile, final Map<Integer, ByteBuffer> idValues) throws IOException {
        ApkSigningBlockHandler handler = new ApkSigningBlockHandler(){

            @Override
            public ApkSigningBlock handle(Map<Integer, ByteBuffer> originIdValues) {
                if (idValues != null && !idValues.isEmpty()) {
                    originIdValues.putAll(idValues);
                }
                ApkSigningBlock apkSigningBlock = new ApkSigningBlock();
                Set<Map.Entry<Integer, ByteBuffer>> entrySet = originIdValues.entrySet();
                for (Map.Entry<Integer, ByteBuffer> entry : entrySet) {
                    ApkSigningPayload payload = new ApkSigningPayload(entry.getKey(), entry.getValue());
                    apkSigningBlock.addPayload(payload);
                }
                return apkSigningBlock;
            }
        };
        PayloadWriter.writeApkSigningBlock(apkFile, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeApkSigningBlock(File apkFile, ApkSigningBlockHandler handler) throws IOException {
        RandomAccessFile raf = null;
        FileChannel fc = null;
        try {
            raf = new RandomAccessFile(apkFile, "rw");
            fc = raf.getChannel();
            long commentLength = ApkUtil.findZipCommentLength(fc);
            long centralDirStartOffset = ApkUtil.findCentralDirStartOffset(fc, commentLength);
            Pair<ByteBuffer, Long> apkSigningBlockAndOffset = ApkUtil.findApkSigningBlock(fc, centralDirStartOffset);
            ByteBuffer apkSigningBlock2 = apkSigningBlockAndOffset.getFirst();
            long apkSigningBlockOffset = apkSigningBlockAndOffset.getSecond();
            if (centralDirStartOffset == 0L || apkSigningBlockOffset == 0L) {
                throw new IOException("No APK Signature Scheme v2 block in APK Signing Block");
            }
            Map<Integer, ByteBuffer> originIdValues = ApkUtil.findIdValues(apkSigningBlock2);
            ByteBuffer apkSignatureSchemeV2Block = originIdValues.get(1896449818);
            if (apkSignatureSchemeV2Block == null) {
                throw new IOException("No APK Signature Scheme v2 block in APK Signing Block");
            }
            ApkSigningBlock apkSigningBlock = handler.handle(originIdValues);
            raf.seek(centralDirStartOffset);
            byte[] centralDirBytes = new byte[(int)(fc.size() - centralDirStartOffset)];
            raf.read(centralDirBytes);
            fc.position(apkSigningBlockOffset);
            long length = apkSigningBlock.writeTo(raf);
            raf.write(centralDirBytes);
            raf.setLength(raf.getFilePointer());
            raf.seek(fc.size() - commentLength - 6L);
            ByteBuffer temp = ByteBuffer.allocate(4);
            temp.order(ByteOrder.LITTLE_ENDIAN);
            temp.putInt((int)(centralDirStartOffset + length + 8L - (centralDirStartOffset - apkSigningBlockOffset)));
            temp.flip();
            raf.write(temp.array());
        }
        catch (Throwable throwable) {
            V2Utils.close(fc);
            V2Utils.close(raf);
            throw throwable;
        }
        V2Utils.close(fc);
        V2Utils.close(raf);
    }

    static interface ApkSigningBlockHandler {
        public ApkSigningBlock handle(Map<Integer, ByteBuffer> var1);
    }
}

