/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.naming;

import com.mchange.v2.cfg.PropertiesConfig;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.naming.ReferenceableUtils;
import com.mchange.v2.ser.IndirectlySerialized;
import com.mchange.v2.ser.Indirector;
import com.mchange.v2.util.MapUtils;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class ReferenceIndirector
implements Indirector {
    static final MLogger logger = MLog.getLogger(ReferenceIndirector.class);
    Name name;
    Name contextName;
    Hashtable environmentProperties;

    private static String envToString(Hashtable hashtable) {
        if (hashtable == null) {
            return "null";
        }
        return "[" + MapUtils.joinEntriesIntoString(true, true, "->", ",", hashtable) + "]";
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public Name getNameContextName() {
        return this.contextName;
    }

    public void setNameContextName(Name name) {
        this.contextName = name;
    }

    public Hashtable getEnvironmentProperties() {
        return this.environmentProperties;
    }

    public void setEnvironmentProperties(Hashtable hashtable) {
        this.environmentProperties = hashtable;
    }

    @Override
    public IndirectlySerialized indirectForm(Object object) throws Exception {
        Reference reference = ((Referenceable)object).getReference();
        return new ReferenceSerialized(reference, this.name, this.contextName, this.environmentProperties);
    }

    private static class ReferenceSerialized
    implements IndirectlySerialized {
        Reference reference;
        Name name;
        Name contextName;
        Hashtable env;

        ReferenceSerialized(Reference reference, Name name, Name name2, Hashtable hashtable) {
            this.reference = reference;
            this.name = name;
            this.contextName = name2;
            this.env = hashtable;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getClass().getName());
            stringBuilder.append("[reference=");
            stringBuilder.append(this.reference);
            stringBuilder.append("; name=");
            stringBuilder.append(this.name);
            stringBuilder.append("; contextName=");
            stringBuilder.append(this.contextName);
            stringBuilder.append("; env=");
            stringBuilder.append(ReferenceIndirector.envToString(this.env));
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        @Override
        public Object getObject() throws ClassNotFoundException, IOException {
            return this.getObject(null);
        }

        @Override
        public Object getObject(PropertiesConfig propertiesConfig) throws ClassNotFoundException, IOException {
            try {
                InitialContext initialContext;
                if (this.env == null) {
                    initialContext = new InitialContext();
                } else if (ReferenceableUtils.acceptDeserializedInitialContextEnvironment(propertiesConfig)) {
                    initialContext = new InitialContext(this.env);
                } else {
                    throw new IOException("A value indirectly serialized as a reference includes a non-default (non-null) InitialContext environment by which the reference wishes to be looked up. InitialContext environment parameters can redirect lookups to untrusted remote servers and potentially lead to download and execution of malicious code. SecurityConfigKey 'com.mchange.v2.naming.acceptDeserializedInitialContextEnvironment' is set conservatively to false, so this operation is not supported. Indirectly serialized reference: " + this.toString());
                }
                Context context = null;
                if (this.contextName != null) {
                    try {
                        ReferenceableUtils.assertAcceptableName(this.contextName, propertiesConfig);
                        context = (Context)initialContext.lookup(this.contextName);
                    }
                    catch (NamingException namingException) {
                        throw new IOException(namingException.getMessage(), namingException);
                    }
                }
                try {
                    return ReferenceableUtils.referenceToObject(this.reference, this.name, context, this.env, propertiesConfig);
                }
                catch (NamingException namingException) {
                    throw new IOException("Failed to dereference reference " + this.reference + "' under name '" + this.name + "' and nameContext '" + context + "' using environment: " + ReferenceIndirector.envToString(this.env), namingException);
                }
            }
            catch (NamingException namingException) {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "Failed to acquire the Context necessary to lookup an Object.", namingException);
                }
                throw new InvalidObjectException("Failed to acquire the Context necessary to lookup an Object: " + namingException.toString());
            }
        }
    }
}

