/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v3.hocon;

import com.mchange.v2.cfg.DelayedLogItem;
import com.mchange.v2.cfg.PropertiesConfigSource;
import com.mchange.v3.hocon.HoconUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class HoconPropertiesConfigSource
implements PropertiesConfigSource {
    private static Config extractConfig(String string, List<DelayedLogItem> list) throws FileNotFoundException, Exception {
        int n = string.indexOf(58);
        ArrayList<Config> arrayList = new ArrayList<Config>();
        if (n >= 0 && "hocon".equals(string.substring(0, n).toLowerCase())) {
            Config config;
            String string2 = string.substring(n).trim();
            for (String string3 : config = string2.split("\\s*,\\s*")) {
                String string4;
                String string5;
                int n2 = string3.lastIndexOf(35);
                if (n2 > 0) {
                    string5 = string3.substring(0, n2);
                    string4 = string3.substring(n2 + 1).replace('/', '.').trim();
                } else {
                    string5 = string3;
                    string4 = null;
                }
                Config config2 = null;
                if ("/".equals(string5)) {
                    config2 = ConfigFactory.systemProperties();
                } else {
                    URL uRL = HoconPropertiesConfigSource.class.getResource(string5);
                    if (uRL == null) {
                        list.add(new DelayedLogItem(DelayedLogItem.Level.FINE, String.format("Could not find HOCON configuration for resource path '%s'.", string5)));
                    } else {
                        config2 = ConfigFactory.parseURL((URL)uRL);
                    }
                }
                if (config2 == null) continue;
                if (string4 != null) {
                    config2 = config2.getConfig(string4);
                }
                arrayList.add(config2);
            }
            if (arrayList.size() == 0) {
                throw new FileNotFoundException(String.format("Could not find HOCON configuration at any of the listed resources in '%s'", string));
            }
            Config config3 = ConfigFactory.empty();
            int n3 = arrayList.size();
            while (--n3 >= 0) {
                config3 = config3.withFallback((ConfigMergeable)arrayList.get(n3));
            }
            return config3.resolve();
        }
        throw new IllegalArgumentException(String.format("Invalid resource identifier for hocon config file: '%s'", string));
    }

    @Override
    public PropertiesConfigSource.Parse propertiesFromSource(String string) throws FileNotFoundException, Exception {
        LinkedList<DelayedLogItem> linkedList = new LinkedList<DelayedLogItem>();
        Config config = HoconPropertiesConfigSource.extractConfig(string, linkedList);
        HoconUtils.PropertiesConversion propertiesConversion = HoconUtils.configToProperties(config);
        for (String string2 : propertiesConversion.unrenderable) {
            linkedList.add(new DelayedLogItem(DelayedLogItem.Level.FINE, String.format("Value at path '%s' could not be converted to a String. Skipping.", string2)));
        }
        return new PropertiesConfigSource.Parse(propertiesConversion.properties, linkedList);
    }
}

