/*
 * Decompiled with CFR 0.152.
 */
package com.mastertechsoftware.tasker;

import android.os.Handler;
import android.os.Looper;
import com.mastertechsoftware.logging.Logger;
import com.mastertechsoftware.tasker.Condition;
import com.mastertechsoftware.tasker.Pausable;
import com.mastertechsoftware.tasker.Task;
import com.mastertechsoftware.tasker.TaskFinisher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public class Tasker {
    private static final String TAG = Tasker.class.getSimpleName();
    protected Handler handler;
    protected ExecutorService mExecutor = Executors.newSingleThreadExecutor();
    protected LinkedBlockingDeque<Task> tasks = new LinkedBlockingDeque();
    protected TaskFinisher finisher;
    protected boolean debugging = false;
    protected Task lastAddedTask;
    protected Map<ThreadRunnable, Future> runableMap = new ConcurrentHashMap<ThreadRunnable, Future>();
    protected List<Exception> errors = new ArrayList<Exception>();
    protected Object previousResult;

    public static Tasker create() {
        return new Tasker();
    }

    public Tasker addTask(Task task) {
        this.tasks.add(task);
        this.lastAddedTask = task;
        return this;
    }

    protected void createHandler() {
        if (this.handler != null) {
            return;
        }
        try {
            this.handler = new Handler(Looper.getMainLooper());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public Tasker addUITask(Task task) {
        this.tasks.add(task);
        task.setRunType(THREAD_TYPE.UI);
        this.lastAddedTask = task;
        return this;
    }

    public Tasker addFinisher(TaskFinisher finisher) {
        this.finisher = finisher;
        return this;
    }

    public Tasker withCondition(Condition condition) {
        this.lastAddedTask.setCondition(condition);
        return this;
    }

    public void cancelAll() {
        for (Future future : this.runableMap.values()) {
            future.cancel(true);
        }
        this.runableMap.clear();
        this.shutdown();
    }

    private void shutdown() {
        if (!this.mExecutor.isShutdown() && !this.mExecutor.isTerminated()) {
            this.mExecutor.shutdown();
            try {
                this.mExecutor.awaitTermination(2L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                Logger.error((String)"Problems awaiting Executor shutdown");
            }
        }
    }

    public boolean cancelTask(Task task) {
        for (ThreadRunnable threadRunnable : this.runableMap.keySet()) {
            if (threadRunnable.task != task) continue;
            Future future = this.runableMap.remove(threadRunnable);
            if (future != null) {
                future.cancel(true);
            }
            return true;
        }
        return false;
    }

    public boolean run() {
        try {
            for (Task task : this.tasks) {
                ThreadRunnable threadRunnable = new ThreadRunnable(task);
                this.recreateExecutorIfNecessary();
                Future future = this.mExecutor.submit(threadRunnable);
                this.runableMap.put(threadRunnable, future);
            }
            this.tasks.clear();
        }
        catch (Exception RejectedExecutionException) {
            Logger.error((String)"Tasker:run - RejectedExecutionException", (Throwable)RejectedExecutionException);
            return false;
        }
        return true;
    }

    private void recreateExecutorIfNecessary() {
        if (this.mExecutor == null || this.mExecutor.isShutdown() || this.mExecutor.isTerminated()) {
            if (this.mExecutor != null) {
                Logger.error((String)"Tasker:run - Executor is shutdown. Recreating");
            }
            this.mExecutor = Executors.newSingleThreadExecutor();
        }
    }

    protected void runnableFinished(ThreadRunnable threadRunnable) {
        Logger.debug((boolean)this.debugging, (String)"runnableFinished");
        this.runableMap.remove(threadRunnable);
        Task task = threadRunnable.getTask();
        this.previousResult = task.getResult();
        if (this.runableMap.isEmpty() && this.finisher != null) {
            this.createHandler();
            Logger.debug((boolean)this.debugging, (String)"Calling finisher");
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Tasker.this.finisher.finished(Tasker.this.errors);
                }
            });
        }
        if (this.runableMap.isEmpty()) {
            this.shutdown();
        }
    }

    class ThreadRunnable
    implements Callable,
    Pausable {
        protected Task task;
        protected Object result;
        protected CountDownLatch uiWait = new CountDownLatch(1);
        protected CountDownLatch pauseWait = new CountDownLatch(1);
        protected boolean paused = false;

        ThreadRunnable(Task task) {
            this.task = task;
            task.setPauseable(this);
        }

        public Task getTask() {
            return this.task;
        }

        public Object call() throws Exception {
            try {
                if (this.task.hasCondition() && !this.task.getCondition().shouldExecute()) {
                    Logger.debug((boolean)Tasker.this.debugging, (String)"Tasks condition failed. Not running task");
                    Tasker.this.runnableFinished(this);
                    return null;
                }
                Tasker.this.createHandler();
                if (Tasker.this.previousResult != null) {
                    this.task.setPreviousResult(Tasker.this.previousResult);
                    Tasker.this.previousResult = null;
                }
                if (this.task.runType() == THREAD_TYPE.BACKGROUND) {
                    Logger.debug((boolean)Tasker.this.debugging, (String)"Running task in background");
                    this.result = this.task.run();
                    this.task.setResult(this.result);
                } else {
                    Tasker.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            block2: {
                                try {
                                    Logger.debug((boolean)Tasker.this.debugging, (String)"Running task on UI Thread");
                                    ThreadRunnable.this.result = ThreadRunnable.this.task.run();
                                    ThreadRunnable.this.task.setResult(ThreadRunnable.this.result);
                                    ThreadRunnable.this.uiWait.countDown();
                                }
                                catch (Exception e) {
                                    ThreadRunnable.this.task.setError(e);
                                    if (ThreadRunnable.this.task.runType() != THREAD_TYPE.UI) break block2;
                                    ThreadRunnable.this.uiWait.countDown();
                                }
                            }
                        }
                    });
                    this.uiWait.await();
                }
                if (this.paused) {
                    this.pauseWait.await();
                }
                Tasker.this.runnableFinished(this);
                if (!this.task.shouldContinue()) {
                    Tasker.this.cancelAll();
                }
                return this.result;
            }
            catch (Exception e) {
                Logger.error((String)"run caught exception", (Throwable)e);
                Tasker.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Tasker.this.errors.add(e);
                            ThreadRunnable.this.task.setError(e);
                        }
                        catch (Exception e2) {
                            Logger.error((String)"run caught exception in setError", (Throwable)e2);
                        }
                    }
                });
                Tasker.this.runnableFinished(this);
                return null;
            }
        }

        @Override
        public boolean isPaused() {
            return this.paused;
        }

        @Override
        public void setPaused(boolean paused) {
            this.paused = paused;
            if (!paused) {
                this.pauseWait.countDown();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ThreadRunnable that = (ThreadRunnable)o;
            return this.task != null ? this.task.equals(that.task) : that.task == null;
        }

        public int hashCode() {
            return this.task != null ? this.task.hashCode() : 0;
        }
    }

    public static enum THREAD_TYPE {
        UI,
        BACKGROUND;

    }
}

