/*
 * Decompiled with CFR 0.152.
 */
package com.mashape.unirest.request.body;

import com.mashape.unirest.http.utils.MapUtil;
import com.mashape.unirest.request.BaseRequest;
import com.mashape.unirest.request.HttpRequest;
import com.mashape.unirest.request.body.Body;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;

public class MultipartBody
extends BaseRequest
implements Body {
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private boolean hasFile;
    private HttpRequest httpRequestObj;

    public MultipartBody(HttpRequest httpRequest) {
        super(httpRequest);
        this.httpRequestObj = httpRequest;
    }

    public MultipartBody field(String name, String value) {
        this.parameters.put(name, value);
        return this;
    }

    public MultipartBody field(String name, File file) {
        this.parameters.put(name, file);
        this.hasFile = true;
        return this;
    }

    public MultipartBody basicAuth(String username, String password) {
        this.httpRequestObj.basicAuth(username, password);
        return this;
    }

    public HttpEntity getEntity() {
        if (this.hasFile) {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            for (Map.Entry<String, Object> part : this.parameters.entrySet()) {
                if (part.getValue() instanceof File) {
                    this.hasFile = true;
                    builder.addPart(part.getKey(), (ContentBody)new FileBody((File)part.getValue()));
                    continue;
                }
                builder.addPart(part.getKey(), (ContentBody)new StringBody(part.getValue().toString(), ContentType.APPLICATION_FORM_URLENCODED));
            }
            return builder.build();
        }
        try {
            return new UrlEncodedFormEntity(MapUtil.getList(this.parameters), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

