/*
 * Decompiled with CFR 0.152.
 */
package com.mashape.unirest.http.options;

import com.mashape.unirest.http.async.utils.AsyncIdleConnectionMonitorThread;
import com.mashape.unirest.http.options.Option;
import com.mashape.unirest.http.utils.SyncIdleConnectionMonitorThread;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;

public class Options {
    private static final int MAX_PER_ROUTE = 10000;
    private static final int MAX_TOTAL = 10000;
    public static final long CONNECTION_TIMEOUT = 10000L;
    private static final long SOCKET_TIMEOUT = 60000L;
    private static Map<Option, Object> options = new HashMap<Option, Object>();

    public static void setOption(Option option, Object value) {
        options.put(option, value);
    }

    public static Object getOption(Option option) {
        return options.get((Object)option);
    }

    public static void refresh() {
        PoolingNHttpClientConnectionManager asyncConnectionManager;
        Object socketTimeout;
        Object connectionTimeout = Options.getOption(Option.CONNECTION_TIMEOUT);
        if (connectionTimeout == null) {
            connectionTimeout = 10000L;
        }
        if ((socketTimeout = Options.getOption(Option.SOCKET_TIMEOUT)) == null) {
            socketTimeout = 60000L;
        }
        RequestConfig clientConfig = RequestConfig.custom().setConnectTimeout(((Long)connectionTimeout).intValue()).setSocketTimeout(((Long)socketTimeout).intValue()).setConnectionRequestTimeout(((Long)socketTimeout).intValue()).build();
        PoolingHttpClientConnectionManager syncConnectionManager = new PoolingHttpClientConnectionManager();
        syncConnectionManager.setMaxTotal(10000);
        syncConnectionManager.setDefaultMaxPerRoute(10000);
        Options.setOption(Option.HTTPCLIENT, HttpClientBuilder.create().setDefaultRequestConfig(clientConfig).setConnectionManager((HttpClientConnectionManager)syncConnectionManager).build());
        SyncIdleConnectionMonitorThread syncIdleConnectionMonitorThread = new SyncIdleConnectionMonitorThread((HttpClientConnectionManager)syncConnectionManager);
        Options.setOption(Option.SYNC_MONITOR, syncIdleConnectionMonitorThread);
        syncIdleConnectionMonitorThread.start();
        try {
            DefaultConnectingIOReactor ioreactor = new DefaultConnectingIOReactor();
            asyncConnectionManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioreactor);
            asyncConnectionManager.setMaxTotal(10000);
            asyncConnectionManager.setDefaultMaxPerRoute(10000);
        }
        catch (IOReactorException e) {
            throw new RuntimeException(e);
        }
        CloseableHttpAsyncClient asyncClient = HttpAsyncClientBuilder.create().setDefaultRequestConfig(clientConfig).setConnectionManager((NHttpClientConnectionManager)asyncConnectionManager).build();
        Options.setOption(Option.ASYNCHTTPCLIENT, asyncClient);
        Options.setOption(Option.ASYNC_MONITOR, new AsyncIdleConnectionMonitorThread(asyncConnectionManager));
    }

    static {
        Options.refresh();
    }
}

