/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.uiUtils;

import android.content.Context;
import android.graphics.PointF;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.LinearSmoothScroller;
import android.support.v7.widget.RecyclerView;
import android.view.View;

public class ScrollSmoothLineaerLayoutManager
extends LinearLayoutManager {
    private final int duration;

    public ScrollSmoothLineaerLayoutManager(Context context, int orientation, boolean reverseLayout, int duration) {
        super(context, orientation, reverseLayout);
        this.duration = duration;
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        View firstVisibleChild = recyclerView.getChildAt(0);
        int itemHeight = firstVisibleChild.getHeight();
        int currentPosition = recyclerView.getChildLayoutPosition(firstVisibleChild);
        int distanceInPixels = Math.abs((currentPosition - position) * itemHeight);
        if (distanceInPixels == 0) {
            distanceInPixels = (int)Math.abs(firstVisibleChild.getY());
        }
        SmoothScroller smoothScroller = new SmoothScroller(recyclerView.getContext(), distanceInPixels, this.duration);
        smoothScroller.setTargetPosition(position);
        this.startSmoothScroll((RecyclerView.SmoothScroller)smoothScroller);
    }

    private class SmoothScroller
    extends LinearSmoothScroller {
        private static final int TARGET_SEEK_SCROLL_DISTANCE_PX = 10000;
        private final float distanceInPixels;
        private final float duration;

        public SmoothScroller(Context context, int distanceInPixels, int duration) {
            super(context);
            this.distanceInPixels = distanceInPixels;
            float millisecondsPerPx = this.calculateSpeedPerPixel(context.getResources().getDisplayMetrics());
            this.duration = distanceInPixels < 10000 ? (float)((int)((float)Math.abs(distanceInPixels) * millisecondsPerPx)) : (float)duration;
        }

        public PointF computeScrollVectorForPosition(int targetPosition) {
            return ScrollSmoothLineaerLayoutManager.this.computeScrollVectorForPosition(targetPosition);
        }

        protected int calculateTimeForScrolling(int dx) {
            float proportion = (float)dx / this.distanceInPixels;
            return (int)(this.duration * proportion);
        }
    }
}

