/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.swipelistview;

import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.support.v4.view.MotionEventCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import com.marshalchen.ultimaterecyclerview.swipelistview.SwipeListView;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.ValueAnimator;
import com.nineoldandroids.view.ViewHelper;
import com.nineoldandroids.view.ViewPropertyAnimator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SwipeListViewTouchListener
implements View.OnTouchListener {
    private static final int DISPLACE_CHOICE = 80;
    private int swipeMode = 1;
    private boolean swipeOpenOnLongPress = true;
    private boolean swipeClosesAllItemsWhenListMoves = true;
    private int swipeFrontView = 0;
    private int swipeBackView = 0;
    private Rect rect = new Rect();
    private int slop;
    private int minFlingVelocity;
    private int maxFlingVelocity;
    private long configShortAnimationTime;
    private long animationTime;
    private float leftOffset = 0.0f;
    private float rightOffset = 0.0f;
    private int swipeDrawableChecked = 0;
    private int swipeDrawableUnchecked = 0;
    private boolean onlyOneOpenedWhenSwipe = false;
    private LinearLayoutManager mLayoutManager;
    private SwipeListView swipeListView;
    private int viewWidth = 1;
    private List<PendingDismissData> pendingDismisses = new ArrayList<PendingDismissData>();
    private int dismissAnimationRefCount = 0;
    private float downX;
    private boolean swiping;
    private boolean swipingRight;
    private VelocityTracker velocityTracker;
    private int downPosition;
    private View parentView;
    private View frontView;
    private View backView;
    private boolean paused;
    private int swipeCurrentAction = 3;
    private int swipeActionLeft = 0;
    private int swipeActionRight = 0;
    private List<Boolean> opened = new ArrayList<Boolean>();
    private List<Boolean> openedRight = new ArrayList<Boolean>();
    private boolean listViewMoving;
    private List<Boolean> checked = new ArrayList<Boolean>();
    private int oldSwipeActionRight;
    private int oldSwipeActionLeft;

    public SwipeListViewTouchListener(SwipeListView swipeListView, int swipeFrontView, int swipeBackView) {
        this.swipeFrontView = swipeFrontView;
        this.swipeBackView = swipeBackView;
        ViewConfiguration vc = ViewConfiguration.get((Context)swipeListView.getContext());
        this.slop = vc.getScaledTouchSlop();
        this.minFlingVelocity = vc.getScaledMinimumFlingVelocity();
        this.maxFlingVelocity = vc.getScaledMaximumFlingVelocity();
        this.animationTime = this.configShortAnimationTime = (long)swipeListView.getContext().getResources().getInteger(0x10E0000);
        this.swipeListView = swipeListView;
    }

    private void setParentView(View parentView) {
        this.parentView = parentView;
    }

    public void setLayoutManager(LinearLayoutManager layoutManager) {
        this.mLayoutManager = layoutManager;
    }

    private void setFrontView(View frontView, final int childPosition) {
        this.frontView = frontView;
        frontView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SwipeListViewTouchListener.this.swipeListView.onClickFrontView(SwipeListViewTouchListener.this.downPosition);
            }
        });
        frontView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (SwipeListViewTouchListener.this.swipeOpenOnLongPress) {
                    if (SwipeListViewTouchListener.this.downPosition >= 0) {
                        SwipeListViewTouchListener.this.openAnimate(childPosition);
                    }
                } else {
                    SwipeListViewTouchListener.this.swapChoiceState(childPosition);
                }
                return false;
            }
        });
    }

    private void setBackView(View backView) {
        this.backView = backView;
        backView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SwipeListViewTouchListener.this.swipeListView.onClickBackView(SwipeListViewTouchListener.this.downPosition);
            }
        });
    }

    public void setOnlyOneOpenedWhenSwipe(boolean onlyOneOpenedWhenSwipe) {
        this.onlyOneOpenedWhenSwipe = onlyOneOpenedWhenSwipe;
    }

    public boolean isListViewMoving() {
        return this.listViewMoving;
    }

    public void setAnimationTime(long animationTime) {
        this.animationTime = animationTime > 0L ? animationTime : this.configShortAnimationTime;
    }

    public void setRightOffset(float rightOffset) {
        this.rightOffset = rightOffset;
    }

    public void setLeftOffset(float leftOffset) {
        this.leftOffset = leftOffset;
    }

    public void setSwipeClosesAllItemsWhenListMoves(boolean swipeClosesAllItemsWhenListMoves) {
        this.swipeClosesAllItemsWhenListMoves = swipeClosesAllItemsWhenListMoves;
    }

    public void setSwipeOpenOnLongPress(boolean swipeOpenOnLongPress) {
        this.swipeOpenOnLongPress = swipeOpenOnLongPress;
    }

    public void setSwipeMode(int swipeMode) {
        this.swipeMode = swipeMode;
    }

    protected boolean isSwipeEnabled() {
        return this.swipeMode != 0;
    }

    public int getSwipeActionLeft() {
        return this.swipeActionLeft;
    }

    public void setSwipeActionLeft(int swipeActionLeft) {
        this.swipeActionLeft = swipeActionLeft;
    }

    public int getSwipeActionRight() {
        return this.swipeActionRight;
    }

    public void setSwipeActionRight(int swipeActionRight) {
        this.swipeActionRight = swipeActionRight;
    }

    protected void setSwipeDrawableChecked(int swipeDrawableChecked) {
        this.swipeDrawableChecked = swipeDrawableChecked;
    }

    protected void setSwipeDrawableUnchecked(int swipeDrawableUnchecked) {
        this.swipeDrawableUnchecked = swipeDrawableUnchecked;
    }

    public void resetItems() {
        if (this.swipeListView.getAdapter() != null) {
            int count = this.swipeListView.getAdapter().getItemCount();
            for (int i = this.opened.size(); i <= count; ++i) {
                this.opened.add(false);
                this.openedRight.add(false);
                this.checked.add(false);
            }
        }
    }

    protected void openAnimate(int position) {
        View child2 = this.swipeListView.getChildAt(position - this.mLayoutManager.findFirstVisibleItemPosition()).findViewById(this.swipeFrontView);
        if (child2 != null) {
            this.openAnimate(child2, position);
        }
    }

    protected void closeAnimate(int position) {
        View child2;
        int firstVisibleChildPosition;
        View childContainer;
        if (this.swipeListView != null && (childContainer = this.swipeListView.getChildAt(position - (firstVisibleChildPosition = this.mLayoutManager.findFirstVisibleItemPosition()))) != null && (child2 = childContainer.findViewById(this.swipeFrontView)) != null) {
            this.closeAnimate(child2, position);
        }
    }

    private void swapChoiceState(int position) {
        int count;
        int lastCount = this.getCountSelected();
        boolean lastChecked = this.checked.get(position);
        this.checked.set(position, !lastChecked);
        int n = count = lastChecked ? lastCount - 1 : lastCount + 1;
        if (lastCount == 0 && count == 1) {
            this.swipeListView.onChoiceStarted();
            this.closeOpenedItems();
            this.setActionsTo(2);
        }
        if (lastCount == 1 && count == 0) {
            this.swipeListView.onChoiceEnded();
            this.returnOldActions();
        }
        this.swipeListView.onChoiceChanged(position, !lastChecked);
        this.reloadChoiceStateInView(this.frontView, position);
    }

    protected void unselectedChoiceStates() {
        int start = this.mLayoutManager.findFirstVisibleItemPosition();
        int end = this.mLayoutManager.findLastVisibleItemPosition();
        for (int i = 0; i < this.checked.size(); ++i) {
            if (this.checked.get(i).booleanValue() && i >= start && i <= end) {
                this.reloadChoiceStateInView(this.swipeListView.getChildAt(i - start).findViewById(this.swipeFrontView), i);
            }
            this.checked.set(i, false);
        }
        this.swipeListView.onChoiceEnded();
        this.returnOldActions();
    }

    protected int dismiss(int position) {
        this.opened.remove(position);
        this.checked.remove(position);
        int start = this.mLayoutManager.findFirstVisibleItemPosition();
        int end = this.mLayoutManager.findLastVisibleItemPosition();
        View view = this.swipeListView.getChildAt(position - start);
        ++this.dismissAnimationRefCount;
        if (position >= start && position <= end) {
            this.performDismiss(view, position, false);
            return view.getHeight();
        }
        this.pendingDismisses.add(new PendingDismissData(position, null));
        return 0;
    }

    protected void reloadChoiceStateInView(View frontView, int position) {
        if (this.isChecked(position)) {
            if (this.swipeDrawableChecked > 0) {
                frontView.setBackgroundResource(this.swipeDrawableChecked);
            }
        } else if (this.swipeDrawableUnchecked > 0) {
            frontView.setBackgroundResource(this.swipeDrawableUnchecked);
        }
    }

    protected void reloadSwipeStateInView(View frontView, int position) {
        if (!this.opened.get(position).booleanValue()) {
            ViewHelper.setTranslationX((View)frontView, (float)0.0f);
        } else if (this.openedRight.get(position).booleanValue()) {
            ViewHelper.setTranslationX((View)frontView, (float)this.swipeListView.getWidth());
        } else {
            ViewHelper.setTranslationX((View)frontView, (float)(-this.swipeListView.getWidth()));
        }
    }

    protected boolean isChecked(int position) {
        return position < this.checked.size() && this.checked.get(position) != false;
    }

    protected int getCountSelected() {
        int count = 0;
        for (int i = 0; i < this.checked.size(); ++i) {
            if (!this.checked.get(i).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    protected List<Integer> getPositionsSelected() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.checked.size(); ++i) {
            if (!this.checked.get(i).booleanValue()) continue;
            list.add(i);
        }
        return list;
    }

    private void openAnimate(View view, int position) {
        if (!this.opened.get(position).booleanValue()) {
            this.generateRevealAnimate(view, true, false, position);
        }
    }

    private void closeAnimate(View view, int position) {
        if (this.opened.get(position).booleanValue()) {
            this.generateRevealAnimate(view, true, false, position);
        }
    }

    private void generateAnimate(View view, boolean swap, boolean swapRight, int position) {
        if (this.swipeCurrentAction == 0) {
            this.generateRevealAnimate(view, swap, swapRight, position);
        }
        if (this.swipeCurrentAction == 1) {
            this.generateDismissAnimate(this.parentView, swap, swapRight, position);
        }
        if (this.swipeCurrentAction == 2) {
            this.generateChoiceAnimate(view, position);
        }
    }

    private void generateChoiceAnimate(View view, int position) {
        ViewPropertyAnimator.animate((View)view).translationX(0.0f).setDuration(this.animationTime).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                SwipeListViewTouchListener.this.swipeListView.resetScrolling();
                SwipeListViewTouchListener.this.resetCell();
            }
        });
    }

    private void generateDismissAnimate(final View view, final boolean swap, boolean swapRight, final int position) {
        int moveTo = 0;
        if (this.opened.get(position).booleanValue()) {
            if (!swap) {
                moveTo = this.openedRight.get(position) != false ? (int)((float)this.viewWidth - this.rightOffset) : (int)((float)(-this.viewWidth) + this.leftOffset);
            }
        } else if (swap) {
            moveTo = swapRight ? (int)((float)this.viewWidth - this.rightOffset) : (int)((float)(-this.viewWidth) + this.leftOffset);
        }
        boolean alpha = true;
        if (swap) {
            ++this.dismissAnimationRefCount;
            alpha = false;
        }
        ViewPropertyAnimator.animate((View)view).translationX((float)moveTo).alpha((float)alpha).setDuration(this.animationTime).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (swap) {
                    SwipeListViewTouchListener.this.closeOpenedItems();
                    SwipeListViewTouchListener.this.performDismiss(view, position, true);
                }
                SwipeListViewTouchListener.this.resetCell();
            }
        });
    }

    private void generateRevealAnimate(View view, final boolean swap, final boolean swapRight, final int position) {
        boolean aux;
        int moveTo = 0;
        if (this.opened.get(position).booleanValue()) {
            if (!swap) {
                moveTo = this.openedRight.get(position) != false ? (int)((float)this.viewWidth - this.rightOffset) : (int)((float)(-this.viewWidth) + this.leftOffset);
            }
        } else if (swap) {
            moveTo = swapRight ? (int)((float)this.viewWidth - this.rightOffset) : (int)((float)(-this.viewWidth) + this.leftOffset);
        }
        boolean bl = aux = this.opened.get(position) == false;
        if (this.onlyOneOpenedWhenSwipe && swap) {
            this.opened.set(position, aux);
            this.openedRight.set(position, swapRight);
        }
        ViewPropertyAnimator.animate((View)view).translationX((float)moveTo).setDuration(this.animationTime).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                SwipeListViewTouchListener.this.swipeListView.resetScrolling();
                if (swap) {
                    if (SwipeListViewTouchListener.this.onlyOneOpenedWhenSwipe) {
                        if (aux) {
                            SwipeListViewTouchListener.this.swipeListView.onOpened(position, swapRight);
                        } else {
                            SwipeListViewTouchListener.this.swipeListView.onClosed(position, (Boolean)SwipeListViewTouchListener.this.openedRight.get(position));
                        }
                    }
                    SwipeListViewTouchListener.this.opened.set(position, aux);
                    if (aux) {
                        SwipeListViewTouchListener.this.swipeListView.onOpened(position, swapRight);
                        SwipeListViewTouchListener.this.openedRight.set(position, swapRight);
                    } else {
                        SwipeListViewTouchListener.this.swipeListView.onClosed(position, (Boolean)SwipeListViewTouchListener.this.openedRight.get(position));
                    }
                }
                if (!SwipeListViewTouchListener.this.onlyOneOpenedWhenSwipe) {
                    SwipeListViewTouchListener.this.resetCell();
                }
            }
        });
    }

    private void resetCell() {
        if (this.downPosition != -1) {
            if (this.swipeCurrentAction == 2) {
                this.backView.setVisibility(0);
            }
            this.frontView.setClickable(this.opened.get(this.downPosition).booleanValue());
            this.frontView.setLongClickable(this.opened.get(this.downPosition).booleanValue());
            this.frontView = null;
            this.backView = null;
            this.downPosition = -1;
        }
    }

    public void setEnabled(boolean enabled) {
        this.paused = !enabled;
    }

    public RecyclerView.OnScrollListener makeScrollListener() {
        return new RecyclerView.OnScrollListener(){
            private boolean isFirstItem = false;
            private boolean isLastItem = false;

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                SwipeListViewTouchListener.this.setEnabled(newState != 1);
                if (SwipeListViewTouchListener.this.swipeClosesAllItemsWhenListMoves) {
                    if (newState == 1) {
                        SwipeListViewTouchListener.this.closeOpenedItems();
                    }
                }
                if (newState == 1) {
                    SwipeListViewTouchListener.this.listViewMoving = true;
                    SwipeListViewTouchListener.this.setEnabled(false);
                }
                if (newState != 2) {
                    if (newState != 1) {
                        SwipeListViewTouchListener.this.listViewMoving = false;
                        SwipeListViewTouchListener.this.downPosition = -1;
                        SwipeListViewTouchListener.this.swipeListView.resetScrolling();
                        new Handler().postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                SwipeListViewTouchListener.this.setEnabled(true);
                            }
                        }, 500L);
                    }
                }
            }

            public void onScrolled(RecyclerView view, int dx, int dy) {
            }
        };
    }

    void closeOpenedItems() {
        if (this.opened != null) {
            int start = this.mLayoutManager.findFirstVisibleItemPosition();
            int end = this.mLayoutManager.findLastVisibleItemPosition();
            for (int i = start; i <= end; ++i) {
                if (!this.opened.get(i).booleanValue()) continue;
                this.closeAnimate(this.swipeListView.getChildAt(i - start).findViewById(this.swipeFrontView), i);
            }
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        if (!this.isSwipeEnabled()) {
            return false;
        }
        if (this.viewWidth < 2) {
            this.viewWidth = this.swipeListView.getWidth();
        }
        switch (MotionEventCompat.getActionMasked((MotionEvent)motionEvent)) {
            case 0: {
                if (this.paused && this.downPosition != -1) {
                    return false;
                }
                this.swipeCurrentAction = 3;
                int childCount = this.swipeListView.getChildCount();
                int[] listViewCoords = new int[2];
                this.swipeListView.getLocationOnScreen(listViewCoords);
                int x = (int)motionEvent.getRawX() - listViewCoords[0];
                int y = (int)motionEvent.getRawY() - listViewCoords[1];
                for (int i = 0; i < childCount; ++i) {
                    View child2 = this.swipeListView.getChildAt(i);
                    child2.getHitRect(this.rect);
                    int childPosition = this.swipeListView.getChildPosition(child2);
                    boolean allowSwipe = true;
                    if (!allowSwipe || !this.rect.contains(x, y)) continue;
                    this.setParentView(child2);
                    this.setFrontView(child2.findViewById(this.swipeFrontView), childPosition);
                    this.downX = motionEvent.getRawX();
                    this.downPosition = childPosition;
                    this.frontView.setClickable(this.opened.get(this.downPosition) == false);
                    this.frontView.setLongClickable(this.opened.get(this.downPosition) == false);
                    this.velocityTracker = VelocityTracker.obtain();
                    this.velocityTracker.addMovement(motionEvent);
                    if (this.swipeBackView <= 0) break;
                    this.setBackView(child2.findViewById(this.swipeBackView));
                    break;
                }
                view.onTouchEvent(motionEvent);
                return true;
            }
            case 1: {
                if (this.velocityTracker == null || !this.swiping || this.downPosition == -1) break;
                float deltaX = motionEvent.getRawX() - this.downX;
                this.velocityTracker.addMovement(motionEvent);
                this.velocityTracker.computeCurrentVelocity(1000);
                float velocityX = Math.abs(this.velocityTracker.getXVelocity());
                if (!this.opened.get(this.downPosition).booleanValue()) {
                    if (this.swipeMode == 3 && this.velocityTracker.getXVelocity() > 0.0f) {
                        velocityX = 0.0f;
                    }
                    if (this.swipeMode == 2 && this.velocityTracker.getXVelocity() < 0.0f) {
                        velocityX = 0.0f;
                    }
                }
                float velocityY = Math.abs(this.velocityTracker.getYVelocity());
                boolean swap = false;
                boolean swapRight = false;
                if ((float)this.minFlingVelocity <= velocityX && velocityX <= (float)this.maxFlingVelocity && velocityY * 2.0f < velocityX) {
                    boolean bl = swapRight = this.velocityTracker.getXVelocity() > 0.0f;
                    swap = swapRight != this.swipingRight && this.swipeActionLeft != this.swipeActionRight ? false : (this.opened.get(this.downPosition).booleanValue() && this.openedRight.get(this.downPosition).booleanValue() && swapRight ? false : !this.opened.get(this.downPosition).booleanValue() || this.openedRight.get(this.downPosition).booleanValue() || swapRight);
                } else if (Math.abs(deltaX) > (float)(this.viewWidth / 2)) {
                    swap = true;
                    swapRight = deltaX > 0.0f;
                }
                this.generateAnimate(this.frontView, swap, swapRight, this.downPosition);
                if (this.swipeCurrentAction == 2) {
                    this.swapChoiceState(this.downPosition);
                }
                this.velocityTracker.recycle();
                this.velocityTracker = null;
                this.downX = 0.0f;
                this.swiping = false;
                break;
            }
            case 2: {
                if (this.velocityTracker == null || this.paused || this.downPosition == -1) break;
                this.velocityTracker.addMovement(motionEvent);
                this.velocityTracker.computeCurrentVelocity(1000);
                float velocityX = Math.abs(this.velocityTracker.getXVelocity());
                float velocityY = Math.abs(this.velocityTracker.getYVelocity());
                float deltaX = motionEvent.getRawX() - this.downX;
                float deltaMode = Math.abs(deltaX);
                int swipeMode = this.swipeMode;
                int changeSwipeMode = this.swipeListView.changeSwipeMode(this.downPosition);
                if (changeSwipeMode >= 0) {
                    swipeMode = changeSwipeMode;
                }
                if (swipeMode == 0) {
                    deltaMode = 0.0f;
                } else if (swipeMode != 1) {
                    if (this.opened.get(this.downPosition).booleanValue()) {
                        if (swipeMode == 3 && deltaX < 0.0f) {
                            deltaMode = 0.0f;
                        } else if (swipeMode == 2 && deltaX > 0.0f) {
                            deltaMode = 0.0f;
                        }
                    } else if (swipeMode == 3 && deltaX > 0.0f) {
                        deltaMode = 0.0f;
                    } else if (swipeMode == 2 && deltaX < 0.0f) {
                        deltaMode = 0.0f;
                    }
                }
                if (deltaMode > (float)this.slop && this.swipeCurrentAction == 3 && velocityY < velocityX) {
                    this.swiping = true;
                    boolean bl = this.swipingRight = deltaX > 0.0f;
                    if (this.opened.get(this.downPosition).booleanValue()) {
                        this.swipeListView.onStartClose(this.downPosition, this.swipingRight);
                        this.swipeCurrentAction = 0;
                    } else {
                        this.swipeCurrentAction = this.swipingRight && this.swipeActionRight == 1 ? 1 : (!this.swipingRight && this.swipeActionLeft == 1 ? 1 : (this.swipingRight && this.swipeActionRight == 2 ? 2 : (!this.swipingRight && this.swipeActionLeft == 2 ? 2 : 0)));
                        this.swipeListView.onStartOpen(this.downPosition, this.swipeCurrentAction, this.swipingRight);
                    }
                    this.swipeListView.requestDisallowInterceptTouchEvent(true);
                    MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)motionEvent);
                    cancelEvent.setAction(3 | MotionEventCompat.getActionIndex((MotionEvent)motionEvent) << 8);
                    this.swipeListView.onTouchEvent(cancelEvent);
                    if (this.swipeCurrentAction == 2) {
                        this.backView.setVisibility(8);
                    }
                }
                if (!this.swiping || this.downPosition == -1) break;
                if (this.opened.get(this.downPosition).booleanValue()) {
                    deltaX += this.openedRight.get(this.downPosition) != false ? (float)this.viewWidth - this.rightOffset : (float)(-this.viewWidth) + this.leftOffset;
                }
                this.move(deltaX);
                return true;
            }
        }
        if (this.onlyOneOpenedWhenSwipe) {
            this.closeOtherOpenedItems();
            view.onTouchEvent(motionEvent);
            return true;
        }
        return false;
    }

    private void closeOtherOpenedItems() {
        if (this.opened != null && this.downPosition != -1) {
            int start = this.mLayoutManager.findFirstVisibleItemPosition();
            int end = this.mLayoutManager.findLastVisibleItemPosition();
            for (int i = start; i <= end; ++i) {
                if (!this.opened.get(i).booleanValue() || i == this.downPosition) continue;
                this.closeAnimate(this.swipeListView.getChildAt(i - start).findViewById(this.swipeFrontView), i);
            }
        }
    }

    private void setActionsTo(int action) {
        this.oldSwipeActionRight = this.swipeActionRight;
        this.oldSwipeActionLeft = this.swipeActionLeft;
        this.swipeActionRight = action;
        this.swipeActionLeft = action;
    }

    protected void returnOldActions() {
        this.swipeActionRight = this.oldSwipeActionRight;
        this.swipeActionLeft = this.oldSwipeActionLeft;
    }

    public void move(float deltaX) {
        this.swipeListView.onMove(this.downPosition, deltaX);
        float posX = ViewHelper.getX((View)this.frontView);
        if (this.opened.get(this.downPosition).booleanValue()) {
            posX += this.openedRight.get(this.downPosition) != false ? (float)(-this.viewWidth) + this.rightOffset : (float)this.viewWidth - this.leftOffset;
        }
        if (posX > 0.0f && !this.swipingRight) {
            this.swipingRight = !this.swipingRight;
            this.swipeCurrentAction = this.swipeActionRight;
            if (this.swipeCurrentAction == 2) {
                this.backView.setVisibility(8);
            } else {
                this.backView.setVisibility(0);
            }
        }
        if (posX < 0.0f && this.swipingRight) {
            this.swipingRight = !this.swipingRight;
            this.swipeCurrentAction = this.swipeActionLeft;
            if (this.swipeCurrentAction == 2) {
                this.backView.setVisibility(8);
            } else {
                this.backView.setVisibility(0);
            }
        }
        if (this.swipeCurrentAction == 1) {
            ViewHelper.setTranslationX((View)this.parentView, (float)deltaX);
            ViewHelper.setAlpha((View)this.parentView, (float)Math.max(0.0f, Math.min(1.0f, 1.0f - 2.0f * Math.abs(deltaX) / (float)this.viewWidth)));
        } else if (this.swipeCurrentAction == 2) {
            if (this.swipingRight && deltaX > 0.0f && posX < 80.0f || !this.swipingRight && deltaX < 0.0f && posX > -80.0f || this.swipingRight && deltaX < 80.0f || !this.swipingRight && deltaX > -80.0f) {
                ViewHelper.setTranslationX((View)this.frontView, (float)deltaX);
            }
        } else {
            ViewHelper.setTranslationX((View)this.frontView, (float)deltaX);
        }
    }

    protected void performDismiss(final View dismissView, int dismissPosition, boolean doPendingDismiss) {
        SwipeListViewTouchListener.enableDisableViewGroup((ViewGroup)dismissView, false);
        final ViewGroup.LayoutParams lp = dismissView.getLayoutParams();
        final int originalHeight = dismissView.getHeight();
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{originalHeight, 1}).setDuration(this.animationTime);
        if (doPendingDismiss) {
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    --SwipeListViewTouchListener.this.dismissAnimationRefCount;
                    if (SwipeListViewTouchListener.this.dismissAnimationRefCount == 0) {
                        SwipeListViewTouchListener.this.removePendingDismisses(originalHeight);
                    }
                }
            });
        }
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                SwipeListViewTouchListener.enableDisableViewGroup((ViewGroup)dismissView, true);
            }
        });
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                lp.height = (Integer)valueAnimator.getAnimatedValue();
                dismissView.setLayoutParams(lp);
            }
        });
        this.pendingDismisses.add(new PendingDismissData(dismissPosition, dismissView));
        animator.start();
    }

    protected void resetPendingDismisses() {
        this.pendingDismisses.clear();
    }

    protected void handlerPendingDismisses(final int originalHeight) {
        Handler handler = new Handler();
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                SwipeListViewTouchListener.this.removePendingDismisses(originalHeight);
            }
        }, this.animationTime + 100L);
    }

    private void removePendingDismisses(int originalHeight) {
        Collections.sort(this.pendingDismisses);
        int[] dismissPositions = new int[this.pendingDismisses.size()];
        for (int i = this.pendingDismisses.size() - 1; i >= 0; --i) {
            dismissPositions[i] = this.pendingDismisses.get((int)i).position;
        }
        this.swipeListView.onDismiss(dismissPositions);
        for (PendingDismissData pendingDismiss : this.pendingDismisses) {
            if (pendingDismiss.view == null) continue;
            ViewHelper.setAlpha((View)pendingDismiss.view, (float)1.0f);
            ViewHelper.setTranslationX((View)pendingDismiss.view, (float)0.0f);
            ViewGroup.LayoutParams lp = pendingDismiss.view.getLayoutParams();
            lp.height = originalHeight;
            pendingDismiss.view.setLayoutParams(lp);
        }
        this.resetPendingDismisses();
    }

    public static void enableDisableViewGroup(ViewGroup viewGroup, boolean enabled) {
        int childCount = viewGroup.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view = viewGroup.getChildAt(i);
            view.setEnabled(enabled);
            if (!(view instanceof ViewGroup)) continue;
            SwipeListViewTouchListener.enableDisableViewGroup((ViewGroup)view, enabled);
        }
    }

    class PendingDismissData
    implements Comparable<PendingDismissData> {
        public int position;
        public View view;

        public PendingDismissData(int position, View view) {
            this.position = position;
            this.view = view;
        }

        @Override
        public int compareTo(PendingDismissData other) {
            return other.position - this.position;
        }
    }
}

