/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.swipelistview;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewConfigurationCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import com.marshalchen.ultimaterecyclerview.R;
import com.marshalchen.ultimaterecyclerview.swipelistview.SwipeListViewListener;
import com.marshalchen.ultimaterecyclerview.swipelistview.SwipeListViewTouchListener;
import java.util.List;

public class SwipeListView
extends RecyclerView {
    public static final String TAG = "SwipeListView";
    public static final boolean DEBUG = false;
    public static final int SWIPE_MODE_DEFAULT = -1;
    public static final int SWIPE_MODE_NONE = 0;
    public static final int SWIPE_MODE_BOTH = 1;
    public static final int SWIPE_MODE_RIGHT = 2;
    public static final int SWIPE_MODE_LEFT = 3;
    public static final int SWIPE_ACTION_REVEAL = 0;
    public static final int SWIPE_ACTION_DISMISS = 1;
    public static final int SWIPE_ACTION_CHOICE = 2;
    public static final int SWIPE_ACTION_NONE = 3;
    public static final String SWIPE_DEFAULT_FRONT_VIEW = "swipelist_frontview";
    public static final String SWIPE_DEFAULT_BACK_VIEW = "swipelist_backview";
    private static final int TOUCH_STATE_REST = 0;
    private static final int TOUCH_STATE_SCROLLING_X = 1;
    private static final int TOUCH_STATE_SCROLLING_Y = 2;
    private int touchState = 0;
    private float lastMotionX;
    private float lastMotionY;
    private int touchSlop;
    int swipeFrontView = 0;
    int swipeBackView = 0;
    private LinearLayoutManager mLayoutManager;
    public SwipeListViewListener swipeListViewListener;
    private SwipeListViewTouchListener touchListener;

    public SwipeListView(Context context, int swipeBackView, int swipeFrontView) {
        super(context);
        this.swipeFrontView = swipeFrontView;
        this.swipeBackView = swipeBackView;
    }

    public SwipeListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SwipeListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void init(AttributeSet attrs) {
        int swipeMode = 1;
        boolean swipeOpenOnLongPress = true;
        boolean swipeCloseAllItemsWhenMoveList = true;
        boolean onlyOneOpenedWhenSwipe = false;
        long swipeAnimationTime = 0L;
        float swipeOffsetLeft = 0.0f;
        float swipeOffsetRight = 0.0f;
        int swipeDrawableChecked = 0;
        int swipeDrawableUnchecked = 0;
        int swipeActionLeft = 0;
        int swipeActionRight = 0;
        if (attrs != null) {
            TypedArray styled = this.getContext().obtainStyledAttributes(attrs, R.styleable.SwipeListView);
            swipeMode = styled.getInt(R.styleable.SwipeListView_swipeMode, 1);
            swipeActionLeft = styled.getInt(R.styleable.SwipeListView_swipeActionLeft, 0);
            swipeActionRight = styled.getInt(R.styleable.SwipeListView_swipeActionRight, 0);
            onlyOneOpenedWhenSwipe = styled.getBoolean(R.styleable.SwipeListView_onlyOneOpenedWhenSwipe, false);
            swipeOffsetLeft = styled.getDimension(R.styleable.SwipeListView_swipeOffsetLeft, 0.0f);
            swipeOffsetRight = styled.getDimension(R.styleable.SwipeListView_swipeOffsetRight, 0.0f);
            swipeOpenOnLongPress = styled.getBoolean(R.styleable.SwipeListView_swipeOpenOnLongPress, true);
            swipeAnimationTime = styled.getInteger(R.styleable.SwipeListView_swipeAnimationTime, 0);
            swipeCloseAllItemsWhenMoveList = styled.getBoolean(R.styleable.SwipeListView_swipeCloseAllItemsWhenMoveList, true);
            swipeDrawableChecked = styled.getResourceId(R.styleable.SwipeListView_swipeDrawableChecked, 0);
            swipeDrawableUnchecked = styled.getResourceId(R.styleable.SwipeListView_swipeDrawableUnchecked, 0);
            this.swipeFrontView = styled.getResourceId(R.styleable.SwipeListView_swipeFrontView, 0);
            this.swipeBackView = styled.getResourceId(R.styleable.SwipeListView_swipeBackView, 0);
            styled.recycle();
        }
        if (this.swipeFrontView == 0 || this.swipeBackView == 0) {
            this.swipeFrontView = this.getContext().getResources().getIdentifier(SWIPE_DEFAULT_FRONT_VIEW, "id", this.getContext().getPackageName());
            this.swipeBackView = this.getContext().getResources().getIdentifier(SWIPE_DEFAULT_BACK_VIEW, "id", this.getContext().getPackageName());
            if (this.swipeFrontView == 0 || this.swipeBackView == 0) {
                throw new RuntimeException(String.format("You forgot the attributes swipeFrontView or swipeBackView. You can add this attributes or use '%s' and '%s' identifiers", SWIPE_DEFAULT_FRONT_VIEW, SWIPE_DEFAULT_BACK_VIEW));
            }
        }
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
        this.touchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop((ViewConfiguration)configuration);
        this.touchListener = new SwipeListViewTouchListener(this, this.swipeFrontView, this.swipeBackView);
        if (swipeAnimationTime > 0L) {
            this.touchListener.setAnimationTime(swipeAnimationTime);
        }
        this.touchListener.setRightOffset(swipeOffsetRight);
        this.touchListener.setLeftOffset(swipeOffsetLeft);
        this.touchListener.setSwipeActionLeft(swipeActionLeft);
        this.touchListener.setSwipeActionRight(swipeActionRight);
        this.touchListener.setSwipeMode(swipeMode);
        this.touchListener.setOnlyOneOpenedWhenSwipe(onlyOneOpenedWhenSwipe);
        this.touchListener.setSwipeClosesAllItemsWhenListMoves(swipeCloseAllItemsWhenMoveList);
        this.touchListener.setSwipeOpenOnLongPress(swipeOpenOnLongPress);
        this.touchListener.setSwipeDrawableChecked(swipeDrawableChecked);
        this.touchListener.setSwipeDrawableUnchecked(swipeDrawableUnchecked);
        this.setOnTouchListener(this.touchListener);
        this.setOnScrollListener(this.touchListener.makeScrollListener());
    }

    public void recycle(View convertView, int position) {
        this.touchListener.reloadChoiceStateInView(convertView.findViewById(this.swipeFrontView), position);
        this.touchListener.reloadSwipeStateInView(convertView.findViewById(this.swipeFrontView), position);
        for (int j = 0; j < ((ViewGroup)convertView).getChildCount(); ++j) {
            View nextChild = ((ViewGroup)convertView).getChildAt(j);
            nextChild.setPressed(false);
        }
    }

    public boolean isChecked(int position) {
        return this.touchListener.isChecked(position);
    }

    public List<Integer> getPositionsSelected() {
        return this.touchListener.getPositionsSelected();
    }

    public int getCountSelected() {
        return this.touchListener.getCountSelected();
    }

    public void unselectedChoiceStates() {
        this.touchListener.unselectedChoiceStates();
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        super.setAdapter(adapter);
        this.touchListener.resetItems();
        adapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onChanged() {
                super.onChanged();
                SwipeListView.this.onListChanged();
                SwipeListView.this.touchListener.resetItems();
            }
        });
    }

    public void setLayoutManager(RecyclerView.LayoutManager layoutManager) {
        super.setLayoutManager(layoutManager);
        this.mLayoutManager = (LinearLayoutManager)layoutManager;
        if (this.touchListener != null) {
            this.touchListener.setLayoutManager(this.mLayoutManager);
        }
    }

    public void dismiss(int position) {
        int height = this.touchListener.dismiss(position);
        if (height > 0) {
            this.touchListener.handlerPendingDismisses(height);
        } else {
            int[] dismissPositions = new int[]{position};
            this.onDismiss(dismissPositions);
            this.touchListener.resetPendingDismisses();
        }
    }

    public void dismissSelected() {
        List<Integer> list = this.touchListener.getPositionsSelected();
        int[] dismissPositions = new int[list.size()];
        int height = 0;
        for (int i = 0; i < list.size(); ++i) {
            int position;
            dismissPositions[i] = position = list.get(i).intValue();
            int auxHeight = this.touchListener.dismiss(position);
            if (auxHeight <= 0) continue;
            height = auxHeight;
        }
        if (height > 0) {
            this.touchListener.handlerPendingDismisses(height);
        } else {
            this.onDismiss(dismissPositions);
            this.touchListener.resetPendingDismisses();
        }
        this.touchListener.returnOldActions();
    }

    public void openAnimate(int position) {
        this.touchListener.openAnimate(position);
    }

    public void closeAnimate(int position) {
        this.touchListener.closeAnimate(position);
    }

    protected void onDismiss(int[] reverseSortedPositions) {
        if (this.swipeListViewListener != null) {
            this.swipeListViewListener.onDismiss(reverseSortedPositions);
        }
    }

    protected void onStartOpen(int position, int action, boolean right) {
        if (this.swipeListViewListener != null && position != -1) {
            this.swipeListViewListener.onStartOpen(position, action, right);
        }
    }

    protected void onStartClose(int position, boolean right) {
        if (this.swipeListViewListener != null && position != -1) {
            this.swipeListViewListener.onStartClose(position, right);
        }
    }

    protected void onClickFrontView(int position) {
        if (this.swipeListViewListener != null && position != -1) {
            this.swipeListViewListener.onClickFrontView(position);
        }
    }

    protected void onClickBackView(int position) {
        if (this.swipeListViewListener != null && position != -1) {
            this.swipeListViewListener.onClickBackView(position);
        }
    }

    protected void onOpened(int position, boolean toRight) {
        if (this.swipeListViewListener != null && position != -1) {
            this.swipeListViewListener.onOpened(position, toRight);
        }
    }

    protected void onClosed(int position, boolean fromRight) {
        if (this.swipeListViewListener != null && position != -1) {
            this.swipeListViewListener.onClosed(position, fromRight);
        }
    }

    protected void onChoiceChanged(int position, boolean selected) {
        if (this.swipeListViewListener != null && position != -1) {
            this.swipeListViewListener.onChoiceChanged(position, selected);
        }
    }

    protected void onChoiceStarted() {
        if (this.swipeListViewListener != null) {
            this.swipeListViewListener.onChoiceStarted();
        }
    }

    protected void onChoiceEnded() {
        if (this.swipeListViewListener != null) {
            this.swipeListViewListener.onChoiceEnded();
        }
    }

    protected void onFirstListItem() {
        if (this.swipeListViewListener != null) {
            this.swipeListViewListener.onFirstListItem();
        }
    }

    protected void onLastListItem() {
        if (this.swipeListViewListener != null) {
            this.swipeListViewListener.onLastListItem();
        }
    }

    protected void onListChanged() {
        if (this.swipeListViewListener != null) {
            this.swipeListViewListener.onListChanged();
        }
    }

    protected void onMove(int position, float x) {
        if (this.swipeListViewListener != null && position != -1) {
            this.swipeListViewListener.onMove(position, x);
        }
    }

    protected int changeSwipeMode(int position) {
        if (this.swipeListViewListener != null && position != -1) {
            return this.swipeListViewListener.onChangeSwipeMode(position);
        }
        return -1;
    }

    public void setSwipeListViewListener(SwipeListViewListener swipeListViewListener) {
        this.swipeListViewListener = swipeListViewListener;
    }

    public void resetScrolling() {
        this.touchState = 0;
    }

    public void setOffsetRight(float offsetRight) {
        this.touchListener.setRightOffset(offsetRight);
    }

    public void setOffsetLeft(float offsetLeft) {
        this.touchListener.setLeftOffset(offsetLeft);
    }

    public void setOnlyOneOpenedWhenSwipe(boolean onlyOneOpenedWhenSwipe) {
        this.touchListener.setOnlyOneOpenedWhenSwipe(onlyOneOpenedWhenSwipe);
    }

    public void setSwipeCloseAllItemsWhenMoveList(boolean swipeCloseAllItemsWhenMoveList) {
        this.touchListener.setSwipeClosesAllItemsWhenListMoves(swipeCloseAllItemsWhenMoveList);
    }

    public void setSwipeOpenOnLongPress(boolean swipeOpenOnLongPress) {
        this.touchListener.setSwipeOpenOnLongPress(swipeOpenOnLongPress);
    }

    public void setSwipeMode(int swipeMode) {
        this.touchListener.setSwipeMode(swipeMode);
    }

    public int getSwipeActionLeft() {
        return this.touchListener.getSwipeActionLeft();
    }

    public void setSwipeActionLeft(int swipeActionLeft) {
        this.touchListener.setSwipeActionLeft(swipeActionLeft);
    }

    public int getSwipeActionRight() {
        return this.touchListener.getSwipeActionRight();
    }

    public void setSwipeActionRight(int swipeActionRight) {
        this.touchListener.setSwipeActionRight(swipeActionRight);
    }

    public void setAnimationTime(long animationTime) {
        this.touchListener.setAnimationTime(animationTime);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        float x = ev.getX();
        float y = ev.getY();
        if (this.isEnabled() && this.touchListener.isSwipeEnabled()) {
            if (this.touchState == 1) {
                return this.touchListener.onTouch((View)this, ev);
            }
            switch (action) {
                case 2: {
                    this.checkInMoving(x, y);
                    return this.touchState == 2;
                }
                case 0: {
                    super.onInterceptTouchEvent(ev);
                    this.touchListener.onTouch((View)this, ev);
                    this.touchState = 0;
                    this.lastMotionX = x;
                    this.lastMotionY = y;
                    return false;
                }
                case 3: {
                    this.touchState = 0;
                    break;
                }
                case 1: {
                    this.touchListener.onTouch((View)this, ev);
                    return this.touchState == 2;
                }
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    private void checkInMoving(float x, float y) {
        boolean yMoved;
        int xDiff = (int)Math.abs(x - this.lastMotionX);
        int yDiff = (int)Math.abs(y - this.lastMotionY);
        int touchSlop = this.touchSlop;
        boolean xMoved = xDiff > touchSlop;
        boolean bl = yMoved = yDiff > touchSlop;
        if (xMoved) {
            this.touchState = 1;
            this.lastMotionX = x;
            this.lastMotionY = y;
        }
        if (yMoved) {
            this.touchState = 2;
            this.lastMotionX = x;
            this.lastMotionY = y;
        }
    }

    public void closeOpenedItems() {
        this.touchListener.closeOpenedItems();
    }
}

