/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.swipe;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.support.v4.view.GravityCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import com.marshalchen.ultimaterecyclerview.R;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SwipeLayout
extends FrameLayout {
    @Deprecated
    public static final int EMPTY_LAYOUT = -1;
    private static final int DRAG_LEFT = 1;
    private static final int DRAG_RIGHT = 2;
    private static final int DRAG_TOP = 4;
    private static final int DRAG_BOTTOM = 8;
    private static final DragEdge DefaultDragEdge = DragEdge.Right;
    private int mTouchSlop;
    private DragEdge mCurrentDragEdge = DefaultDragEdge;
    private ViewDragHelper mDragHelper;
    private int mDragDistance = 0;
    private LinkedHashMap<DragEdge, View> mDragEdges = new LinkedHashMap();
    private ShowMode mShowMode;
    private float[] mEdgeSwipesOffset = new float[4];
    private List<SwipeListener> mSwipeListeners = new ArrayList<SwipeListener>();
    private List<SwipeDenier> mSwipeDeniers = new ArrayList<SwipeDenier>();
    private Map<View, ArrayList<OnRevealListener>> mRevealListeners = new HashMap<View, ArrayList<OnRevealListener>>();
    private Map<View, Boolean> mShowEntirely = new HashMap<View, Boolean>();
    private DoubleClickListener mDoubleClickListener;
    private boolean mSwipeEnabled = true;
    private boolean[] mSwipesEnabled = new boolean[]{true, true, true, true};
    private boolean mClickToClose = false;
    private ViewDragHelper.Callback mDragHelperCallback = new ViewDragHelper.Callback(){
        boolean isCloseBeforeDrag = true;

        public int clampViewPositionHorizontal(View child2, int left, int dx) {
            if (child2 == SwipeLayout.this.getSurfaceView()) {
                switch (SwipeLayout.this.mCurrentDragEdge) {
                    case Top: 
                    case Bottom: {
                        return SwipeLayout.this.getPaddingLeft();
                    }
                    case Left: {
                        if (left < SwipeLayout.this.getPaddingLeft()) {
                            return SwipeLayout.this.getPaddingLeft();
                        }
                        if (left <= SwipeLayout.this.getPaddingLeft() + SwipeLayout.this.mDragDistance) break;
                        return SwipeLayout.this.getPaddingLeft() + SwipeLayout.this.mDragDistance;
                    }
                    case Right: {
                        if (left > SwipeLayout.this.getPaddingLeft()) {
                            return SwipeLayout.this.getPaddingLeft();
                        }
                        if (left >= SwipeLayout.this.getPaddingLeft() - SwipeLayout.this.mDragDistance) break;
                        return SwipeLayout.this.getPaddingLeft() - SwipeLayout.this.mDragDistance;
                    }
                }
            } else if (SwipeLayout.this.getCurrentBottomView() == child2) {
                switch (SwipeLayout.this.mCurrentDragEdge) {
                    case Top: 
                    case Bottom: {
                        return SwipeLayout.this.getPaddingLeft();
                    }
                    case Left: {
                        if (SwipeLayout.this.mShowMode != ShowMode.PullOut || left <= SwipeLayout.this.getPaddingLeft()) break;
                        return SwipeLayout.this.getPaddingLeft();
                    }
                    case Right: {
                        if (SwipeLayout.this.mShowMode != ShowMode.PullOut || left >= SwipeLayout.this.getMeasuredWidth() - SwipeLayout.this.mDragDistance) break;
                        return SwipeLayout.this.getMeasuredWidth() - SwipeLayout.this.mDragDistance;
                    }
                }
            }
            return left;
        }

        public int clampViewPositionVertical(View child2, int top, int dy) {
            if (child2 == SwipeLayout.this.getSurfaceView()) {
                switch (SwipeLayout.this.mCurrentDragEdge) {
                    case Left: 
                    case Right: {
                        return SwipeLayout.this.getPaddingTop();
                    }
                    case Top: {
                        if (top < SwipeLayout.this.getPaddingTop()) {
                            return SwipeLayout.this.getPaddingTop();
                        }
                        if (top <= SwipeLayout.this.getPaddingTop() + SwipeLayout.this.mDragDistance) break;
                        return SwipeLayout.this.getPaddingTop() + SwipeLayout.this.mDragDistance;
                    }
                    case Bottom: {
                        if (top < SwipeLayout.this.getPaddingTop() - SwipeLayout.this.mDragDistance) {
                            return SwipeLayout.this.getPaddingTop() - SwipeLayout.this.mDragDistance;
                        }
                        if (top <= SwipeLayout.this.getPaddingTop()) break;
                        return SwipeLayout.this.getPaddingTop();
                    }
                }
            } else {
                View surfaceView = SwipeLayout.this.getSurfaceView();
                int surfaceViewTop = surfaceView == null ? 0 : surfaceView.getTop();
                switch (SwipeLayout.this.mCurrentDragEdge) {
                    case Left: 
                    case Right: {
                        return SwipeLayout.this.getPaddingTop();
                    }
                    case Top: {
                        if (SwipeLayout.this.mShowMode == ShowMode.PullOut) {
                            if (top <= SwipeLayout.this.getPaddingTop()) break;
                            return SwipeLayout.this.getPaddingTop();
                        }
                        if (surfaceViewTop + dy < SwipeLayout.this.getPaddingTop()) {
                            return SwipeLayout.this.getPaddingTop();
                        }
                        if (surfaceViewTop + dy <= SwipeLayout.this.getPaddingTop() + SwipeLayout.this.mDragDistance) break;
                        return SwipeLayout.this.getPaddingTop() + SwipeLayout.this.mDragDistance;
                    }
                    case Bottom: {
                        if (SwipeLayout.this.mShowMode == ShowMode.PullOut) {
                            if (top >= SwipeLayout.this.getMeasuredHeight() - SwipeLayout.this.mDragDistance) break;
                            return SwipeLayout.this.getMeasuredHeight() - SwipeLayout.this.mDragDistance;
                        }
                        if (surfaceViewTop + dy >= SwipeLayout.this.getPaddingTop()) {
                            return SwipeLayout.this.getPaddingTop();
                        }
                        if (surfaceViewTop + dy > SwipeLayout.this.getPaddingTop() - SwipeLayout.this.mDragDistance) break;
                        return SwipeLayout.this.getPaddingTop() - SwipeLayout.this.mDragDistance;
                    }
                }
            }
            return top;
        }

        public boolean tryCaptureView(View child2, int pointerId) {
            boolean result;
            boolean bl = result = child2 == SwipeLayout.this.getSurfaceView() || SwipeLayout.this.getBottomViews().contains(child2);
            if (result) {
                this.isCloseBeforeDrag = SwipeLayout.this.getOpenStatus() == Status.Close;
            }
            return result;
        }

        public int getViewHorizontalDragRange(View child2) {
            return SwipeLayout.this.mDragDistance;
        }

        public int getViewVerticalDragRange(View child2) {
            return SwipeLayout.this.mDragDistance;
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            super.onViewReleased(releasedChild, xvel, yvel);
            SwipeLayout.this.processHandRelease(xvel, yvel, this.isCloseBeforeDrag);
            for (SwipeListener l : SwipeLayout.this.mSwipeListeners) {
                l.onHandRelease(SwipeLayout.this, xvel, yvel);
            }
            SwipeLayout.this.invalidate();
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            View surfaceView = SwipeLayout.this.getSurfaceView();
            if (surfaceView == null) {
                return;
            }
            View currentBottomView = SwipeLayout.this.getCurrentBottomView();
            int evLeft = surfaceView.getLeft();
            int evRight = surfaceView.getRight();
            int evTop = surfaceView.getTop();
            int evBottom = surfaceView.getBottom();
            if (changedView == surfaceView) {
                if (SwipeLayout.this.mShowMode == ShowMode.PullOut && currentBottomView != null) {
                    if (SwipeLayout.this.mCurrentDragEdge == DragEdge.Left || SwipeLayout.this.mCurrentDragEdge == DragEdge.Right) {
                        currentBottomView.offsetLeftAndRight(dx);
                    } else {
                        currentBottomView.offsetTopAndBottom(dy);
                    }
                }
            } else if (SwipeLayout.this.getBottomViews().contains(changedView)) {
                if (SwipeLayout.this.mShowMode == ShowMode.PullOut) {
                    surfaceView.offsetLeftAndRight(dx);
                    surfaceView.offsetTopAndBottom(dy);
                } else {
                    Rect rect = SwipeLayout.this.computeBottomLayDown(SwipeLayout.this.mCurrentDragEdge);
                    if (currentBottomView != null) {
                        currentBottomView.layout(rect.left, rect.top, rect.right, rect.bottom);
                    }
                    int newLeft = surfaceView.getLeft() + dx;
                    int newTop = surfaceView.getTop() + dy;
                    if (SwipeLayout.this.mCurrentDragEdge == DragEdge.Left && newLeft < SwipeLayout.this.getPaddingLeft()) {
                        newLeft = SwipeLayout.this.getPaddingLeft();
                    } else if (SwipeLayout.this.mCurrentDragEdge == DragEdge.Right && newLeft > SwipeLayout.this.getPaddingLeft()) {
                        newLeft = SwipeLayout.this.getPaddingLeft();
                    } else if (SwipeLayout.this.mCurrentDragEdge == DragEdge.Top && newTop < SwipeLayout.this.getPaddingTop()) {
                        newTop = SwipeLayout.this.getPaddingTop();
                    } else if (SwipeLayout.this.mCurrentDragEdge == DragEdge.Bottom && newTop > SwipeLayout.this.getPaddingTop()) {
                        newTop = SwipeLayout.this.getPaddingTop();
                    }
                    surfaceView.layout(newLeft, newTop, newLeft + SwipeLayout.this.getMeasuredWidth(), newTop + SwipeLayout.this.getMeasuredHeight());
                }
            }
            SwipeLayout.this.dispatchRevealEvent(evLeft, evTop, evRight, evBottom);
            SwipeLayout.this.dispatchSwipeEvent(evLeft, evTop, dx, dy);
            SwipeLayout.this.invalidate();
        }
    };
    private int mEventCounter = 0;
    private List<OnLayout> mOnLayoutListeners;
    private boolean mIsBeingDragged;
    private float sX = -1.0f;
    private float sY = -1.0f;
    View.OnClickListener clickListener;
    View.OnLongClickListener longClickListener;
    private Rect hitSurfaceRect;
    private GestureDetector gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new SwipeDetector());

    public SwipeLayout(Context context) {
        this(context, null);
    }

    public SwipeLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mDragHelper = ViewDragHelper.create((ViewGroup)this, (ViewDragHelper.Callback)this.mDragHelperCallback);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SwipeLayout);
        int dragEdgeChoices = a.getInt(R.styleable.SwipeLayout_drag_edge, 2);
        this.mEdgeSwipesOffset[DragEdge.Left.ordinal()] = a.getDimension(R.styleable.SwipeLayout_leftEdgeSwipeOffset, 0.0f);
        this.mEdgeSwipesOffset[DragEdge.Right.ordinal()] = a.getDimension(R.styleable.SwipeLayout_rightEdgeSwipeOffset, 0.0f);
        this.mEdgeSwipesOffset[DragEdge.Top.ordinal()] = a.getDimension(R.styleable.SwipeLayout_topEdgeSwipeOffset, 0.0f);
        this.mEdgeSwipesOffset[DragEdge.Bottom.ordinal()] = a.getDimension(R.styleable.SwipeLayout_bottomEdgeSwipeOffset, 0.0f);
        this.setClickToClose(a.getBoolean(R.styleable.SwipeLayout_clickToClose, this.mClickToClose));
        if ((dragEdgeChoices & 1) == 1) {
            this.mDragEdges.put(DragEdge.Left, null);
        }
        if ((dragEdgeChoices & 4) == 4) {
            this.mDragEdges.put(DragEdge.Top, null);
        }
        if ((dragEdgeChoices & 2) == 2) {
            this.mDragEdges.put(DragEdge.Right, null);
        }
        if ((dragEdgeChoices & 8) == 8) {
            this.mDragEdges.put(DragEdge.Bottom, null);
        }
        int ordinal = a.getInt(R.styleable.SwipeLayout_show_mode, ShowMode.PullOut.ordinal());
        this.mShowMode = ShowMode.values()[ordinal];
        a.recycle();
    }

    public void addSwipeListener(SwipeListener l) {
        this.mSwipeListeners.add(l);
    }

    public void removeSwipeListener(SwipeListener l) {
        this.mSwipeListeners.remove(l);
    }

    public void removeAllSwipeListener() {
        this.mSwipeListeners.clear();
    }

    public void addSwipeDenier(SwipeDenier denier) {
        this.mSwipeDeniers.add(denier);
    }

    public void removeSwipeDenier(SwipeDenier denier) {
        this.mSwipeDeniers.remove(denier);
    }

    public void removeAllSwipeDeniers() {
        this.mSwipeDeniers.clear();
    }

    public void addRevealListener(int childId, OnRevealListener l) {
        View child2 = this.findViewById(childId);
        if (child2 == null) {
            throw new IllegalArgumentException("Child does not belong to SwipeListener.");
        }
        if (!this.mShowEntirely.containsKey(child2)) {
            this.mShowEntirely.put(child2, false);
        }
        if (this.mRevealListeners.get(child2) == null) {
            this.mRevealListeners.put(child2, new ArrayList());
        }
        this.mRevealListeners.get(child2).add(l);
    }

    public void addRevealListener(int[] childIds, OnRevealListener l) {
        for (int i : childIds) {
            this.addRevealListener(i, l);
        }
    }

    public void removeRevealListener(int childId, OnRevealListener l) {
        View child2 = this.findViewById(childId);
        if (child2 == null) {
            return;
        }
        this.mShowEntirely.remove(child2);
        if (this.mRevealListeners.containsKey(child2)) {
            this.mRevealListeners.get(child2).remove(l);
        }
    }

    public void removeAllRevealListeners(int childId) {
        View child2 = this.findViewById(childId);
        if (child2 != null) {
            this.mRevealListeners.remove(child2);
            this.mShowEntirely.remove(child2);
        }
    }

    protected boolean isViewTotallyFirstShowed(View child2, Rect relativePosition, DragEdge edge, int surfaceLeft, int surfaceTop, int surfaceRight, int surfaceBottom) {
        if (this.mShowEntirely.get(child2).booleanValue()) {
            return false;
        }
        int childLeft = relativePosition.left;
        int childRight = relativePosition.right;
        int childTop = relativePosition.top;
        int childBottom = relativePosition.bottom;
        boolean r = false;
        if (this.getShowMode() == ShowMode.LayDown) {
            if (edge == DragEdge.Right && surfaceRight <= childLeft || edge == DragEdge.Left && surfaceLeft >= childRight || edge == DragEdge.Top && surfaceTop >= childBottom || edge == DragEdge.Bottom && surfaceBottom <= childTop) {
                r = true;
            }
        } else if (this.getShowMode() == ShowMode.PullOut && (edge == DragEdge.Right && childRight <= this.getWidth() || edge == DragEdge.Left && childLeft >= this.getPaddingLeft() || edge == DragEdge.Top && childTop >= this.getPaddingTop() || edge == DragEdge.Bottom && childBottom <= this.getHeight())) {
            r = true;
        }
        return r;
    }

    protected boolean isViewShowing(View child2, Rect relativePosition, DragEdge availableEdge, int surfaceLeft, int surfaceTop, int surfaceRight, int surfaceBottom) {
        int childLeft = relativePosition.left;
        int childRight = relativePosition.right;
        int childTop = relativePosition.top;
        int childBottom = relativePosition.bottom;
        if (this.getShowMode() == ShowMode.LayDown) {
            switch (availableEdge) {
                case Right: {
                    if (surfaceRight <= childLeft || surfaceRight > childRight) break;
                    return true;
                }
                case Left: {
                    if (surfaceLeft >= childRight || surfaceLeft < childLeft) break;
                    return true;
                }
                case Top: {
                    if (surfaceTop < childTop || surfaceTop >= childBottom) break;
                    return true;
                }
                case Bottom: {
                    if (surfaceBottom <= childTop || surfaceBottom > childBottom) break;
                    return true;
                }
            }
        } else if (this.getShowMode() == ShowMode.PullOut) {
            switch (availableEdge) {
                case Right: {
                    if (childLeft > this.getWidth() || childRight <= this.getWidth()) break;
                    return true;
                }
                case Left: {
                    if (childRight < this.getPaddingLeft() || childLeft >= this.getPaddingLeft()) break;
                    return true;
                }
                case Top: {
                    if (childTop >= this.getPaddingTop() || childBottom < this.getPaddingTop()) break;
                    return true;
                }
                case Bottom: {
                    if (childTop >= this.getHeight() || childTop < this.getPaddingTop()) break;
                    return true;
                }
            }
        }
        return false;
    }

    protected Rect getRelativePosition(View child2) {
        View t = child2;
        Rect r = new Rect(t.getLeft(), t.getTop(), 0, 0);
        while (t.getParent() != null && t != this.getRootView() && (t = (View)t.getParent()) != this) {
            r.left += t.getLeft();
            r.top += t.getTop();
        }
        r.right = r.left + child2.getMeasuredWidth();
        r.bottom = r.top + child2.getMeasuredHeight();
        return r;
    }

    protected void dispatchSwipeEvent(int surfaceLeft, int surfaceTop, int dx, int dy) {
        DragEdge edge = this.getDragEdge();
        boolean open = true;
        if (edge == DragEdge.Left) {
            if (dx < 0) {
                open = false;
            }
        } else if (edge == DragEdge.Right) {
            if (dx > 0) {
                open = false;
            }
        } else if (edge == DragEdge.Top) {
            if (dy < 0) {
                open = false;
            }
        } else if (edge == DragEdge.Bottom && dy > 0) {
            open = false;
        }
        this.dispatchSwipeEvent(surfaceLeft, surfaceTop, open);
    }

    protected void dispatchSwipeEvent(int surfaceLeft, int surfaceTop, boolean open) {
        this.safeBottomView();
        Status status = this.getOpenStatus();
        if (!this.mSwipeListeners.isEmpty()) {
            ++this.mEventCounter;
            for (SwipeListener l : this.mSwipeListeners) {
                if (this.mEventCounter == 1) {
                    if (open) {
                        l.onStartOpen(this);
                    } else {
                        l.onStartClose(this);
                    }
                }
                l.onUpdate(this, surfaceLeft - this.getPaddingLeft(), surfaceTop - this.getPaddingTop());
            }
            if (status == Status.Close) {
                for (SwipeListener l : this.mSwipeListeners) {
                    l.onClose(this);
                }
                this.mEventCounter = 0;
            }
            if (status == Status.Open) {
                View currentBottomView = this.getCurrentBottomView();
                if (currentBottomView != null) {
                    currentBottomView.setEnabled(true);
                }
                for (SwipeListener l : this.mSwipeListeners) {
                    l.onOpen(this);
                }
                this.mEventCounter = 0;
            }
        }
    }

    private void safeBottomView() {
        Status status = this.getOpenStatus();
        List<View> bottoms = this.getBottomViews();
        if (status == Status.Close) {
            for (View bottom : bottoms) {
                if (bottom == null || bottom.getVisibility() == 4) continue;
                bottom.setVisibility(4);
            }
        } else {
            View currentBottomView = this.getCurrentBottomView();
            if (currentBottomView != null && currentBottomView.getVisibility() != 0) {
                currentBottomView.setVisibility(0);
            }
        }
    }

    protected void dispatchRevealEvent(int surfaceLeft, int surfaceTop, int surfaceRight, int surfaceBottom) {
        if (this.mRevealListeners.isEmpty()) {
            return;
        }
        for (Map.Entry<View, ArrayList<OnRevealListener>> entry : this.mRevealListeners.entrySet()) {
            Rect rect;
            View child2 = entry.getKey();
            if (this.isViewShowing(child2, rect = this.getRelativePosition(child2), this.mCurrentDragEdge, surfaceLeft, surfaceTop, surfaceRight, surfaceBottom)) {
                this.mShowEntirely.put(child2, false);
                int distance = 0;
                float fraction = 0.0f;
                if (this.getShowMode() == ShowMode.LayDown) {
                    switch (this.mCurrentDragEdge) {
                        case Left: {
                            distance = rect.left - surfaceLeft;
                            fraction = (float)distance / (float)child2.getWidth();
                            break;
                        }
                        case Right: {
                            distance = rect.right - surfaceRight;
                            fraction = (float)distance / (float)child2.getWidth();
                            break;
                        }
                        case Top: {
                            distance = rect.top - surfaceTop;
                            fraction = (float)distance / (float)child2.getHeight();
                            break;
                        }
                        case Bottom: {
                            distance = rect.bottom - surfaceBottom;
                            fraction = (float)distance / (float)child2.getHeight();
                        }
                    }
                } else if (this.getShowMode() == ShowMode.PullOut) {
                    switch (this.mCurrentDragEdge) {
                        case Left: {
                            distance = rect.right - this.getPaddingLeft();
                            fraction = (float)distance / (float)child2.getWidth();
                            break;
                        }
                        case Right: {
                            distance = rect.left - this.getWidth();
                            fraction = (float)distance / (float)child2.getWidth();
                            break;
                        }
                        case Top: {
                            distance = rect.bottom - this.getPaddingTop();
                            fraction = (float)distance / (float)child2.getHeight();
                            break;
                        }
                        case Bottom: {
                            distance = rect.top - this.getHeight();
                            fraction = (float)distance / (float)child2.getHeight();
                        }
                    }
                }
                for (OnRevealListener l : entry.getValue()) {
                    l.onReveal(child2, this.mCurrentDragEdge, Math.abs(fraction), distance);
                    if (Math.abs(fraction) != 1.0f) continue;
                    this.mShowEntirely.put(child2, true);
                }
            }
            if (!this.isViewTotallyFirstShowed(child2, rect, this.mCurrentDragEdge, surfaceLeft, surfaceTop, surfaceRight, surfaceBottom)) continue;
            this.mShowEntirely.put(child2, true);
            for (OnRevealListener l : entry.getValue()) {
                if (this.mCurrentDragEdge == DragEdge.Left || this.mCurrentDragEdge == DragEdge.Right) {
                    l.onReveal(child2, this.mCurrentDragEdge, 1.0f, child2.getWidth());
                    continue;
                }
                l.onReveal(child2, this.mCurrentDragEdge, 1.0f, child2.getHeight());
            }
        }
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void addOnLayoutListener(OnLayout l) {
        if (this.mOnLayoutListeners == null) {
            this.mOnLayoutListeners = new ArrayList<OnLayout>();
        }
        this.mOnLayoutListeners.add(l);
    }

    public void removeOnLayoutListener(OnLayout l) {
        if (this.mOnLayoutListeners != null) {
            this.mOnLayoutListeners.remove(l);
        }
    }

    public void clearDragEdge() {
        this.mDragEdges.clear();
    }

    public void setDrag(DragEdge dragEdge, int childId) {
        this.clearDragEdge();
        this.addDrag(dragEdge, childId);
    }

    public void setDrag(DragEdge dragEdge, View child2) {
        this.clearDragEdge();
        this.addDrag(dragEdge, child2);
    }

    public void addDrag(DragEdge dragEdge, int childId) {
        this.addDrag(dragEdge, this.findViewById(childId), null);
    }

    public void addDrag(DragEdge dragEdge, View child2) {
        this.addDrag(dragEdge, child2, null);
    }

    public void addDrag(DragEdge dragEdge, View child2, ViewGroup.LayoutParams params) {
        if (child2 == null) {
            return;
        }
        if (params == null) {
            params = this.generateDefaultLayoutParams();
        }
        if (!this.checkLayoutParams(params)) {
            params = this.generateLayoutParams(params);
        }
        int gravity = -1;
        switch (dragEdge) {
            case Left: {
                gravity = 3;
                break;
            }
            case Right: {
                gravity = 5;
                break;
            }
            case Top: {
                gravity = 48;
                break;
            }
            case Bottom: {
                gravity = 80;
            }
        }
        if (params instanceof FrameLayout.LayoutParams) {
            ((FrameLayout.LayoutParams)params).gravity = gravity;
        }
        this.addView(child2, 0, params);
    }

    public void addView(View child2, int index, ViewGroup.LayoutParams params) {
        block9: {
            block8: {
                if (child2 == null) {
                    return;
                }
                int gravity = 0;
                try {
                    gravity = (Integer)params.getClass().getField("gravity").get(params);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (gravity <= 0) break block8;
                if (((gravity = GravityCompat.getAbsoluteGravity((int)gravity, (int)ViewCompat.getLayoutDirection((View)this))) & 3) == 3) {
                    this.mDragEdges.put(DragEdge.Left, child2);
                }
                if ((gravity & 5) == 5) {
                    this.mDragEdges.put(DragEdge.Right, child2);
                }
                if ((gravity & 0x30) == 48) {
                    this.mDragEdges.put(DragEdge.Top, child2);
                }
                if ((gravity & 0x50) != 80) break block9;
                this.mDragEdges.put(DragEdge.Bottom, child2);
                break block9;
            }
            for (Map.Entry<DragEdge, View> entry : this.mDragEdges.entrySet()) {
                if (entry.getValue() != null) continue;
                this.mDragEdges.put(entry.getKey(), child2);
                break;
            }
        }
        if (child2.getParent() == this) {
            return;
        }
        super.addView(child2, index, params);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.updateBottomViews();
        if (this.mOnLayoutListeners != null) {
            for (int i = 0; i < this.mOnLayoutListeners.size(); ++i) {
                this.mOnLayoutListeners.get(i).onLayout(this);
            }
        }
    }

    void layoutPullOut() {
        Rect rect = this.computeSurfaceLayoutArea(false);
        View surfaceView = this.getSurfaceView();
        if (surfaceView != null) {
            surfaceView.layout(rect.left, rect.top, rect.right, rect.bottom);
            this.bringChildToFront(surfaceView);
        }
        rect = this.computeBottomLayoutAreaViaSurface(ShowMode.PullOut, rect);
        View currentBottomView = this.getCurrentBottomView();
        if (currentBottomView != null) {
            currentBottomView.layout(rect.left, rect.top, rect.right, rect.bottom);
        }
    }

    void layoutLayDown() {
        Rect rect = this.computeSurfaceLayoutArea(false);
        View surfaceView = this.getSurfaceView();
        if (surfaceView != null) {
            surfaceView.layout(rect.left, rect.top, rect.right, rect.bottom);
            this.bringChildToFront(surfaceView);
        }
        rect = this.computeBottomLayoutAreaViaSurface(ShowMode.LayDown, rect);
        View currentBottomView = this.getCurrentBottomView();
        if (currentBottomView != null) {
            currentBottomView.layout(rect.left, rect.top, rect.right, rect.bottom);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkCanDrag(MotionEvent ev) {
        boolean suitable;
        if (this.mIsBeingDragged) {
            return;
        }
        if (this.getOpenStatus() == Status.Middle) {
            this.mIsBeingDragged = true;
            return;
        }
        Status status = this.getOpenStatus();
        float distanceX = ev.getRawX() - this.sX;
        float distanceY = ev.getRawY() - this.sY;
        float angle = Math.abs(distanceY / distanceX);
        angle = (float)Math.toDegrees(Math.atan(angle));
        if (this.getOpenStatus() == Status.Close) {
            DragEdge dragEdge;
            if (angle < 45.0f) {
                if (distanceX > 0.0f && this.isLeftSwipeEnabled()) {
                    dragEdge = DragEdge.Left;
                } else {
                    if (!(distanceX < 0.0f) || !this.isRightSwipeEnabled()) return;
                    dragEdge = DragEdge.Right;
                }
            } else if (distanceY > 0.0f && this.isTopSwipeEnabled()) {
                dragEdge = DragEdge.Top;
            } else {
                if (!(distanceY < 0.0f) || !this.isBottomSwipeEnabled()) return;
                dragEdge = DragEdge.Bottom;
            }
            this.setCurrentDragEdge(dragEdge);
        }
        boolean doNothing = false;
        if (this.mCurrentDragEdge == DragEdge.Right) {
            suitable = status == Status.Open && distanceX > (float)this.mTouchSlop || status == Status.Close && distanceX < (float)(-this.mTouchSlop);
            boolean bl = suitable = suitable || status == Status.Middle;
            if (angle > 30.0f || !suitable) {
                doNothing = true;
            }
        }
        if (this.mCurrentDragEdge == DragEdge.Left) {
            suitable = status == Status.Open && distanceX < (float)(-this.mTouchSlop) || status == Status.Close && distanceX > (float)this.mTouchSlop;
            boolean bl = suitable = suitable || status == Status.Middle;
            if (angle > 30.0f || !suitable) {
                doNothing = true;
            }
        }
        if (this.mCurrentDragEdge == DragEdge.Top) {
            suitable = status == Status.Open && distanceY < (float)(-this.mTouchSlop) || status == Status.Close && distanceY > (float)this.mTouchSlop;
            boolean bl = suitable = suitable || status == Status.Middle;
            if (angle < 60.0f || !suitable) {
                doNothing = true;
            }
        }
        if (this.mCurrentDragEdge == DragEdge.Bottom) {
            suitable = status == Status.Open && distanceY > (float)this.mTouchSlop || status == Status.Close && distanceY < (float)(-this.mTouchSlop);
            boolean bl = suitable = suitable || status == Status.Middle;
            if (angle < 60.0f || !suitable) {
                doNothing = true;
            }
        }
        this.mIsBeingDragged = !doNothing;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.isSwipeEnabled()) {
            return false;
        }
        if (this.mClickToClose && this.getOpenStatus() == Status.Open && this.isTouchOnSurface(ev)) {
            return true;
        }
        for (SwipeDenier denier : this.mSwipeDeniers) {
            if (denier == null || !denier.shouldDenySwipe(ev)) continue;
            return false;
        }
        switch (ev.getAction()) {
            case 0: {
                this.mDragHelper.processTouchEvent(ev);
                this.mIsBeingDragged = false;
                this.sX = ev.getRawX();
                this.sY = ev.getRawY();
                if (this.getOpenStatus() != Status.Middle) break;
                this.mIsBeingDragged = true;
                break;
            }
            case 2: {
                ViewParent parent2;
                boolean beforeCheck = this.mIsBeingDragged;
                this.checkCanDrag(ev);
                if (this.mIsBeingDragged && (parent2 = this.getParent()) != null) {
                    parent2.requestDisallowInterceptTouchEvent(true);
                }
                if (beforeCheck || !this.mIsBeingDragged) break;
                return false;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mDragHelper.processTouchEvent(ev);
                break;
            }
            default: {
                this.mDragHelper.processTouchEvent(ev);
            }
        }
        return this.mIsBeingDragged;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isSwipeEnabled()) {
            return super.onTouchEvent(event);
        }
        int action = event.getActionMasked();
        this.gestureDetector.onTouchEvent(event);
        switch (action) {
            case 0: {
                this.mDragHelper.processTouchEvent(event);
                this.sX = event.getRawX();
                this.sY = event.getRawY();
            }
            case 2: {
                this.checkCanDrag(event);
                if (!this.mIsBeingDragged) break;
                this.getParent().requestDisallowInterceptTouchEvent(true);
                this.mDragHelper.processTouchEvent(event);
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mDragHelper.processTouchEvent(event);
                break;
            }
            default: {
                this.mDragHelper.processTouchEvent(event);
            }
        }
        return super.onTouchEvent(event) || this.mIsBeingDragged || action == 0;
    }

    public boolean isClickToClose() {
        return this.mClickToClose;
    }

    public void setClickToClose(boolean mClickToClose) {
        this.mClickToClose = mClickToClose;
    }

    public void setSwipeEnabled(boolean enabled) {
        this.mSwipeEnabled = enabled;
    }

    public boolean isSwipeEnabled() {
        return this.mSwipeEnabled;
    }

    public boolean isLeftSwipeEnabled() {
        View bottomView = this.mDragEdges.get((Object)DragEdge.Left);
        return bottomView != null && bottomView.getParent() == this && bottomView != this.getSurfaceView() && this.mSwipesEnabled[DragEdge.Left.ordinal()];
    }

    public void setLeftSwipeEnabled(boolean leftSwipeEnabled) {
        this.mSwipesEnabled[DragEdge.Left.ordinal()] = leftSwipeEnabled;
    }

    public boolean isRightSwipeEnabled() {
        View bottomView = this.mDragEdges.get((Object)DragEdge.Right);
        return bottomView != null && bottomView.getParent() == this && bottomView != this.getSurfaceView() && this.mSwipesEnabled[DragEdge.Right.ordinal()];
    }

    public void setRightSwipeEnabled(boolean rightSwipeEnabled) {
        this.mSwipesEnabled[DragEdge.Right.ordinal()] = rightSwipeEnabled;
    }

    public boolean isTopSwipeEnabled() {
        View bottomView = this.mDragEdges.get((Object)DragEdge.Top);
        return bottomView != null && bottomView.getParent() == this && bottomView != this.getSurfaceView() && this.mSwipesEnabled[DragEdge.Top.ordinal()];
    }

    public void setTopSwipeEnabled(boolean topSwipeEnabled) {
        this.mSwipesEnabled[DragEdge.Top.ordinal()] = topSwipeEnabled;
    }

    public boolean isBottomSwipeEnabled() {
        View bottomView = this.mDragEdges.get((Object)DragEdge.Bottom);
        return bottomView != null && bottomView.getParent() == this && bottomView != this.getSurfaceView() && this.mSwipesEnabled[DragEdge.Bottom.ordinal()];
    }

    public void setBottomSwipeEnabled(boolean bottomSwipeEnabled) {
        this.mSwipesEnabled[DragEdge.Bottom.ordinal()] = bottomSwipeEnabled;
    }

    private boolean insideAdapterView() {
        return this.getAdapterView() != null;
    }

    private AdapterView getAdapterView() {
        ViewParent t = this.getParent();
        if (t instanceof AdapterView) {
            return (AdapterView)t;
        }
        return null;
    }

    private void performAdapterViewItemClick() {
        AdapterView view;
        int p;
        if (this.getOpenStatus() != Status.Close) {
            return;
        }
        ViewParent t = this.getParent();
        if (t instanceof AdapterView && (p = (view = (AdapterView)t).getPositionForView((View)this)) != -1) {
            view.performItemClick(view.getChildAt(p - view.getFirstVisiblePosition()), p, view.getAdapter().getItemId(p));
        }
    }

    private boolean performAdapterViewItemLongClick() {
        if (this.getOpenStatus() != Status.Close) {
            return false;
        }
        ViewParent t = this.getParent();
        if (t instanceof AdapterView) {
            boolean handled;
            block6: {
                AdapterView view = (AdapterView)t;
                int p = view.getPositionForView((View)this);
                if (p == -1) {
                    return false;
                }
                long vId = view.getItemIdAtPosition(p);
                handled = false;
                try {
                    Method m = AbsListView.class.getDeclaredMethod("performLongPress", View.class, Integer.TYPE, Long.TYPE);
                    m.setAccessible(true);
                    handled = (Boolean)m.invoke((Object)view, new Object[]{this, p, vId});
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (view.getOnItemLongClickListener() != null) {
                        handled = view.getOnItemLongClickListener().onItemLongClick(view, (View)this, p, vId);
                    }
                    if (!handled) break block6;
                    view.performHapticFeedback(0);
                }
            }
            return handled;
        }
        return false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.insideAdapterView()) {
            if (this.clickListener == null) {
                this.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SwipeLayout.this.performAdapterViewItemClick();
                    }
                });
            }
            if (this.longClickListener == null) {
                this.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        SwipeLayout.this.performAdapterViewItemLongClick();
                        return true;
                    }
                });
            }
        }
    }

    public void setOnClickListener(View.OnClickListener l) {
        super.setOnClickListener(l);
        this.clickListener = l;
    }

    public void setOnLongClickListener(View.OnLongClickListener l) {
        super.setOnLongClickListener(l);
        this.longClickListener = l;
    }

    private boolean isTouchOnSurface(MotionEvent ev) {
        View surfaceView = this.getSurfaceView();
        if (surfaceView == null) {
            return false;
        }
        if (this.hitSurfaceRect == null) {
            this.hitSurfaceRect = new Rect();
        }
        surfaceView.getHitRect(this.hitSurfaceRect);
        return this.hitSurfaceRect.contains((int)ev.getX(), (int)ev.getY());
    }

    public void setDragDistance(int max) {
        if (max < 0) {
            max = 0;
        }
        this.mDragDistance = this.dp2px(max);
        this.requestLayout();
    }

    public void setShowMode(ShowMode mode) {
        this.mShowMode = mode;
        this.requestLayout();
    }

    public DragEdge getDragEdge() {
        return this.mCurrentDragEdge;
    }

    public int getDragDistance() {
        return this.mDragDistance;
    }

    public ShowMode getShowMode() {
        return this.mShowMode;
    }

    public View getSurfaceView() {
        if (this.getChildCount() == 0) {
            return null;
        }
        return this.getChildAt(this.getChildCount() - 1);
    }

    @Nullable
    public View getCurrentBottomView() {
        List<View> bottoms = this.getBottomViews();
        if (this.mCurrentDragEdge.ordinal() < bottoms.size()) {
            return bottoms.get(this.mCurrentDragEdge.ordinal());
        }
        return null;
    }

    public List<View> getBottomViews() {
        ArrayList<View> bottoms = new ArrayList<View>();
        for (DragEdge dragEdge : DragEdge.values()) {
            bottoms.add(this.mDragEdges.get((Object)dragEdge));
        }
        return bottoms;
    }

    public Status getOpenStatus() {
        View surfaceView = this.getSurfaceView();
        if (surfaceView == null) {
            return Status.Close;
        }
        int surfaceLeft = surfaceView.getLeft();
        int surfaceTop = surfaceView.getTop();
        if (surfaceLeft == this.getPaddingLeft() && surfaceTop == this.getPaddingTop()) {
            return Status.Close;
        }
        if (surfaceLeft == this.getPaddingLeft() - this.mDragDistance || surfaceLeft == this.getPaddingLeft() + this.mDragDistance || surfaceTop == this.getPaddingTop() - this.mDragDistance || surfaceTop == this.getPaddingTop() + this.mDragDistance) {
            return Status.Open;
        }
        return Status.Middle;
    }

    protected void processHandRelease(float xvel, float yvel, boolean isCloseBeforeDragged) {
        float willOpenPercent;
        float minVelocity = this.mDragHelper.getMinVelocity();
        View surfaceView = this.getSurfaceView();
        DragEdge currentDragEdge = this.mCurrentDragEdge;
        if (currentDragEdge == null || surfaceView == null) {
            return;
        }
        float f = willOpenPercent = isCloseBeforeDragged ? 0.25f : 0.75f;
        if (currentDragEdge == DragEdge.Left) {
            if (xvel > minVelocity) {
                this.open();
            } else if (xvel < -minVelocity) {
                this.close();
            } else {
                float openPercent = 1.0f * (float)this.getSurfaceView().getLeft() / (float)this.mDragDistance;
                if (openPercent > willOpenPercent) {
                    this.open();
                } else {
                    this.close();
                }
            }
        } else if (currentDragEdge == DragEdge.Right) {
            if (xvel > minVelocity) {
                this.close();
            } else if (xvel < -minVelocity) {
                this.open();
            } else {
                float openPercent = 1.0f * (float)(-this.getSurfaceView().getLeft()) / (float)this.mDragDistance;
                if (openPercent > willOpenPercent) {
                    this.open();
                } else {
                    this.close();
                }
            }
        } else if (currentDragEdge == DragEdge.Top) {
            if (yvel > minVelocity) {
                this.open();
            } else if (yvel < -minVelocity) {
                this.close();
            } else {
                float openPercent = 1.0f * (float)this.getSurfaceView().getTop() / (float)this.mDragDistance;
                if (openPercent > willOpenPercent) {
                    this.open();
                } else {
                    this.close();
                }
            }
        } else if (currentDragEdge == DragEdge.Bottom) {
            if (yvel > minVelocity) {
                this.close();
            } else if (yvel < -minVelocity) {
                this.open();
            } else {
                float openPercent = 1.0f * (float)(-this.getSurfaceView().getTop()) / (float)this.mDragDistance;
                if (openPercent > willOpenPercent) {
                    this.open();
                } else {
                    this.close();
                }
            }
        }
    }

    public void open() {
        this.open(true, true);
    }

    public void open(boolean smooth) {
        this.open(smooth, true);
    }

    public void open(boolean smooth, boolean notify) {
        View surface = this.getSurfaceView();
        View bottom = this.getCurrentBottomView();
        if (surface == null) {
            return;
        }
        Rect rect = this.computeSurfaceLayoutArea(true);
        if (smooth) {
            this.mDragHelper.smoothSlideViewTo(surface, rect.left, rect.top);
        } else {
            int dx = rect.left - surface.getLeft();
            int dy = rect.top - surface.getTop();
            surface.layout(rect.left, rect.top, rect.right, rect.bottom);
            if (this.getShowMode() == ShowMode.PullOut) {
                Rect bRect = this.computeBottomLayoutAreaViaSurface(ShowMode.PullOut, rect);
                if (bottom != null) {
                    bottom.layout(bRect.left, bRect.top, bRect.right, bRect.bottom);
                }
            }
            if (notify) {
                this.dispatchRevealEvent(rect.left, rect.top, rect.right, rect.bottom);
                this.dispatchSwipeEvent(rect.left, rect.top, dx, dy);
            } else {
                this.safeBottomView();
            }
        }
        this.invalidate();
    }

    public void open(DragEdge edge) {
        this.setCurrentDragEdge(edge);
        this.open(true, true);
    }

    public void open(boolean smooth, DragEdge edge) {
        this.setCurrentDragEdge(edge);
        this.open(smooth, true);
    }

    public void open(boolean smooth, boolean notify, DragEdge edge) {
        this.setCurrentDragEdge(edge);
        this.open(smooth, notify);
    }

    public void close() {
        this.close(true, true);
    }

    public void close(boolean smooth) {
        this.close(smooth, true);
    }

    public void close(boolean smooth, boolean notify) {
        View surface = this.getSurfaceView();
        if (surface == null) {
            return;
        }
        if (smooth) {
            this.mDragHelper.smoothSlideViewTo(this.getSurfaceView(), this.getPaddingLeft(), this.getPaddingTop());
        } else {
            Rect rect = this.computeSurfaceLayoutArea(false);
            int dx = rect.left - surface.getLeft();
            int dy = rect.top - surface.getTop();
            surface.layout(rect.left, rect.top, rect.right, rect.bottom);
            if (notify) {
                this.dispatchRevealEvent(rect.left, rect.top, rect.right, rect.bottom);
                this.dispatchSwipeEvent(rect.left, rect.top, dx, dy);
            } else {
                this.safeBottomView();
            }
        }
        this.invalidate();
    }

    public void toggle() {
        this.toggle(true);
    }

    public void toggle(boolean smooth) {
        if (this.getOpenStatus() == Status.Open) {
            this.close(smooth);
        } else if (this.getOpenStatus() == Status.Close) {
            this.open(smooth);
        }
    }

    private Rect computeSurfaceLayoutArea(boolean open) {
        int l = this.getPaddingLeft();
        int t = this.getPaddingTop();
        if (open) {
            if (this.mCurrentDragEdge == DragEdge.Left) {
                l = this.getPaddingLeft() + this.mDragDistance;
            } else if (this.mCurrentDragEdge == DragEdge.Right) {
                l = this.getPaddingLeft() - this.mDragDistance;
            } else {
                t = this.mCurrentDragEdge == DragEdge.Top ? this.getPaddingTop() + this.mDragDistance : this.getPaddingTop() - this.mDragDistance;
            }
        }
        return new Rect(l, t, l + this.getMeasuredWidth(), t + this.getMeasuredHeight());
    }

    private Rect computeBottomLayoutAreaViaSurface(ShowMode mode, Rect surfaceArea) {
        Rect rect = surfaceArea;
        View bottomView = this.getCurrentBottomView();
        int bl = rect.left;
        int bt = rect.top;
        int br = rect.right;
        int bb = rect.bottom;
        if (mode == ShowMode.PullOut) {
            if (this.mCurrentDragEdge == DragEdge.Left) {
                bl = rect.left - this.mDragDistance;
            } else if (this.mCurrentDragEdge == DragEdge.Right) {
                bl = rect.right;
            } else {
                bt = this.mCurrentDragEdge == DragEdge.Top ? rect.top - this.mDragDistance : rect.bottom;
            }
            if (this.mCurrentDragEdge == DragEdge.Left || this.mCurrentDragEdge == DragEdge.Right) {
                bb = rect.bottom;
                br = bl + (bottomView == null ? 0 : bottomView.getMeasuredWidth());
            } else {
                bb = bt + (bottomView == null ? 0 : bottomView.getMeasuredHeight());
                br = rect.right;
            }
        } else if (mode == ShowMode.LayDown) {
            if (this.mCurrentDragEdge == DragEdge.Left) {
                br = bl + this.mDragDistance;
            } else if (this.mCurrentDragEdge == DragEdge.Right) {
                bl = br - this.mDragDistance;
            } else if (this.mCurrentDragEdge == DragEdge.Top) {
                bb = bt + this.mDragDistance;
            } else {
                bt = bb - this.mDragDistance;
            }
        }
        return new Rect(bl, bt, br, bb);
    }

    private Rect computeBottomLayDown(DragEdge dragEdge) {
        int bb;
        int br;
        int bl = this.getPaddingLeft();
        int bt = this.getPaddingTop();
        if (dragEdge == DragEdge.Right) {
            bl = this.getMeasuredWidth() - this.mDragDistance;
        } else if (dragEdge == DragEdge.Bottom) {
            bt = this.getMeasuredHeight() - this.mDragDistance;
        }
        if (dragEdge == DragEdge.Left || dragEdge == DragEdge.Right) {
            br = bl + this.mDragDistance;
            bb = bt + this.getMeasuredHeight();
        } else {
            br = bl + this.getMeasuredWidth();
            bb = bt + this.mDragDistance;
        }
        return new Rect(bl, bt, br, bb);
    }

    public void setOnDoubleClickListener(DoubleClickListener doubleClickListener) {
        this.mDoubleClickListener = doubleClickListener;
    }

    private int dp2px(float dp) {
        return (int)(dp * this.getContext().getResources().getDisplayMetrics().density + 0.5f);
    }

    @Deprecated
    public void setDragEdge(DragEdge dragEdge) {
        this.clearDragEdge();
        if (this.getChildCount() >= 2) {
            this.mDragEdges.put(dragEdge, this.getChildAt(this.getChildCount() - 2));
        }
        this.setCurrentDragEdge(dragEdge);
    }

    protected void onViewRemoved(View child2) {
        for (Map.Entry<DragEdge, View> entry : new HashMap<DragEdge, View>(this.mDragEdges).entrySet()) {
            if (entry.getValue() != child2) continue;
            this.mDragEdges.remove((Object)entry.getKey());
        }
    }

    public Map<DragEdge, View> getDragEdgeMap() {
        return this.mDragEdges;
    }

    @Deprecated
    public List<DragEdge> getDragEdges() {
        return new ArrayList<DragEdge>(this.mDragEdges.keySet());
    }

    @Deprecated
    public void setDragEdges(List<DragEdge> dragEdges) {
        this.clearDragEdge();
        int size = Math.min(dragEdges.size(), this.getChildCount() - 1);
        for (int i = 0; i < size; ++i) {
            DragEdge dragEdge = dragEdges.get(i);
            this.mDragEdges.put(dragEdge, this.getChildAt(i));
        }
        if (dragEdges.size() == 0 || dragEdges.contains((Object)DefaultDragEdge)) {
            this.setCurrentDragEdge(DefaultDragEdge);
        } else {
            this.setCurrentDragEdge(dragEdges.get(0));
        }
    }

    @Deprecated
    public void setDragEdges(DragEdge ... mDragEdges) {
        this.clearDragEdge();
        this.setDragEdges(Arrays.asList(mDragEdges));
    }

    @Deprecated
    public void setBottomViewIds(int leftId, int rightId, int topId, int bottomId) {
        this.addDrag(DragEdge.Left, this.findViewById(leftId));
        this.addDrag(DragEdge.Right, this.findViewById(rightId));
        this.addDrag(DragEdge.Top, this.findViewById(topId));
        this.addDrag(DragEdge.Bottom, this.findViewById(bottomId));
    }

    private float getCurrentOffset() {
        if (this.mCurrentDragEdge == null) {
            return 0.0f;
        }
        return this.mEdgeSwipesOffset[this.mCurrentDragEdge.ordinal()];
    }

    private void setCurrentDragEdge(DragEdge dragEdge) {
        this.mCurrentDragEdge = dragEdge;
        this.updateBottomViews();
    }

    private void updateBottomViews() {
        View currentBottomView = this.getCurrentBottomView();
        if (currentBottomView != null) {
            this.mDragDistance = this.mCurrentDragEdge == DragEdge.Left || this.mCurrentDragEdge == DragEdge.Right ? currentBottomView.getMeasuredWidth() - this.dp2px(this.getCurrentOffset()) : currentBottomView.getMeasuredHeight() - this.dp2px(this.getCurrentOffset());
        }
        if (this.mShowMode == ShowMode.PullOut) {
            this.layoutPullOut();
        } else if (this.mShowMode == ShowMode.LayDown) {
            this.layoutLayDown();
        }
        this.safeBottomView();
    }

    public static interface DoubleClickListener {
        public void onDoubleClick(SwipeLayout var1, boolean var2);
    }

    public static enum Status {
        Middle,
        Open,
        Close;

    }

    class SwipeDetector
    extends GestureDetector.SimpleOnGestureListener {
        SwipeDetector() {
        }

        public boolean onSingleTapUp(MotionEvent e) {
            if (SwipeLayout.this.mClickToClose && SwipeLayout.this.isTouchOnSurface(e)) {
                SwipeLayout.this.close();
            }
            return super.onSingleTapUp(e);
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (SwipeLayout.this.mDoubleClickListener != null) {
                View bottom = SwipeLayout.this.getCurrentBottomView();
                View surface = SwipeLayout.this.getSurfaceView();
                View target = bottom != null && e.getX() > (float)bottom.getLeft() && e.getX() < (float)bottom.getRight() && e.getY() > (float)bottom.getTop() && e.getY() < (float)bottom.getBottom() ? bottom : surface;
                SwipeLayout.this.mDoubleClickListener.onDoubleClick(SwipeLayout.this, target == surface);
            }
            return true;
        }
    }

    public static interface OnLayout {
        public void onLayout(SwipeLayout var1);
    }

    public static interface OnRevealListener {
        public void onReveal(View var1, DragEdge var2, float var3, int var4);
    }

    public static interface SwipeDenier {
        public boolean shouldDenySwipe(MotionEvent var1);
    }

    public static interface SwipeListener {
        public void onStartOpen(SwipeLayout var1);

        public void onOpen(SwipeLayout var1);

        public void onStartClose(SwipeLayout var1);

        public void onClose(SwipeLayout var1);

        public void onUpdate(SwipeLayout var1, int var2, int var3);

        public void onHandRelease(SwipeLayout var1, float var2, float var3);
    }

    public static enum ShowMode {
        LayDown,
        PullOut;

    }

    public static enum DragEdge {
        Left,
        Top,
        Right,
        Bottom;

    }
}

