/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.quickAdapter.extBaseAdapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import com.marshalchen.ultimaterecyclerview.quickAdapter.extBaseAdapter.BaseAdapterHelper;
import com.marshalchen.ultimaterecyclerview.quickAdapter.extUtimateRVA.MultiItemTypeSupport;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseQuickAdapter<T, H extends BaseAdapterHelper>
extends BaseAdapter {
    protected static final String TAG = BaseQuickAdapter.class.getSimpleName();
    protected final Context context;
    protected int layoutResId;
    protected final List<T> data;
    protected boolean displayIndeterminateProgress = false;
    protected MultiItemTypeSupport<T> mMultiItemSupport;

    public BaseQuickAdapter(Context context, int layoutResId) {
        this(context, layoutResId, null);
    }

    public BaseQuickAdapter(Context context, int layoutResId, List<T> data) {
        this.data = data == null ? new ArrayList<T>() : new ArrayList<T>(data);
        this.context = context;
        this.layoutResId = layoutResId;
    }

    public BaseQuickAdapter(Context context, ArrayList<T> data, MultiItemTypeSupport<T> multiItemSupport) {
        this.mMultiItemSupport = multiItemSupport;
        this.data = data == null ? new ArrayList<T>() : new ArrayList<T>(data);
        this.context = context;
    }

    public int getCount() {
        int extra = this.displayIndeterminateProgress ? 1 : 0;
        return this.data.size() + extra;
    }

    public T getItem(int position) {
        if (position >= this.data.size()) {
            return null;
        }
        return this.data.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getViewTypeCount() {
        if (this.mMultiItemSupport != null) {
            return this.mMultiItemSupport.getViewTypeCount() + 1;
        }
        return 2;
    }

    public int getItemViewType(int position) {
        if (this.displayIndeterminateProgress) {
            if (this.mMultiItemSupport != null) {
                return position >= this.data.size() ? 0 : this.mMultiItemSupport.getItemViewType(position, this.data.get(position));
            }
        } else if (this.mMultiItemSupport != null) {
            return this.mMultiItemSupport.getItemViewType(position, this.data.get(position));
        }
        return position >= this.data.size() ? 0 : 1;
    }

    public View getView(int position, View convertView, ViewGroup parent2) {
        if (this.getItemViewType(position) == 0) {
            return this.createIndeterminateProgressView(convertView, parent2);
        }
        H helper = this.getAdapterHelper(position, convertView, parent2);
        T item = this.getItem(position);
        ((BaseAdapterHelper)helper).setAssociatedObject(item);
        this.convert(helper, item);
        return ((BaseAdapterHelper)helper).getView();
    }

    private View createIndeterminateProgressView(View convertView, ViewGroup parent2) {
        if (convertView == null) {
            FrameLayout container = new FrameLayout(this.context);
            container.setForegroundGravity(17);
            ProgressBar progress = new ProgressBar(this.context);
            container.addView((View)progress);
            convertView = container;
        }
        return convertView;
    }

    public boolean isEnabled(int position) {
        return position < this.data.size();
    }

    public void add(T elem) {
        this.data.add(elem);
        this.notifyDataSetChanged();
    }

    public void addAll(List<T> elem) {
        this.data.addAll(elem);
        this.notifyDataSetChanged();
    }

    public void set(T oldElem, T newElem) {
        this.set(this.data.indexOf(oldElem), newElem);
    }

    public void set(int index, T elem) {
        this.data.set(index, elem);
        this.notifyDataSetChanged();
    }

    public void remove(T elem) {
        this.data.remove(elem);
        this.notifyDataSetChanged();
    }

    public void remove(int index) {
        this.data.remove(index);
        this.notifyDataSetChanged();
    }

    public void replaceAll(List<T> elem) {
        this.data.clear();
        this.data.addAll(elem);
        this.notifyDataSetChanged();
    }

    public boolean contains(T elem) {
        return this.data.contains(elem);
    }

    public void clear() {
        this.data.clear();
        this.notifyDataSetChanged();
    }

    public void showIndeterminateProgress(boolean display) {
        if (display == this.displayIndeterminateProgress) {
            return;
        }
        this.displayIndeterminateProgress = display;
        this.notifyDataSetChanged();
    }

    protected abstract void convert(H var1, T var2);

    protected abstract H getAdapterHelper(int var1, View var2, ViewGroup var3);
}

