/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.dragsortadapter;

import android.graphics.Point;
import android.graphics.PointF;

public class DragInfo {
    private final long itemId;
    private final Point shadowSize;
    private final Point shadowTouchPoint;
    private final PointF dragPoint;

    public DragInfo(long itemId, Point shadowSize, Point shadowTouchPoint, PointF dragPoint) {
        this.itemId = itemId;
        this.shadowSize = new Point(shadowSize);
        this.shadowTouchPoint = new Point(shadowTouchPoint);
        this.dragPoint = dragPoint;
    }

    public long itemId() {
        return this.itemId;
    }

    public boolean shouldScrollLeft() {
        return this.dragPoint.x < (float)this.shadowTouchPoint.x;
    }

    public boolean shouldScrollRight(int parentWidth) {
        return this.dragPoint.x > (float)(parentWidth - (this.shadowSize.x - this.shadowTouchPoint.x));
    }

    public boolean shouldScrollUp() {
        return this.dragPoint.y < (float)this.shadowTouchPoint.y;
    }

    public boolean shouldScrollDown(int parentHeight) {
        return this.dragPoint.y > (float)(parentHeight - (this.shadowSize.y - this.shadowTouchPoint.y));
    }

    public void setDragPoint(float x, float y) {
        this.dragPoint.set(x, y);
    }
}

