/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.divideritemdecoration;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.DimenRes;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.marshalchen.ultimaterecyclerview.divideritemdecoration.FlexibleDividerDecoration;

public class HorizontalDividerItemDecoration
extends FlexibleDividerDecoration {
    private MarginProvider mMarginProvider;

    protected HorizontalDividerItemDecoration(Builder builder) {
        super(builder);
        this.mMarginProvider = builder.mMarginProvider;
    }

    @Override
    protected Rect getDividerBound(int position, RecyclerView parent2, View child2) {
        Rect bounds = new Rect(0, 0, 0, 0);
        int transitionX = (int)ViewCompat.getTranslationX((View)child2);
        int transitionY = (int)ViewCompat.getTranslationY((View)child2);
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child2.getLayoutParams();
        bounds.left = parent2.getPaddingLeft() + this.mMarginProvider.dividerLeftMargin(position, parent2) + transitionX;
        bounds.right = parent2.getWidth() - parent2.getPaddingRight() - this.mMarginProvider.dividerRightMargin(position, parent2) + transitionX;
        int dividerSize = this.getDividerSize(position, parent2);
        if (this.mDividerType == FlexibleDividerDecoration.DividerType.DRAWABLE) {
            bounds.top = child2.getBottom() + params.topMargin + transitionY;
            bounds.bottom = bounds.top + dividerSize;
        } else {
            bounds.bottom = bounds.top = child2.getBottom() + params.topMargin + dividerSize / 2 + transitionY;
        }
        return bounds;
    }

    @Override
    protected void setItemOffsets(Rect outRect, int position, RecyclerView parent2) {
        outRect.set(0, 0, 0, this.getDividerSize(position, parent2));
    }

    private int getDividerSize(int position, RecyclerView parent2) {
        if (this.mPaintProvider != null) {
            return (int)this.mPaintProvider.dividerPaint(position, parent2).getStrokeWidth();
        }
        if (this.mSizeProvider != null) {
            return this.mSizeProvider.dividerSize(position, parent2);
        }
        if (this.mDrawableProvider != null) {
            Drawable drawable2 = this.mDrawableProvider.drawableProvider(position, parent2);
            return drawable2.getIntrinsicHeight();
        }
        throw new RuntimeException("failed to get size");
    }

    public static class Builder
    extends FlexibleDividerDecoration.Builder<Builder> {
        private MarginProvider mMarginProvider = new MarginProvider(){

            @Override
            public int dividerLeftMargin(int position, RecyclerView parent2) {
                return 0;
            }

            @Override
            public int dividerRightMargin(int position, RecyclerView parent2) {
                return 0;
            }
        };

        public Builder(Context context) {
            super(context);
        }

        public Builder margin(final int leftMargin, final int rightMargin) {
            return this.marginProvider(new MarginProvider(){

                @Override
                public int dividerLeftMargin(int position, RecyclerView parent2) {
                    return leftMargin;
                }

                @Override
                public int dividerRightMargin(int position, RecyclerView parent2) {
                    return rightMargin;
                }
            });
        }

        public Builder margin(int horizontalMargin) {
            return this.margin(horizontalMargin, horizontalMargin);
        }

        public Builder marginResId(@DimenRes int leftMarginId, @DimenRes int rightMarginId) {
            return this.margin(this.mResources.getDimensionPixelSize(leftMarginId), this.mResources.getDimensionPixelSize(rightMarginId));
        }

        public Builder marginResId(@DimenRes int horizontalMarginId) {
            return this.marginResId(horizontalMarginId, horizontalMarginId);
        }

        public Builder marginProvider(MarginProvider provider) {
            this.mMarginProvider = provider;
            return this;
        }

        public HorizontalDividerItemDecoration build() {
            this.checkBuilderParams();
            return new HorizontalDividerItemDecoration(this);
        }
    }

    public static interface MarginProvider {
        public int dividerLeftMargin(int var1, RecyclerView var2);

        public int dividerRightMargin(int var1, RecyclerView var2);
    }
}

