/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.annotation.TargetApi;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.marshalchen.ultimaterecyclerview.UltimateRecyclerView;
import com.marshalchen.ultimaterecyclerview.itemTouchHelper.ItemTouchHelperAdapter;
import com.marshalchen.ultimaterecyclerview.stickyheadersrecyclerview.StickyRecyclerHeadersAdapter;
import java.util.Collections;
import java.util.List;

public abstract class UltimateViewAdapter<VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH>
implements StickyRecyclerHeadersAdapter<RecyclerView.ViewHolder>,
ItemTouchHelperAdapter {
    protected View customLoadMoreView = null;
    protected UltimateRecyclerView.CustomRelativeWrapper customHeaderView = null;
    public boolean isLoadMoreChanged = false;
    protected OnStartDragListener mDragStartListener = null;

    public void setCustomHeaderView(UltimateRecyclerView.CustomRelativeWrapper customHeaderView) {
        this.customHeaderView = customHeaderView;
    }

    public UltimateRecyclerView.CustomRelativeWrapper getCustomHeaderView() {
        return this.customHeaderView;
    }

    public VH onCreateViewHolder(ViewGroup parent2, int viewType) {
        if (viewType == 2) {
            VH viewHolder = this.getViewHolder(this.customLoadMoreView);
            if (this.getAdapterItemCount() == 0) {
                ((RecyclerView.ViewHolder)viewHolder).itemView.setVisibility(8);
            }
            return viewHolder;
        }
        if (viewType == 1) {
            if (this.customHeaderView != null) {
                return this.getViewHolder((View)this.customHeaderView);
            }
        } else if (viewType == 3) {
            VH viewHolder = this.getViewHolder(this.customLoadMoreView);
            if (this.getAdapterItemCount() == 0) {
                ((RecyclerView.ViewHolder)viewHolder).itemView.setVisibility(8);
            }
            return viewHolder;
        }
        return this.onCreateViewHolder(parent2);
    }

    public abstract VH getViewHolder(View var1);

    public abstract VH onCreateViewHolder(ViewGroup var1);

    public void setCustomLoadMoreView(View customview) {
        this.customLoadMoreView = customview;
    }

    public void swipeCustomLoadMoreView(View customview) {
        this.customLoadMoreView = customview;
        this.isLoadMoreChanged = true;
    }

    public View getCustomLoadMoreView() {
        return this.customLoadMoreView;
    }

    public int getItemViewType(int position) {
        if (position == this.getItemCount() - 1 && this.customLoadMoreView != null) {
            if (this.isLoadMoreChanged) {
                return 3;
            }
            return 2;
        }
        if (position == 0 && this.customHeaderView != null) {
            return 1;
        }
        return 0;
    }

    protected boolean hasHeaderView() {
        return this.customHeaderView != null;
    }

    @Override
    public int getItemCount() {
        int headerOrFooter = 0;
        if (this.customHeaderView != null) {
            ++headerOrFooter;
        }
        if (this.customLoadMoreView != null) {
            ++headerOrFooter;
        }
        return this.getAdapterItemCount() + headerOrFooter;
    }

    public abstract int getAdapterItemCount();

    public void toggleSelection(int pos) {
        this.notifyItemChanged(pos);
    }

    public void clearSelection(int pos) {
        this.notifyItemChanged(pos);
    }

    public void setSelected(int pos) {
        this.notifyItemChanged(pos);
    }

    public void swapPositions(List<?> list, int from, int to) {
        if (this.customHeaderView != null) {
            --from;
            --to;
        }
        Collections.swap(list, from, to);
    }

    public <T> void insert(List<T> list, T object, int position) {
        list.add(position, object);
        if (this.customHeaderView != null) {
            ++position;
        }
        this.notifyItemInserted(position);
    }

    public void remove(List<?> list, int position) {
        if (list.size() > 0) {
            list.remove(this.customHeaderView != null ? position - 1 : position);
            this.notifyItemRemoved(position);
        }
    }

    public void clear(List<?> list) {
        int size = list.size();
        list.clear();
        this.notifyItemRangeRemoved(0, size);
    }

    @Override
    public long getHeaderId(int position) {
        if (this.customHeaderView != null && position == 0) {
            return -1L;
        }
        if (this.customLoadMoreView != null && position >= this.getItemCount() - 1) {
            return -1L;
        }
        if (this.getAdapterItemCount() > 0) {
            return this.generateHeaderId(position);
        }
        return -1L;
    }

    public abstract long generateHeaderId(int var1);

    @TargetApi(value=11)
    protected Animator[] getAdapterAnimations(View view, AdapterAnimationType type) {
        if (type == AdapterAnimationType.ScaleIn) {
            ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{0.5f, 1.0f});
            ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{0.5f, 1.0f});
            return new ObjectAnimator[]{scaleX, scaleY};
        }
        if (type == AdapterAnimationType.AlphaIn) {
            return new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.5f, 1.0f})};
        }
        if (type == AdapterAnimationType.SlideInBottom) {
            return new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{view.getMeasuredHeight(), 0.0f})};
        }
        if (type == AdapterAnimationType.SlideInLeft) {
            return new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{-view.getRootView().getWidth(), 0.0f})};
        }
        if (type == AdapterAnimationType.SlideInRight) {
            return new Animator[]{ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{view.getRootView().getWidth(), 0.0f})};
        }
        return null;
    }

    @Override
    public void onItemMove(int fromPosition, int toPosition) {
        this.notifyItemMoved(fromPosition, toPosition);
    }

    @Override
    public void onItemDismiss(int position) {
        this.notifyDataSetChanged();
    }

    public static interface OnStartDragListener {
        public void onStartDrag(RecyclerView.ViewHolder var1);
    }

    protected static enum AdapterAnimationType {
        AlphaIn,
        SlideInBottom,
        ScaleIn,
        SlideInLeft,
        SlideInRight;

    }

    protected class VIEW_TYPES {
        public static final int NORMAL = 0;
        public static final int HEADER = 1;
        public static final int FOOTER = 2;
        public static final int CHANGED_FOOTER = 3;

        protected VIEW_TYPES() {
        }
    }
}

