/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;

public class CustomLinearLayoutManager
extends LinearLayoutManager {
    private int[] mMeasuredDimension = new int[2];

    public CustomLinearLayoutManager(Context context, int orientation, boolean reverseLayout) {
        super(context, orientation, reverseLayout);
    }

    public void onMeasure(RecyclerView.Recycler recycler, RecyclerView.State state, int widthSpec, int heightSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightSpec);
        int width = 0;
        int height = 0;
        for (int i = 0; i < this.getItemCount(); ++i) {
            this.measureScrapChild(recycler, i, View.MeasureSpec.makeMeasureSpec((int)i, (int)0), View.MeasureSpec.makeMeasureSpec((int)i, (int)0), this.mMeasuredDimension);
            if (this.getOrientation() == 0) {
                width += this.mMeasuredDimension[0];
                if (i != 0) continue;
                height = this.mMeasuredDimension[1];
                continue;
            }
            height += this.mMeasuredDimension[1];
            if (i != 0) continue;
            width = this.mMeasuredDimension[0];
        }
        switch (widthMode) {
            case 0x40000000: {
                width = widthSize;
            }
        }
        switch (heightMode) {
            case 0x40000000: {
                height = heightSize;
            }
        }
        this.setMeasuredDimension(width, height);
    }

    private void measureScrapChild(RecyclerView.Recycler recycler, int position, int widthSpec, int heightSpec, int[] measuredDimension) {
        View view = recycler.getViewForPosition(position);
        if (view != null) {
            RecyclerView.LayoutParams p = (RecyclerView.LayoutParams)view.getLayoutParams();
            int childWidthSpec = ViewGroup.getChildMeasureSpec((int)widthSpec, (int)(this.getPaddingLeft() + this.getPaddingRight()), (int)p.width);
            int childHeightSpec = ViewGroup.getChildMeasureSpec((int)heightSpec, (int)(this.getPaddingTop() + this.getPaddingBottom()), (int)p.height);
            view.measure(childWidthSpec, childHeightSpec);
            measuredDimension[0] = view.getMeasuredWidth() + p.leftMargin + p.rightMargin;
            measuredDimension[1] = view.getMeasuredHeight() + p.bottomMargin + p.topMargin;
            recycler.recycleView(view);
        }
    }
}

