/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.marshalchen.ultimaterecyclerview.UltimateRecyclerviewViewHolder;
import com.marshalchen.ultimaterecyclerview.UltimateViewAdapter;
import java.util.List;

public abstract class AdmobAdapter<Adv extends ViewGroup, T, V extends UltimateRecyclerviewViewHolder>
extends UltimateViewAdapter<UltimateRecyclerviewViewHolder> {
    protected final Adv advertise_view;
    protected int adfrequency;
    protected boolean once;
    protected List<T> list;
    protected AdviewListener adviewlistener;
    public static final int POSITION_ON_AD = -1;

    public AdmobAdapter(Adv adview, boolean insertOnce, int setInterval, List<T> L) {
        this(adview, insertOnce, setInterval, L, null);
    }

    public AdmobAdapter(Adv adview, boolean insertOnce, int setInterval, List<T> L, AdviewListener listener) {
        this.advertise_view = adview;
        for (int i = 0; i < this.advertise_view.getChildCount(); ++i) {
            this.advertise_view.getChildAt(i).setFocusable(false);
        }
        this.advertise_view.setFocusable(false);
        this.once = insertOnce;
        this.adfrequency = setInterval + 1;
        this.list = L;
    }

    protected abstract int getNormalLayoutResId();

    protected abstract V newViewHolder(View var1);

    @Override
    public UltimateRecyclerviewViewHolder onCreateViewHolder(ViewGroup parent2) {
        View v = LayoutInflater.from((Context)parent2.getContext()).inflate(this.getNormalLayoutResId(), parent2, false);
        return this.newViewHolder(v);
    }

    @Override
    public UltimateRecyclerviewViewHolder onCreateViewHolder(ViewGroup parent2, int viewType) {
        if (viewType == 4) {
            UltimateRecyclerviewViewHolder adview_holder;
            if (this.adviewlistener != null) {
                try {
                    adview_holder = new AdHolder(this.adviewlistener);
                }
                catch (NullPointerException e) {
                    adview_holder = new UltimateRecyclerviewViewHolder((View)this.advertise_view);
                }
                catch (Exception e) {
                    adview_holder = new UltimateRecyclerviewViewHolder((View)this.advertise_view);
                }
            } else {
                adview_holder = new UltimateRecyclerviewViewHolder((View)this.advertise_view);
            }
            return adview_holder;
        }
        return (UltimateRecyclerviewViewHolder)super.onCreateViewHolder(parent2, viewType);
    }

    @Override
    public int getItemViewType(int position) {
        int type = super.getItemViewType(position);
        if (type == 0) {
            if (!this.once) {
                if (position > 0 && this.isPosOnAdView(position)) {
                    return 4;
                }
                return type;
            }
            if (this.isPosOnAdView(position) && this.adfrequency == position + 1) {
                return 4;
            }
            return type;
        }
        return type;
    }

    @Override
    public int getAdapterItemCount() {
        return this.list.size();
    }

    @Override
    public int getItemCount() {
        int base = super.getItemCount();
        if (this.once) {
            if (this.adfrequency > 0) {
                return base + 1;
            }
            return base;
        }
        int check_sum = (this.adfrequency > 0 ? this.atAdPos(base) : 0) + base;
        Log.d((String)"getItemCountE2", (String)(check_sum + ""));
        return check_sum;
    }

    @Override
    public <T> void insert(List<T> list, T object, int first_insert_data_pos) {
        try {
            list.add(first_insert_data_pos, object);
            int offset = this.getReverseDataArrayPosition(first_insert_data_pos);
            if (this.isPosOnAdView(offset) && first_insert_data_pos > 0) {
                this.notifyItemRangeChanged(offset, offset + 1);
            } else {
                this.notifyItemInserted(offset);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.d((String)"admobErrorMr3", (String)e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            Log.d((String)"admobErrorMr3", (String)e.getMessage());
        }
    }

    @Override
    public <T> void insert(List<T> original_list, List<T> new_list, int first_insert_pos) {
        try {
            original_list.addAll(first_insert_pos, new_list);
            int view_pos_1 = this.getReverseDataArrayPosition(first_insert_pos);
            int view_pos_2 = this.getReverseDataArrayPosition(first_insert_pos + new_list.size());
            this.notifyItemRangeChanged(view_pos_1, view_pos_2);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.d((String)"admobErrorMr3", (String)e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            Log.d((String)"admobErrorMr3", (String)e.getMessage());
        }
    }

    public void insert(T object) {
        this.insert(this.list, object, this.list.size());
    }

    public void insert(List<T> newlist) {
        this.insert(this.list, newlist, this.list.size());
    }

    public void removeAll() {
        this.list.clear();
        this.notifyDataSetChanged();
    }

    @Override
    public void remove(List<?> list, int position) {
        try {
            int offset;
            if (list.size() > 0 && position < list.size()) {
                list.remove(position);
                offset = this.getReverseDataArrayPosition(position);
                this.notifyItemRemoved(offset);
                if (offset > 1 && this.isPosOnAdView(offset) && position > 0) {
                    this.notifyItemRemoved(offset - 1);
                }
            } else {
                throw new ArrayIndexOutOfBoundsException("no data or the remove position is not exist p:" + position + ", list size:" + list.size());
            }
            Log.d((String)"normaladmob", (String)("offset final: " + offset));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.d((String)"admobError r1", (String)e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            Log.d((String)"admobError r2", (String)e.getMessage());
        }
    }

    protected boolean onActionToBindData(int pos, List<T> list) {
        int getType = this.getItemViewType(pos);
        if (pos < this.getItemCount() && getType == 0) {
            if (this.customHeaderView != null) {
                return pos <= list.size() && pos > 0;
            }
            return pos < list.size();
        }
        return false;
    }

    protected T getItem(int pos) {
        return this.list.get(this.getDataArrayPosition(pos));
    }

    protected int getDataArrayPosition(int pos) {
        int shift = 0;
        if (this.customHeaderView != null) {
            --shift;
        }
        if (this.adfrequency > 0) {
            if (this.once) {
                if (pos >= this.adfrequency) {
                    --shift;
                }
            } else {
                shift -= this.atAdPos(pos);
            }
        }
        return pos + shift;
    }

    protected int getReverseDataArrayPosition(int dataPos) {
        int shift = 0;
        if (this.customHeaderView != null) {
            ++shift;
        }
        if (this.adfrequency > 0) {
            if (this.once) {
                if (dataPos >= this.adfrequency) {
                    ++shift;
                }
            } else {
                shift += this.atAdPos(dataPos);
            }
        }
        return dataPos + shift;
    }

    public boolean isPosOnAdView(int pos) {
        int zero_for_admob_selection = (pos + 1) % this.adfrequency;
        return zero_for_admob_selection == 0;
    }

    public int atAdPos(int pos) {
        int take_int = (int)Math.floor((pos + 1) / this.adfrequency);
        Log.d((String)"atAdPosE2", (String)(take_int + ""));
        return take_int;
    }

    public int getFinalShiftPosition(int pos) {
        return this.getDataArrayPosition(pos);
    }

    public static class AdHolder
    extends UltimateRecyclerviewViewHolder {
        public AdHolder(AdviewListener adviewlistener) {
            super((View)adviewlistener.onGenerateAdview());
        }
    }

    protected class VIEW_TYPES
    extends UltimateViewAdapter.VIEW_TYPES {
        public static final int ADVIEW = 4;

        protected VIEW_TYPES() {
            super(AdmobAdapter.this);
        }
    }

    public static interface AdviewListener<Adv extends ViewGroup> {
        public Adv onGenerateAdview();
    }
}

