/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.divideritemdecoration;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.marshalchen.ultimaterecyclerview.divideritemdecoration.FlexibleDividerDecoration;

public class VerticalDividerItemDecoration
extends FlexibleDividerDecoration {
    private MarginProvider mMarginProvider;

    private VerticalDividerItemDecoration(Builder builder) {
        super(builder);
        this.mMarginProvider = builder.mMarginProvider;
    }

    @Override
    protected Rect getDividerBound(int position, RecyclerView parent, View child) {
        Rect bounds = new Rect(0, 0, 0, 0);
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
        bounds.top = parent.getPaddingTop() + this.mMarginProvider.dividerTopMargin(position, parent);
        bounds.bottom = parent.getHeight() - parent.getPaddingBottom() - this.mMarginProvider.dividerBottomMargin(position, parent);
        int dividerSize = this.getDividerSize(position, parent);
        if (this.mDividerType == FlexibleDividerDecoration.DividerType.DRAWABLE) {
            bounds.left = child.getRight() + params.leftMargin;
            bounds.right = bounds.left + dividerSize;
        } else {
            bounds.right = bounds.left = child.getRight() + params.leftMargin + dividerSize / 2;
        }
        return bounds;
    }

    @Override
    protected void setItemOffsets(Rect outRect, int position, RecyclerView parent) {
        int size = this.getDividerSize(position, parent) / 2;
        if (position == 0) {
            outRect.set(0, 0, size, 0);
        } else {
            int lastItemSize = this.getDividerSize(position - 1, parent) / 2;
            if (position == parent.getLayoutManager().getItemCount() - 1) {
                outRect.set(lastItemSize, 0, 0, 0);
            } else {
                outRect.set(lastItemSize, 0, size, 0);
            }
        }
    }

    private int getDividerSize(int position, RecyclerView parent) {
        if (this.mPaintProvider != null) {
            return (int)this.mPaintProvider.dividerPaint(position, parent).getStrokeWidth();
        }
        if (this.mSizeProvider != null) {
            return this.mSizeProvider.dividerSize(position, parent);
        }
        if (this.mDrawableProvider != null) {
            Drawable drawable2 = this.mDrawableProvider.drawableProvider(position, parent);
            return drawable2.getIntrinsicWidth();
        }
        throw new RuntimeException("failed to get size");
    }

    public static class Builder
    extends FlexibleDividerDecoration.Builder<Builder> {
        private MarginProvider mMarginProvider = new MarginProvider(){

            @Override
            public int dividerTopMargin(int position, RecyclerView parent) {
                return 0;
            }

            @Override
            public int dividerBottomMargin(int position, RecyclerView parent) {
                return 0;
            }
        };

        public Builder(Context context) {
            super(context);
        }

        public Builder margin(final int topMargin, final int bottomMargin) {
            return this.marginProvider(new MarginProvider(){

                @Override
                public int dividerTopMargin(int position, RecyclerView parent) {
                    return topMargin;
                }

                @Override
                public int dividerBottomMargin(int position, RecyclerView parent) {
                    return bottomMargin;
                }
            });
        }

        public Builder marginProvider(MarginProvider provider) {
            this.mMarginProvider = provider;
            return this;
        }

        public VerticalDividerItemDecoration build() {
            this.checkBuilderParams();
            return new VerticalDividerItemDecoration(this);
        }
    }

    public static interface MarginProvider {
        public int dividerTopMargin(int var1, RecyclerView var2);

        public int dividerBottomMargin(int var1, RecyclerView var2);
    }
}

