/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview.divideritemdecoration;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.marshalchen.ultimaterecyclerview.divideritemdecoration.FlexibleDividerDecoration;

public class HorizontalDividerItemDecoration
extends FlexibleDividerDecoration {
    private MarginProvider mMarginProvider;

    private HorizontalDividerItemDecoration(Builder builder) {
        super(builder);
        this.mMarginProvider = builder.mMarginProvider;
    }

    @Override
    protected Rect getDividerBound(int position, RecyclerView parent, View child) {
        Rect bounds = new Rect(0, 0, 0, 0);
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
        bounds.left = parent.getPaddingLeft() + this.mMarginProvider.dividerLeftMargin(position, parent);
        bounds.right = parent.getWidth() - parent.getPaddingRight() - this.mMarginProvider.dividerRightMargin(position, parent);
        int dividerSize = this.getDividerSize(position, parent);
        if (this.mDividerType == FlexibleDividerDecoration.DividerType.DRAWABLE) {
            bounds.top = child.getBottom() + params.topMargin;
            bounds.bottom = bounds.top + dividerSize;
        } else {
            bounds.bottom = bounds.top = child.getBottom() + params.topMargin + dividerSize / 2;
        }
        return bounds;
    }

    @Override
    protected void setItemOffsets(Rect outRect, int position, RecyclerView parent) {
        int size = this.getDividerSize(position, parent) / 2;
        if (position == 0) {
            outRect.set(0, 0, 0, size);
        } else {
            int lastItemSize = this.getDividerSize(position - 1, parent) / 2;
            if (position == parent.getLayoutManager().getItemCount() - 1) {
                outRect.set(0, lastItemSize, 0, 0);
            } else {
                outRect.set(0, lastItemSize, 0, size);
            }
        }
    }

    private int getDividerSize(int position, RecyclerView parent) {
        if (this.mPaintProvider != null) {
            return (int)this.mPaintProvider.dividerPaint(position, parent).getStrokeWidth();
        }
        if (this.mSizeProvider != null) {
            return this.mSizeProvider.dividerSize(position, parent);
        }
        if (this.mDrawableProvider != null) {
            Drawable drawable2 = this.mDrawableProvider.drawableProvider(position, parent);
            return drawable2.getIntrinsicHeight();
        }
        throw new RuntimeException("failed to get size");
    }

    public static class Builder
    extends FlexibleDividerDecoration.Builder<Builder> {
        private MarginProvider mMarginProvider = new MarginProvider(){

            @Override
            public int dividerLeftMargin(int position, RecyclerView parent) {
                return 0;
            }

            @Override
            public int dividerRightMargin(int position, RecyclerView parent) {
                return 0;
            }
        };

        public Builder(Context context) {
            super(context);
        }

        public Builder margin(final int leftMargin, final int rightMargin) {
            return this.marginProvider(new MarginProvider(){

                @Override
                public int dividerLeftMargin(int position, RecyclerView parent) {
                    return leftMargin;
                }

                @Override
                public int dividerRightMargin(int position, RecyclerView parent) {
                    return rightMargin;
                }
            });
        }

        public Builder marginProvider(MarginProvider provider) {
            this.mMarginProvider = provider;
            return this;
        }

        public HorizontalDividerItemDecoration build() {
            this.checkBuilderParams();
            return new HorizontalDividerItemDecoration(this);
        }
    }

    public static interface MarginProvider {
        public int dividerLeftMargin(int var1, RecyclerView var2);

        public int dividerRightMargin(int var1, RecyclerView var2);
    }
}

