/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.support.v7.widget.Toolbar;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.marshalchen.ultimaterecyclerview.Logs;
import com.marshalchen.ultimaterecyclerview.ObservableScrollState;
import com.marshalchen.ultimaterecyclerview.ObservableScrollViewCallbacks;
import com.marshalchen.ultimaterecyclerview.R;
import com.marshalchen.ultimaterecyclerview.SwipeToDismissTouchListener;
import com.marshalchen.ultimaterecyclerview.UltimateViewAdapter;
import com.marshalchen.ultimaterecyclerview.ui.DividerItemDecoration;
import com.marshalchen.ultimaterecyclerview.ui.floatingactionbutton.FloatingActionsMenu;
import com.nineoldandroids.animation.ValueAnimator;
import com.nineoldandroids.view.ViewHelper;

public class UltimateRecyclerView
extends FrameLayout {
    public RecyclerView mRecyclerView;
    SwipeRefreshLayout mSwipeRefreshLayout;
    public FloatingActionsMenu floatingActionButton;
    private OnLoadMoreListener onLoadMoreListener;
    private int lastVisibleItemPosition;
    protected RecyclerView.OnScrollListener mOnScrollListener;
    protected LAYOUT_MANAGER_TYPE layoutManagerType;
    private boolean isLoadingMore = false;
    private int currentScrollState = 0;
    protected int mPadding;
    protected int mPaddingTop;
    protected int mPaddingBottom;
    protected int mPaddingLeft;
    protected int mPaddingRight;
    protected boolean mClipToPadding;
    private UltimateViewAdapter mAdapter;
    private ObservableScrollState mObservableScrollState;
    private ObservableScrollViewCallbacks mCallbacks;
    private SparseIntArray mChildrenHeights = new SparseIntArray();
    private int mPrevFirstVisiblePosition;
    private int mPrevFirstVisibleChildHeight = -1;
    private int mPrevScrolledChildrenHeight;
    private int mPrevScrollY;
    private int mScrollY;
    private boolean mFirstScroll;
    private boolean mDragging;
    private boolean mIntercepted;
    private CustomRelativeWrapper mHeader;
    private int mTotalYScrolled;
    private final float SCROLL_MULTIPLIER = 0.5f;
    private OnParallaxScroll mParallaxScroll;

    public UltimateRecyclerView(Context context) {
        super(context);
        this.initViews();
    }

    public UltimateRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(attrs);
        this.initViews();
    }

    public UltimateRecyclerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(attrs);
        this.initViews();
    }

    private void initViews() {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.ultimate_recycler_view_layout, (ViewGroup)this);
        this.mRecyclerView = (RecyclerView)view.findViewById(R.id.ultimate_list);
        this.mSwipeRefreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.swipe_refresh_layout);
        this.mSwipeRefreshLayout.setEnabled(false);
        this.mSwipeRefreshLayout.setColorSchemeResources(new int[]{17170459, 17170452, 17170456, 0x1060016});
        if (this.mRecyclerView != null) {
            this.mRecyclerView.setClipToPadding(this.mClipToPadding);
            if ((float)this.mPadding != -1.1f) {
                this.mRecyclerView.setPadding(this.mPadding, this.mPadding, this.mPadding, this.mPadding);
            } else {
                this.mRecyclerView.setPadding(this.mPaddingLeft, this.mPaddingTop, this.mPaddingRight, this.mPaddingBottom);
            }
        }
        this.floatingActionButton = (FloatingActionsMenu)view.findViewById(R.id.floatingButton);
        this.setDefaultScrollListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.UltimateRecyclerview);
        try {
            this.mPadding = (int)typedArray.getDimension(R.styleable.UltimateRecyclerview_recyclerviewPadding, -1.1f);
            this.mPaddingTop = (int)typedArray.getDimension(R.styleable.UltimateRecyclerview_recyclerviewPaddingTop, 0.0f);
            this.mPaddingBottom = (int)typedArray.getDimension(R.styleable.UltimateRecyclerview_recyclerviewPaddingBottom, 0.0f);
            this.mPaddingLeft = (int)typedArray.getDimension(R.styleable.UltimateRecyclerview_recyclerviewPaddingLeft, 0.0f);
            this.mPaddingRight = (int)typedArray.getDimension(R.styleable.UltimateRecyclerview_recyclerviewPaddingRight, 0.0f);
            this.mClipToPadding = typedArray.getBoolean(R.styleable.UltimateRecyclerview_recyclerviewClipToPadding, false);
        }
        finally {
            typedArray.recycle();
        }
    }

    public void setSwipeToDismissCallback(SwipeToDismissTouchListener.DismissCallbacks dismissCallbacks) {
        int[] notToDismiss = null;
        if (this.mAdapter.getCustomHeaderView() != null) {
            notToDismiss = new int[]{0};
        }
        this.mRecyclerView.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new SwipeToDismissTouchListener(this.mRecyclerView, dismissCallbacks, notToDismiss));
    }

    void setDefaultScrollListener() {
        this.mOnScrollListener = new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (UltimateRecyclerView.this.mHeader != null) {
                    UltimateRecyclerView.this.mTotalYScrolled += dy;
                    UltimateRecyclerView.this.translateHeader(UltimateRecyclerView.this.mTotalYScrolled);
                }
                UltimateRecyclerView.this.enableShoworHideToolbarAndFloatingButton(recyclerView);
            }
        };
        this.mRecyclerView.setOnScrollListener(this.mOnScrollListener);
    }

    public void enableLoadmore() {
        this.mOnScrollListener = new RecyclerView.OnScrollListener(){
            private int[] lastPositions;

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (UltimateRecyclerView.this.mHeader != null) {
                    UltimateRecyclerView.this.mTotalYScrolled += dy;
                    UltimateRecyclerView.this.translateHeader(UltimateRecyclerView.this.mTotalYScrolled);
                }
                RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                int visibleItemCount = layoutManager.getChildCount();
                int totalItemCount = layoutManager.getItemCount();
                if (UltimateRecyclerView.this.layoutManagerType == null) {
                    if (layoutManager instanceof LinearLayoutManager) {
                        UltimateRecyclerView.this.layoutManagerType = LAYOUT_MANAGER_TYPE.LINEAR;
                    } else if (layoutManager instanceof GridLayoutManager) {
                        UltimateRecyclerView.this.layoutManagerType = LAYOUT_MANAGER_TYPE.GRID;
                    } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                        UltimateRecyclerView.this.layoutManagerType = LAYOUT_MANAGER_TYPE.STAGGERED_GRID;
                    } else {
                        throw new RuntimeException("Unsupported LayoutManager used. Valid ones are LinearLayoutManager, GridLayoutManager and StaggeredGridLayoutManager");
                    }
                }
                switch (UltimateRecyclerView.this.layoutManagerType) {
                    case LINEAR: {
                        UltimateRecyclerView.this.lastVisibleItemPosition = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
                        break;
                    }
                    case GRID: {
                        UltimateRecyclerView.this.lastVisibleItemPosition = ((GridLayoutManager)layoutManager).findLastVisibleItemPosition();
                        break;
                    }
                    case STAGGERED_GRID: {
                        StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
                        if (this.lastPositions == null) {
                            this.lastPositions = new int[staggeredGridLayoutManager.getSpanCount()];
                        }
                        staggeredGridLayoutManager.findLastVisibleItemPositions(this.lastPositions);
                        UltimateRecyclerView.this.lastVisibleItemPosition = UltimateRecyclerView.this.findMax(this.lastPositions);
                    }
                }
                UltimateRecyclerView.this.enableShoworHideToolbarAndFloatingButton(recyclerView);
            }

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                UltimateRecyclerView.this.currentScrollState = newState;
                RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                int visibleItemCount = layoutManager.getChildCount();
                int totalItemCount = layoutManager.getItemCount();
                if (visibleItemCount > 0 && UltimateRecyclerView.this.currentScrollState == 0 && UltimateRecyclerView.this.lastVisibleItemPosition >= totalItemCount - 1 && !UltimateRecyclerView.this.isLoadingMore) {
                    UltimateRecyclerView.this.isLoadingMore = true;
                    if (UltimateRecyclerView.this.onLoadMoreListener != null) {
                        UltimateRecyclerView.this.isLoadingMore = false;
                        UltimateRecyclerView.this.onLoadMoreListener.loadMore(UltimateRecyclerView.this.mRecyclerView.getAdapter().getItemCount(), UltimateRecyclerView.this.lastVisibleItemPosition);
                    }
                }
            }
        };
        this.mRecyclerView.setOnScrollListener(this.mOnScrollListener);
        if (this.mAdapter.getCustomLoadMoreView() == null) {
            this.mAdapter.setCustomLoadMoreView(LayoutInflater.from((Context)this.getContext()).inflate(R.layout.bottom_progressbar, null));
        }
    }

    protected void enableShoworHideToolbarAndFloatingButton(RecyclerView recyclerView) {
        if (this.mCallbacks != null && this.getChildCount() > 0) {
            int firstVisiblePosition = recyclerView.getChildPosition(recyclerView.getChildAt(0));
            int lastVisiblePosition = recyclerView.getChildPosition(recyclerView.getChildAt(this.getChildCount() - 1));
            int i = firstVisiblePosition;
            int j = 0;
            while (i <= lastVisiblePosition) {
                if (this.mChildrenHeights.indexOfKey(i) < 0 || recyclerView.getChildAt(j).getHeight() != this.mChildrenHeights.get(i)) {
                    this.mChildrenHeights.put(i, recyclerView.getChildAt(j).getHeight());
                }
                ++i;
                ++j;
            }
            View firstVisibleChild = recyclerView.getChildAt(0);
            if (firstVisibleChild != null) {
                int skippedChildrenHeight;
                if (this.mPrevFirstVisiblePosition < firstVisiblePosition) {
                    skippedChildrenHeight = 0;
                    if (firstVisiblePosition - this.mPrevFirstVisiblePosition != 1) {
                        for (int i2 = firstVisiblePosition - 1; i2 > this.mPrevFirstVisiblePosition; --i2) {
                            if (0 < this.mChildrenHeights.indexOfKey(i2)) {
                                skippedChildrenHeight += this.mChildrenHeights.get(i2);
                                continue;
                            }
                            skippedChildrenHeight += firstVisibleChild.getHeight();
                        }
                    }
                    this.mPrevScrolledChildrenHeight += this.mPrevFirstVisibleChildHeight + skippedChildrenHeight;
                    this.mPrevFirstVisibleChildHeight = firstVisibleChild.getHeight();
                } else if (firstVisiblePosition < this.mPrevFirstVisiblePosition) {
                    skippedChildrenHeight = 0;
                    if (this.mPrevFirstVisiblePosition - firstVisiblePosition != 1) {
                        for (int i3 = this.mPrevFirstVisiblePosition - 1; i3 > firstVisiblePosition; --i3) {
                            if (0 < this.mChildrenHeights.indexOfKey(i3)) {
                                skippedChildrenHeight += this.mChildrenHeights.get(i3);
                                continue;
                            }
                            skippedChildrenHeight += firstVisibleChild.getHeight();
                        }
                    }
                    this.mPrevScrolledChildrenHeight -= firstVisibleChild.getHeight() + skippedChildrenHeight;
                    this.mPrevFirstVisibleChildHeight = firstVisibleChild.getHeight();
                } else if (firstVisiblePosition == 0) {
                    this.mPrevFirstVisibleChildHeight = firstVisibleChild.getHeight();
                }
                if (this.mPrevFirstVisibleChildHeight < 0) {
                    this.mPrevFirstVisibleChildHeight = 0;
                }
                this.mScrollY = this.mPrevScrolledChildrenHeight - firstVisibleChild.getTop();
                this.mPrevFirstVisiblePosition = firstVisiblePosition;
                this.mCallbacks.onScrollChanged(this.mScrollY, this.mFirstScroll, this.mDragging);
                if (this.mFirstScroll) {
                    this.mFirstScroll = false;
                }
                this.mObservableScrollState = this.mPrevScrollY < this.mScrollY ? ObservableScrollState.UP : (this.mScrollY < this.mPrevScrollY ? ObservableScrollState.DOWN : ObservableScrollState.STOP);
                this.mPrevScrollY = this.mScrollY;
            }
        }
    }

    public void setOnScrollListener(RecyclerView.OnScrollListener customOnScrollListener) {
        this.mRecyclerView.setOnScrollListener(customOnScrollListener);
    }

    public void addItemDividerDecoration(Context context) {
        DividerItemDecoration itemDecoration = new DividerItemDecoration(context, 1);
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)itemDecoration);
    }

    public void addItemDecoration(RecyclerView.ItemDecoration itemDecoration) {
        this.mRecyclerView.addItemDecoration(itemDecoration);
    }

    public void addItemDecoration(RecyclerView.ItemDecoration itemDecoration, int index) {
        this.mRecyclerView.addItemDecoration(itemDecoration, index);
    }

    public void setItemAnimator(RecyclerView.ItemAnimator animator) {
        this.mRecyclerView.setItemAnimator(animator);
    }

    public RecyclerView.ItemAnimator getItemAnimator() {
        return this.mRecyclerView.getItemAnimator();
    }

    public void setOnRefreshListener(SwipeRefreshLayout.OnRefreshListener listener) {
        this.mSwipeRefreshLayout.setEnabled(true);
        this.mSwipeRefreshLayout.setOnRefreshListener(listener);
    }

    public void setOnLoadMoreListener(OnLoadMoreListener onLoadMoreListener) {
        this.onLoadMoreListener = onLoadMoreListener;
    }

    public void setLayoutManager(RecyclerView.LayoutManager manager) {
        this.mRecyclerView.setLayoutManager(manager);
    }

    public void setAdapter(UltimateViewAdapter adapter) {
        this.mAdapter = adapter;
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mSwipeRefreshLayout.setRefreshing(false);
        this.mAdapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onItemRangeChanged(int positionStart, int itemCount) {
                super.onItemRangeChanged(positionStart, itemCount);
                this.update();
            }

            public void onItemRangeInserted(int positionStart, int itemCount) {
                super.onItemRangeInserted(positionStart, itemCount);
                this.update();
            }

            public void onItemRangeRemoved(int positionStart, int itemCount) {
                super.onItemRangeRemoved(positionStart, itemCount);
                this.update();
            }

            public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                super.onItemRangeMoved(fromPosition, toPosition, itemCount);
                this.update();
            }

            public void onChanged() {
                super.onChanged();
                this.update();
            }

            private void update() {
                UltimateRecyclerView.this.isLoadingMore = false;
                UltimateRecyclerView.this.mSwipeRefreshLayout.setRefreshing(false);
            }
        });
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        this.mRecyclerView.setAdapter(adapter);
        this.mSwipeRefreshLayout.setRefreshing(false);
        adapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onItemRangeChanged(int positionStart, int itemCount) {
                super.onItemRangeChanged(positionStart, itemCount);
                this.update();
            }

            public void onItemRangeInserted(int positionStart, int itemCount) {
                super.onItemRangeInserted(positionStart, itemCount);
                this.update();
            }

            public void onItemRangeRemoved(int positionStart, int itemCount) {
                super.onItemRangeRemoved(positionStart, itemCount);
                this.update();
            }

            public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                super.onItemRangeMoved(fromPosition, toPosition, itemCount);
                this.update();
            }

            public void onChanged() {
                super.onChanged();
                this.update();
            }

            private void update() {
                UltimateRecyclerView.this.isLoadingMore = false;
                UltimateRecyclerView.this.mSwipeRefreshLayout.setRefreshing(false);
            }
        });
    }

    public void setHasFixedSize(boolean hasFixedSize) {
        this.mRecyclerView.setHasFixedSize(hasFixedSize);
    }

    public void setRefreshing(boolean refreshing) {
        this.mSwipeRefreshLayout.setRefreshing(refreshing);
    }

    public void enableSwipeRefresh(boolean isSwipeRefresh) {
        this.mSwipeRefreshLayout.setEnabled(isSwipeRefresh);
    }

    private int findMax(int[] lastPositions) {
        int max = Integer.MIN_VALUE;
        for (int value : lastPositions) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public void setParallaxHeader(View header) {
        this.mHeader = new CustomRelativeWrapper(header.getContext());
        this.mHeader.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.mHeader.addView(header, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.mAdapter.setCustomHeaderView(this.mHeader);
    }

    public void setOnParallaxScroll(OnParallaxScroll parallaxScroll) {
        this.mParallaxScroll = parallaxScroll;
        this.mParallaxScroll.onParallaxScroll(0.0f, 0.0f, (View)this.mHeader);
    }

    private void translateHeader(float of) {
        float ofCalculated = of * 0.5f;
        if (Build.VERSION.SDK_INT >= 11) {
            this.mHeader.setTranslationY(ofCalculated);
        } else {
            TranslateAnimation anim = new TranslateAnimation(0.0f, 0.0f, ofCalculated, ofCalculated);
            anim.setFillAfter(true);
            anim.setDuration(0L);
            this.mHeader.startAnimation((Animation)anim);
        }
        this.mHeader.setClipY(Math.round(ofCalculated));
        if (this.mParallaxScroll != null) {
            float left = Math.min(1.0f, ofCalculated / ((float)this.mHeader.getHeight() * 0.5f));
            this.mParallaxScroll.onParallaxScroll(left, of, (View)this.mHeader);
        }
    }

    public void setScrollViewCallbacks(ObservableScrollViewCallbacks listener) {
        this.mCallbacks = listener;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        this.mPrevFirstVisiblePosition = ss.prevFirstVisiblePosition;
        this.mPrevFirstVisibleChildHeight = ss.prevFirstVisibleChildHeight;
        this.mPrevScrolledChildrenHeight = ss.prevScrolledChildrenHeight;
        this.mPrevScrollY = ss.prevScrollY;
        this.mScrollY = ss.scrollY;
        this.mChildrenHeights = ss.childrenHeights;
        super.onRestoreInstanceState(ss.getSuperState());
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.prevFirstVisiblePosition = this.mPrevFirstVisiblePosition;
        ss.prevFirstVisibleChildHeight = this.mPrevFirstVisibleChildHeight;
        ss.prevScrolledChildrenHeight = this.mPrevScrolledChildrenHeight;
        ss.prevScrollY = this.mPrevScrollY;
        ss.scrollY = this.mScrollY;
        ss.childrenHeights = this.mChildrenHeights;
        return ss;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mCallbacks != null) {
            switch (ev.getActionMasked()) {
                case 0: {
                    this.mDragging = true;
                    this.mFirstScroll = true;
                    this.mCallbacks.onDownMotionEvent();
                    break;
                }
                case 1: 
                case 3: {
                    this.mIntercepted = false;
                    this.mDragging = false;
                    this.mCallbacks.onUpOrCancelMotionEvent(this.mObservableScrollState);
                }
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        Logs.d("mCallbacks   " + (this.mCallbacks == null));
        if (this.mCallbacks != null) {
            switch (ev.getActionMasked()) {
                case 1: 
                case 3: {
                    this.mIntercepted = false;
                    this.mDragging = false;
                    this.mCallbacks.onUpOrCancelMotionEvent(this.mObservableScrollState);
                }
            }
        }
        return super.onTouchEvent(ev);
    }

    public boolean toolbarIsShown(Toolbar mToolbar) {
        return ViewHelper.getTranslationY((View)mToolbar) == 0.0f;
    }

    public boolean toolbarIsHidden(Toolbar mToolbar) {
        return ViewHelper.getTranslationY((View)mToolbar) == (float)(-mToolbar.getHeight());
    }

    public void showToolbar(Toolbar mToolbar, UltimateRecyclerView ultimateRecyclerView, int screenHeight) {
        this.moveToolbar(mToolbar, ultimateRecyclerView, screenHeight, 0.0f);
        this.floatingActionButton.hide(false);
    }

    public void hideToolbar(Toolbar mToolbar, UltimateRecyclerView ultimateRecyclerView, int screenHeight) {
        this.moveToolbar(mToolbar, ultimateRecyclerView, screenHeight, -mToolbar.getHeight());
        this.floatingActionButton.hide(true);
    }

    protected void moveToolbar(final Toolbar mToolbar, final UltimateRecyclerView ultimateRecyclerView, final int screenheight, float toTranslationY) {
        if (ViewHelper.getTranslationY((View)mToolbar) == toTranslationY) {
            return;
        }
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{ViewHelper.getTranslationY((View)mToolbar), toTranslationY}).setDuration(200L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float translationY = ((Float)animation.getAnimatedValue()).floatValue();
                ViewHelper.setTranslationY((View)mToolbar, (float)translationY);
                ViewHelper.setTranslationY((View)ultimateRecyclerView, (float)translationY);
                ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)ultimateRecyclerView.getLayoutParams();
                layoutParams.height = (int)(-translationY) + screenheight - layoutParams.topMargin;
                ultimateRecyclerView.requestLayout();
            }
        });
        animator.start();
    }

    static class SavedState
    implements Parcelable {
        public static final SavedState EMPTY_STATE = new SavedState(){};
        int prevFirstVisiblePosition;
        int prevFirstVisibleChildHeight = -1;
        int prevScrolledChildrenHeight;
        int prevScrollY;
        int scrollY;
        SparseIntArray childrenHeights;
        Parcelable superState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState() {
            this.superState = null;
        }

        SavedState(Parcelable superState) {
            this.superState = superState != EMPTY_STATE ? superState : null;
        }

        private SavedState(Parcel in) {
            Parcelable superState = in.readParcelable(RecyclerView.class.getClassLoader());
            this.superState = superState != null ? superState : EMPTY_STATE;
            this.prevFirstVisiblePosition = in.readInt();
            this.prevFirstVisibleChildHeight = in.readInt();
            this.prevScrolledChildrenHeight = in.readInt();
            this.prevScrollY = in.readInt();
            this.scrollY = in.readInt();
            this.childrenHeights = new SparseIntArray();
            int numOfChildren = in.readInt();
            if (0 < numOfChildren) {
                for (int i = 0; i < numOfChildren; ++i) {
                    int key = in.readInt();
                    int value = in.readInt();
                    this.childrenHeights.put(key, value);
                }
            }
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            out.writeParcelable(this.superState, flags);
            out.writeInt(this.prevFirstVisiblePosition);
            out.writeInt(this.prevFirstVisibleChildHeight);
            out.writeInt(this.prevScrolledChildrenHeight);
            out.writeInt(this.prevScrollY);
            out.writeInt(this.scrollY);
            int numOfChildren = this.childrenHeights == null ? 0 : this.childrenHeights.size();
            out.writeInt(numOfChildren);
            if (0 < numOfChildren) {
                for (int i = 0; i < numOfChildren; ++i) {
                    out.writeInt(this.childrenHeights.keyAt(i));
                    out.writeInt(this.childrenHeights.valueAt(i));
                }
            }
        }

        public Parcelable getSuperState() {
            return this.superState;
        }
    }

    public static class CustomRelativeWrapper
    extends RelativeLayout {
        private int mOffset;

        public CustomRelativeWrapper(Context context) {
            super(context);
        }

        protected void dispatchDraw(Canvas canvas) {
            canvas.clipRect(new Rect(this.getLeft(), this.getTop(), this.getRight(), this.getBottom() + this.mOffset));
            super.dispatchDraw(canvas);
        }

        public void setClipY(int offset) {
            this.mOffset = offset;
            this.invalidate();
        }
    }

    public static interface OnParallaxScroll {
        public void onParallaxScroll(float var1, float var2, View var3);
    }

    public static enum LAYOUT_MANAGER_TYPE {
        LINEAR,
        GRID,
        STAGGERED_GRID;

    }

    public static interface OnLoadMoreListener {
        public void loadMore(int var1, int var2);
    }
}

