/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SwipeToDismissTouchListener
implements RecyclerView.OnItemTouchListener {
    private final RecyclerView mRecyclerView;
    private int mSlop;
    private int mMinFlingVelocity;
    private int mMaxFlingVelocity;
    private long mAnimationTime;
    private DismissCallbacks mCallbacks;
    private int mViewWidth = 1;
    private float mDownX;
    private float mDownY;
    private boolean mSwiping;
    private int mSwipingSlop;
    private VelocityTracker mVelocityTracker;
    private float mTranslationX;
    private boolean mPaused = false;
    private View mSwipeView;
    private int mDismissCount = 0;
    private List<PendingDismissData> mPendingDismisses = new ArrayList<PendingDismissData>();
    private SwipeDirection mAllowedSwipeDirection = SwipeDirection.NONE;
    private int[] notToDismissPositionArray;

    public SwipeToDismissTouchListener(RecyclerView recyclerView, DismissCallbacks callbacks) {
        ViewConfiguration vc = ViewConfiguration.get((Context)recyclerView.getContext());
        this.mSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity() * 4;
        this.mMaxFlingVelocity = vc.getScaledMaximumFlingVelocity();
        this.mAnimationTime = recyclerView.getContext().getResources().getInteger(0x10E0000);
        this.mRecyclerView = recyclerView;
        this.mCallbacks = callbacks;
    }

    public SwipeToDismissTouchListener(RecyclerView recyclerView, DismissCallbacks callbacks, int[] notToDismiss) {
        ViewConfiguration vc = ViewConfiguration.get((Context)recyclerView.getContext());
        this.mSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity() * 4;
        this.mMaxFlingVelocity = vc.getScaledMaximumFlingVelocity();
        this.mAnimationTime = recyclerView.getContext().getResources().getInteger(0x10E0000);
        this.mRecyclerView = recyclerView;
        this.mCallbacks = callbacks;
        this.notToDismissPositionArray = notToDismiss;
    }

    public int[] getNotToDismissPositionArray() {
        return this.notToDismissPositionArray;
    }

    public void setNotToDismissPositionArray(int[] notToDismissPositionArray) {
        this.notToDismissPositionArray = notToDismissPositionArray;
    }

    public void setEnabled(boolean enabled) {
        this.mPaused = !enabled;
    }

    public void onTouchEvent(RecyclerView recyclerView, MotionEvent motionEvent) {
        motionEvent.offsetLocation(this.mTranslationX, 0.0f);
        switch (motionEvent.getActionMasked()) {
            case 1: {
                this.up(motionEvent);
                break;
            }
            case 3: {
                this.cancel();
                break;
            }
            case 2: {
                this.move(motionEvent);
            }
        }
    }

    public boolean onInterceptTouchEvent(RecyclerView view, MotionEvent motionEvent) {
        if (this.mPaused) {
            return false;
        }
        motionEvent.offsetLocation(this.mTranslationX, 0.0f);
        if (this.mViewWidth < 2) {
            this.mViewWidth = view.getWidth();
        }
        switch (motionEvent.getActionMasked()) {
            case 0: {
                return this.down(motionEvent);
            }
            case 2: {
                return this.move(motionEvent);
            }
        }
        return false;
    }

    private boolean down(MotionEvent motionEvent) {
        if (this.mPaused) {
            return false;
        }
        this.mDownX = motionEvent.getRawX();
        this.mDownY = motionEvent.getRawY();
        this.mSwipeView = this.mRecyclerView.findChildViewUnder(motionEvent.getX(), motionEvent.getY());
        if (this.mSwipeView == null) {
            return false;
        }
        int pos = this.mRecyclerView.getChildPosition(this.mSwipeView);
        if (this.notToDismissPositionArray != null && this.notToDismissPositionArray.length > 0) {
            for (int notToDismiss : this.notToDismissPositionArray) {
                if (pos != notToDismiss) continue;
                return false;
            }
        }
        this.mAllowedSwipeDirection = this.mCallbacks.dismissDirection(pos);
        if (this.mAllowedSwipeDirection != SwipeDirection.NONE) {
            this.mVelocityTracker = VelocityTracker.obtain();
            this.mVelocityTracker.addMovement(motionEvent);
            return false;
        }
        this.resetMotion();
        return false;
    }

    private void cancel() {
        if (this.mVelocityTracker == null) {
            return;
        }
        this.mSwipeView.animate().translationX(0.0f).alpha(1.0f).setDuration(this.mAnimationTime).setListener(null);
        this.mVelocityTracker.recycle();
        this.mVelocityTracker = null;
        this.mTranslationX = 0.0f;
        this.mDownX = 0.0f;
        this.mDownY = 0.0f;
        this.mSwiping = false;
        this.mSwipeView = null;
    }

    private void up(MotionEvent motionEvent) {
        if (this.mPaused || this.mVelocityTracker == null || this.mSwipeView == null) {
            return;
        }
        this.mSwipeView.setPressed(false);
        float deltaX = motionEvent.getRawX() - this.mDownX;
        this.mVelocityTracker.addMovement(motionEvent);
        this.mVelocityTracker.computeCurrentVelocity(1000);
        float velocityX = this.mVelocityTracker.getXVelocity();
        float absVelocityX = Math.abs(velocityX);
        float absVelocityY = Math.abs(this.mVelocityTracker.getYVelocity());
        boolean dismiss = false;
        boolean dismissRight = false;
        if (Math.abs(deltaX) > (float)(this.mViewWidth / 2) && this.mSwiping) {
            dismiss = true;
            dismissRight = deltaX > 0.0f;
        } else if ((float)this.mMinFlingVelocity <= absVelocityX && absVelocityX <= (float)this.mMaxFlingVelocity && absVelocityY < absVelocityX && absVelocityY < absVelocityX && this.mSwiping) {
            dismiss = velocityX < 0.0f == deltaX < 0.0f;
            boolean bl = dismissRight = this.mVelocityTracker.getXVelocity() > 0.0f;
        }
        if (dismiss) {
            final int pos = this.mRecyclerView.getChildPosition(this.mSwipeView);
            final View swipeViewCopy = this.mSwipeView;
            final SwipeDirection swipeDirection = dismissRight ? SwipeDirection.RIGHT : SwipeDirection.LEFT;
            ++this.mDismissCount;
            this.mSwipeView.animate().translationX(dismissRight ? (float)this.mViewWidth : (float)(-this.mViewWidth)).alpha(0.0f).setDuration(this.mAnimationTime);
            swipeViewCopy.postDelayed(new Runnable(){

                @Override
                public void run() {
                    SwipeToDismissTouchListener.this.performDismiss(swipeViewCopy, pos, swipeDirection);
                    swipeViewCopy.setTranslationX(0.0f);
                }
            }, this.mAnimationTime + 100L);
        } else if (this.mSwiping) {
            this.mSwipeView.animate().translationX(0.0f).alpha(1.0f).setDuration(this.mAnimationTime).setListener(null);
        }
        this.resetMotion();
    }

    private boolean move(MotionEvent motionEvent) {
        if (this.mSwipeView == null || this.mVelocityTracker == null || this.mPaused) {
            return false;
        }
        this.mVelocityTracker.addMovement(motionEvent);
        float deltaX = motionEvent.getRawX() - this.mDownX;
        float deltaY = motionEvent.getRawY() - this.mDownY;
        if (Math.abs(deltaX) > (float)this.mSlop && Math.abs(deltaY) < Math.abs(deltaX) / 2.0f) {
            this.mSwiping = true;
            this.mSwipingSlop = deltaX > 0.0f ? this.mSlop : -this.mSlop;
            this.mSwipeView.setPressed(false);
            MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)motionEvent);
            cancelEvent.setAction(3 | motionEvent.getActionIndex() << 8);
            this.mSwipeView.onTouchEvent(cancelEvent);
        }
        if (deltaX < 0.0f && this.mAllowedSwipeDirection == SwipeDirection.RIGHT || deltaX > 0.0f && this.mAllowedSwipeDirection == SwipeDirection.LEFT) {
            this.resetMotion();
            return false;
        }
        if (this.mSwiping) {
            this.mCallbacks.onTouchDown();
            this.mTranslationX = deltaX;
            this.mSwipeView.setTranslationX(deltaX - (float)this.mSwipingSlop);
            this.mSwipeView.setAlpha(Math.max(0.0f, Math.min(1.0f, 1.0f - 2.0f * Math.abs(deltaX) / (float)this.mViewWidth)));
            return true;
        }
        return false;
    }

    private void resetMotion() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
        this.mCallbacks.onResetMotion();
        this.mTranslationX = 0.0f;
        this.mDownX = 0.0f;
        this.mDownY = 0.0f;
        this.mSwiping = false;
        this.mSwipeView = null;
        this.mAllowedSwipeDirection = SwipeDirection.NONE;
    }

    private void performDismiss(View dismissView, int pos, SwipeDirection direction) {
        --this.mDismissCount;
        this.mPendingDismisses.add(new PendingDismissData(pos, dismissView, direction));
        if (this.mDismissCount == 0) {
            Collections.sort(this.mPendingDismisses);
            ArrayList<PendingDismissData> dismissData = new ArrayList<PendingDismissData>(this.mPendingDismisses);
            this.mCallbacks.onDismiss(this.mRecyclerView, dismissData);
            this.mPendingDismisses.clear();
        }
    }

    public static enum SwipeDirection {
        LEFT,
        RIGHT,
        BOTH,
        NONE;

    }

    public class PendingDismissData
    implements Comparable<PendingDismissData> {
        public int position;
        public View view;
        public SwipeDirection direction;

        public PendingDismissData(int position, View view, SwipeDirection direction) {
            this.position = position;
            this.view = view;
            this.direction = direction;
        }

        @Override
        public int compareTo(PendingDismissData other) {
            return other.position - this.position;
        }
    }

    public static interface DismissCallbacks {
        public SwipeDirection dismissDirection(int var1);

        public void onDismiss(RecyclerView var1, List<PendingDismissData> var2);

        public void onResetMotion();

        public void onTouchDown();
    }
}

