/*
 * Decompiled with CFR 0.152.
 */
package com.marshalchen.ultimaterecyclerview;

import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;

public class ItemTouchListenerAdapter
extends GestureDetector.SimpleOnGestureListener
implements RecyclerView.OnItemTouchListener {
    private RecyclerViewOnItemClickListener listener;
    private RecyclerView recyclerView;
    private GestureDetector gestureDetector;

    public ItemTouchListenerAdapter(RecyclerView recyclerView, RecyclerViewOnItemClickListener listener) {
        if (recyclerView == null || listener == null) {
            throw new IllegalArgumentException("RecyclerView and Listener arguments can not be null");
        }
        this.recyclerView = recyclerView;
        this.listener = listener;
        this.gestureDetector = new GestureDetector(recyclerView.getContext(), (GestureDetector.OnGestureListener)this);
    }

    public boolean onInterceptTouchEvent(RecyclerView recyclerView, MotionEvent motionEvent) {
        this.gestureDetector.onTouchEvent(motionEvent);
        return false;
    }

    public void onTouchEvent(RecyclerView recyclerView, MotionEvent motionEvent) {
    }

    public void onShowPress(MotionEvent e) {
        View view = this.getChildViewUnder(e);
        if (view != null) {
            view.setPressed(true);
        }
    }

    public boolean onSingleTapUp(MotionEvent e) {
        View view = this.getChildViewUnder(e);
        if (view == null) {
            return false;
        }
        view.setPressed(false);
        int position = this.recyclerView.getChildPosition(view);
        this.listener.onItemClick(this.recyclerView, view, position);
        return true;
    }

    public void onLongPress(MotionEvent e) {
        View view = this.getChildViewUnder(e);
        if (view == null) {
            return;
        }
        int position = this.recyclerView.getChildPosition(view);
        this.listener.onItemLongClick(this.recyclerView, view, position);
        view.setPressed(false);
    }

    @Nullable
    private View getChildViewUnder(MotionEvent e) {
        return this.recyclerView.findChildViewUnder(e.getX(), e.getY());
    }

    public static interface RecyclerViewOnItemClickListener {
        public void onItemClick(RecyclerView var1, View var2, int var3);

        public void onItemLongClick(RecyclerView var1, View var2, int var3);
    }
}

