/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.modulesloader;

import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.Resource;

public class Modules {
    private List<Resource> assets;
    private List<Resource> assetDirectories;
    private List<Resource> namespaces;
    private List<Resource> options;
    private List<Resource> services;
    private List<Resource> transforms;
    private Resource propertiesFile;

    public void addModules(Modules modules) {
        this.assetDirectories = this.addLists(this.assetDirectories, modules.getAssetDirectories());
        this.namespaces = this.addLists(this.namespaces, modules.getNamespaces());
        this.options = this.addLists(this.options, modules.getOptions());
        this.services = this.addLists(this.services, modules.getServices());
        this.transforms = this.addLists(this.transforms, modules.getTransforms());
        if (modules.getPropertiesFile() != null) {
            this.propertiesFile = modules.getPropertiesFile();
        }
    }

    protected List<Resource> addLists(List<Resource> myList, List<Resource> otherList) {
        if (otherList == null) {
            return myList;
        }
        if (myList == null) {
            myList = new ArrayList<Resource>();
        }
        myList.addAll(otherList);
        return myList;
    }

    public List<Resource> getServices() {
        return this.services;
    }

    public List<Resource> getTransforms() {
        return this.transforms;
    }

    public List<Resource> getOptions() {
        return this.options;
    }

    public void setServices(List<Resource> resources) {
        this.services = resources;
    }

    public void setTransforms(List<Resource> transforms) {
        this.transforms = transforms;
    }

    public void setOptions(List<Resource> queryOptions) {
        this.options = queryOptions;
    }

    public List<Resource> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(List<Resource> namespaces) {
        this.namespaces = namespaces;
    }

    public Resource getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(Resource propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public List<Resource> getAssetDirectories() {
        return this.assetDirectories;
    }

    public void setAssetDirectories(List<Resource> assetDirectories) {
        this.assetDirectories = assetDirectories;
    }

    public List<Resource> getAssets() {
        return this.assets;
    }

    public void setAssets(List<Resource> assets) {
        this.assets = assets;
    }
}

